/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.toast;

import android.app.AppOpsManager;
import android.app.Application;
import android.app.NotificationManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.Toast;
import com.hjq.toast.IToastStyle;
import com.hjq.toast.SupportToast;
import com.hjq.toast.ToastHandler;
import com.hjq.toast.XToast;
import com.hjq.toast.style.ToastBlackStyle;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class ToastUtils {
    private static ToastHandler sToastHandler;
    private static IToastStyle sDefaultStyle;
    private static Toast sToast;

    public static void init(Application application) {
        if (sDefaultStyle == null) {
            sDefaultStyle = new ToastBlackStyle();
        }
        sToast = ToastUtils.isNotificationEnabled((Context)application) ? new XToast(application) : new SupportToast(application);
        int gravity = Build.VERSION.SDK_INT >= 17 ? Gravity.getAbsoluteGravity((int)sDefaultStyle.getGravity(), (int)application.getResources().getConfiguration().getLayoutDirection()) : sDefaultStyle.getGravity();
        sToast.setGravity(gravity, sDefaultStyle.getXOffset(), sDefaultStyle.getYOffset());
        sToast.setView((View)ToastUtils.createTextView((Context)application));
        sToastHandler = new ToastHandler(sToast);
    }

    public static void init(Application application, IToastStyle style2) {
        ToastUtils.initStyle(style2);
        ToastUtils.init(application);
    }

    public static void show(Object object) {
        ToastUtils.show(object != null ? object.toString() : "null");
    }

    public static void show(int id2) {
        ToastUtils.checkToastState();
        try {
            ToastUtils.show(sToast.getView().getContext().getResources().getText(id2));
        }
        catch (Resources.NotFoundException ignored) {
            ToastUtils.show(String.valueOf(id2));
        }
    }

    public static void show(CharSequence text) {
        ToastUtils.checkToastState();
        if (text == null || text.equals("")) {
            return;
        }
        sToastHandler.setText(text);
        sToastHandler.show();
    }

    public static void cancel() {
        ToastUtils.checkToastState();
        sToastHandler.cancel();
    }

    public static Toast getToast() {
        return sToast;
    }

    public static void setView(Context context, int layoutId) {
        if (context != context.getApplicationContext()) {
            context = context.getApplicationContext();
        }
        ToastUtils.setView(View.inflate((Context)context, (int)layoutId, null));
    }

    public static void setView(View view) {
        ToastUtils.checkToastState();
        if (view == null) {
            throw new IllegalArgumentException("Views cannot be empty");
        }
        if (sToast != null) {
            sToast.cancel();
            sToast.setView(view);
        }
    }

    public static void initStyle(IToastStyle style2) {
        sDefaultStyle = style2;
        if (sToast != null) {
            sToast.cancel();
            sToast.setView((View)ToastUtils.createTextView(sToast.getView().getContext().getApplicationContext()));
            sToast.setGravity(sDefaultStyle.getGravity(), sDefaultStyle.getXOffset(), sDefaultStyle.getYOffset());
        }
    }

    private static void checkToastState() {
        if (sToast == null) {
            throw new IllegalStateException("ToastUtils has not been initialized");
        }
    }

    private static TextView createTextView(Context context) {
        GradientDrawable drawable = new GradientDrawable();
        drawable.setColor(sDefaultStyle.getBackgroundColor());
        drawable.setCornerRadius((float)ToastUtils.dp2px(context, sDefaultStyle.getCornerRadius()));
        TextView textView = new TextView(context);
        textView.setId(16908299);
        textView.setTextColor(sDefaultStyle.getTextColor());
        textView.setTextSize(0, (float)ToastUtils.sp2px(context, sDefaultStyle.getTextSize()));
        textView.setPadding(ToastUtils.dp2px(context, sDefaultStyle.getPaddingLeft()), ToastUtils.dp2px(context, sDefaultStyle.getPaddingTop()), ToastUtils.dp2px(context, sDefaultStyle.getPaddingRight()), ToastUtils.dp2px(context, sDefaultStyle.getPaddingBottom()));
        textView.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        if (Build.VERSION.SDK_INT >= 16) {
            textView.setBackground((Drawable)drawable);
        } else {
            textView.setBackgroundDrawable((Drawable)drawable);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            textView.setZ((float)sDefaultStyle.getZ());
        }
        if (sDefaultStyle.getMaxLines() > 0) {
            textView.setMaxLines(sDefaultStyle.getMaxLines());
        }
        return textView;
    }

    private static int dp2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    private static int sp2px(Context context, float spValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }

    public static boolean isNotificationEnabled(Context context) {
        if (Build.VERSION.SDK_INT >= 24) {
            return ((NotificationManager)context.getSystemService("notification")).areNotificationsEnabled();
        }
        if (Build.VERSION.SDK_INT >= 19) {
            AppOpsManager appOps = (AppOpsManager)context.getSystemService("appops");
            ApplicationInfo appInfo = context.getApplicationInfo();
            String pkg = context.getApplicationContext().getPackageName();
            int uid = appInfo.uid;
            try {
                Class<?> appOpsClass = Class.forName(AppOpsManager.class.getName());
                Method checkOpNoThrowMethod = appOpsClass.getMethod("checkOpNoThrow", Integer.TYPE, Integer.TYPE, String.class);
                Field opPostNotificationValue = appOpsClass.getDeclaredField("OP_POST_NOTIFICATION");
                int value = (Integer)opPostNotificationValue.get(Integer.class);
                return (Integer)checkOpNoThrowMethod.invoke((Object)appOps, value, uid, pkg) == 0;
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | RuntimeException | InvocationTargetException ignored) {
                return true;
            }
        }
        return true;
    }
}

