/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.toast;

import android.app.Application;
import android.os.Handler;
import android.os.Looper;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Toast;
import com.hjq.toast.WindowHelper;

final class ToastHelper
implements Runnable {
    static final int SHORT_DURATION_TIMEOUT = 2000;
    static final int LONG_DURATION_TIMEOUT = 3500;
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private final Toast mToast;
    private final WindowHelper mWindowHelper;
    private final String mPackageName;
    private boolean isShow;

    ToastHelper(Toast toast, Application application) {
        this.mToast = toast;
        this.mPackageName = application.getPackageName();
        this.mWindowHelper = new WindowHelper(this, application);
    }

    void show() {
        if (!this.isShow) {
            WindowManager.LayoutParams params = new WindowManager.LayoutParams();
            params.height = -2;
            params.width = -2;
            params.format = -3;
            params.windowAnimations = 16973828;
            params.setTitle((CharSequence)Toast.class.getSimpleName());
            params.flags = 152;
            params.packageName = this.mPackageName;
            params.gravity = this.mToast.getGravity();
            params.x = this.mToast.getXOffset();
            params.y = this.mToast.getYOffset();
            try {
                this.mWindowHelper.getWindowManager().addView(this.mToast.getView(), (ViewGroup.LayoutParams)params);
                this.isShow = true;
                this.mHandler.postDelayed((Runnable)this, this.mToast.getDuration() == 1 ? 3500L : 2000L);
            }
            catch (WindowManager.BadTokenException | IllegalStateException | NullPointerException throwable) {
                // empty catch block
            }
        }
    }

    void cancel() {
        this.mHandler.removeCallbacks((Runnable)this);
        if (this.isShow) {
            try {
                this.mWindowHelper.getWindowManager().removeView(this.mToast.getView());
            }
            catch (IllegalArgumentException | NullPointerException runtimeException) {
                // empty catch block
            }
            this.isShow = false;
        }
    }

    @Override
    public void run() {
        this.cancel();
    }
}

