/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.toast;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.os.Bundle;

final class ActivityStack
implements Application.ActivityLifecycleCallbacks {
    @SuppressLint(value={"StaticFieldLeak"})
    private static volatile ActivityStack sInstance;
    private Activity mFocusActivity;
    private Activity mVisibleActivity;
    private long mActivityResumedTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ActivityStack getInstance() {
        if (sInstance != null) return sInstance;
        Class<ActivityStack> clazz = ActivityStack.class;
        synchronized (ActivityStack.class) {
            if (sInstance != null) return sInstance;
            sInstance = new ActivityStack();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private ActivityStack() {
    }

    public void register(Application application) {
        if (application == null) {
            return;
        }
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
    }

    public Activity getFocusActivity() {
        return this.mFocusActivity;
    }

    public Activity getVisibleActivity() {
        return this.mVisibleActivity;
    }

    public long getActivityResumedTime() {
        return this.mActivityResumedTime;
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(Activity activity) {
        this.mFocusActivity = activity;
    }

    public void onActivityResumed(Activity activity) {
        this.mVisibleActivity = activity;
        this.mActivityResumedTime = System.currentTimeMillis();
    }

    public void onActivityPaused(Activity activity) {
        if (this.mFocusActivity != activity) {
            return;
        }
        this.mFocusActivity = null;
    }

    public void onActivityStopped(Activity activity) {
        if (this.mVisibleActivity != activity) {
            return;
        }
        this.mVisibleActivity = null;
        this.mActivityResumedTime = 0L;
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }
}

