/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.toast;

import android.app.Application;
import android.content.res.Resources;
import com.hjq.toast.ToastLogInterceptor;
import com.hjq.toast.ToastParams;
import com.hjq.toast.ToastStrategy;
import com.hjq.toast.config.IToastInterceptor;
import com.hjq.toast.config.IToastStrategy;
import com.hjq.toast.config.IToastStyle;
import com.hjq.toast.style.BlackToastStyle;
import com.hjq.toast.style.CustomToastStyle;
import com.hjq.toast.style.LocationToastStyle;

public final class Toaster {
    private static Application sApplication;
    private static IToastStrategy sToastStrategy;
    private static IToastStyle<?> sToastStyle;
    private static IToastInterceptor sToastInterceptor;
    private static Boolean sDebugMode;

    private Toaster() {
    }

    public static void init(Application application) {
        Toaster.init(application, sToastStyle);
    }

    public static void init(Application application, IToastStrategy strategy) {
        Toaster.init(application, strategy, null);
    }

    public static void init(Application application, IToastStyle<?> style2) {
        Toaster.init(application, null, style2);
    }

    public static void init(Application application, IToastStrategy strategy, IToastStyle<?> style2) {
        sApplication = application;
        if (strategy == null) {
            strategy = new ToastStrategy();
        }
        Toaster.setStrategy(strategy);
        if (style2 == null) {
            style2 = new BlackToastStyle();
        }
        Toaster.setStyle(style2);
    }

    public static boolean isInit() {
        return sApplication != null && sToastStrategy != null && sToastStyle != null;
    }

    public static void delayedShow(int id2, long delayMillis) {
        Toaster.delayedShow(Toaster.stringIdToCharSequence(id2), delayMillis);
    }

    public static void delayedShow(Object object, long delayMillis) {
        Toaster.delayedShow(Toaster.objectToCharSequence(object), delayMillis);
    }

    public static void delayedShow(CharSequence text, long delayMillis) {
        ToastParams params = new ToastParams();
        params.text = text;
        params.delayMillis = delayMillis;
        Toaster.show(params);
    }

    public static void debugShow(int id2) {
        Toaster.debugShow(Toaster.stringIdToCharSequence(id2));
    }

    public static void debugShow(Object object) {
        Toaster.debugShow(Toaster.objectToCharSequence(object));
    }

    public static void debugShow(CharSequence text) {
        if (!Toaster.isDebugMode()) {
            return;
        }
        ToastParams params = new ToastParams();
        params.text = text;
        Toaster.show(params);
    }

    public static void showShort(int id2) {
        Toaster.showShort(Toaster.stringIdToCharSequence(id2));
    }

    public static void showShort(Object object) {
        Toaster.showShort(Toaster.objectToCharSequence(object));
    }

    public static void showShort(CharSequence text) {
        ToastParams params = new ToastParams();
        params.text = text;
        params.duration = 0;
        Toaster.show(params);
    }

    public static void showLong(int id2) {
        Toaster.showLong(Toaster.stringIdToCharSequence(id2));
    }

    public static void showLong(Object object) {
        Toaster.showLong(Toaster.objectToCharSequence(object));
    }

    public static void showLong(CharSequence text) {
        ToastParams params = new ToastParams();
        params.text = text;
        params.duration = 1;
        Toaster.show(params);
    }

    public static void show(int id2) {
        Toaster.show(Toaster.stringIdToCharSequence(id2));
    }

    public static void show(Object object) {
        Toaster.show(Toaster.objectToCharSequence(object));
    }

    public static void show(CharSequence text) {
        ToastParams params = new ToastParams();
        params.text = text;
        Toaster.show(params);
    }

    public static void show(ToastParams params) {
        Toaster.checkInitStatus();
        if (params.text == null || params.text.length() == 0) {
            return;
        }
        if (params.strategy == null) {
            params.strategy = sToastStrategy;
        }
        if (params.interceptor == null) {
            if (sToastInterceptor == null) {
                sToastInterceptor = new ToastLogInterceptor();
            }
            params.interceptor = sToastInterceptor;
        }
        if (params.style == null) {
            params.style = sToastStyle;
        }
        if (params.interceptor.intercept(params)) {
            return;
        }
        if (params.duration == -1) {
            params.duration = params.text.length() > 20 ? 1 : 0;
        }
        params.strategy.showToast(params);
    }

    public static void cancel() {
        sToastStrategy.cancelToast();
    }

    public static void setGravity(int gravity) {
        Toaster.setGravity(gravity, 0, 0);
    }

    public static void setGravity(int gravity, int xOffset, int yOffset) {
        Toaster.setGravity(gravity, xOffset, yOffset, 0.0f, 0.0f);
    }

    public static void setGravity(int gravity, int xOffset, int yOffset, float horizontalMargin, float verticalMargin) {
        sToastStyle = new LocationToastStyle(sToastStyle, gravity, xOffset, yOffset, horizontalMargin, verticalMargin);
    }

    public static void setView(int id2) {
        if (id2 <= 0) {
            return;
        }
        if (sToastStyle == null) {
            return;
        }
        Toaster.setStyle(new CustomToastStyle(id2, sToastStyle.getGravity(), sToastStyle.getXOffset(), sToastStyle.getYOffset(), sToastStyle.getHorizontalMargin(), sToastStyle.getVerticalMargin()));
    }

    public static void setStyle(IToastStyle<?> style2) {
        if (style2 == null) {
            return;
        }
        sToastStyle = style2;
    }

    public static IToastStyle<?> getStyle() {
        return sToastStyle;
    }

    public static void setStrategy(IToastStrategy strategy) {
        if (strategy == null) {
            return;
        }
        sToastStrategy = strategy;
        sToastStrategy.registerStrategy(sApplication);
    }

    public static IToastStrategy getStrategy() {
        return sToastStrategy;
    }

    public static void setInterceptor(IToastInterceptor interceptor) {
        sToastInterceptor = interceptor;
    }

    public static IToastInterceptor getInterceptor() {
        return sToastInterceptor;
    }

    public static void setDebugMode(boolean debug) {
        sDebugMode = debug;
    }

    private static void checkInitStatus() {
        if (sApplication == null) {
            throw new IllegalStateException("Toaster has not been initialized");
        }
    }

    static boolean isDebugMode() {
        if (sDebugMode == null) {
            Toaster.checkInitStatus();
            sDebugMode = (Toaster.sApplication.getApplicationInfo().flags & 2) != 0;
        }
        return sDebugMode;
    }

    private static CharSequence stringIdToCharSequence(int id2) {
        Toaster.checkInitStatus();
        try {
            return sApplication.getResources().getText(id2);
        }
        catch (Resources.NotFoundException ignored) {
            return String.valueOf(id2);
        }
    }

    private static CharSequence objectToCharSequence(Object object) {
        return object != null ? object.toString() : "null";
    }
}

