/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.toast;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AppOpsManager;
import android.app.Application;
import android.app.NotificationManager;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import android.view.View;
import com.hjq.toast.ActivityStack;
import com.hjq.toast.ActivityToast;
import com.hjq.toast.CustomToast;
import com.hjq.toast.NotificationToast;
import com.hjq.toast.SafeToast;
import com.hjq.toast.SystemToast;
import com.hjq.toast.WindowToast;
import com.hjq.toast.config.IToast;
import com.hjq.toast.config.IToastStrategy;
import com.hjq.toast.config.IToastStyle;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ToastStrategy
implements IToastStrategy {
    private static final Handler HANDLER = new Handler(Looper.getMainLooper());
    private static final int DELAY_TIMEOUT = 200;
    private Application mApplication;
    private ActivityStack mActivityStack;
    private WeakReference<IToast> mToastReference;
    private IToastStyle<?> mToastStyle;
    private volatile CharSequence mLatestText;
    private final Runnable mShowRunnable = new Runnable(){

        @Override
        public void run() {
            IToast toast = null;
            if (ToastStrategy.this.mToastReference != null) {
                toast = (IToast)ToastStrategy.this.mToastReference.get();
            }
            if (toast != null) {
                toast.cancel();
            }
            toast = ToastStrategy.this.createToast(ToastStrategy.this.mApplication);
            ToastStrategy.this.mToastReference = new WeakReference<IToast>(toast);
            toast.setDuration(ToastStrategy.this.getToastDuration(ToastStrategy.this.mLatestText));
            toast.setText(ToastStrategy.this.mLatestText);
            toast.show();
        }
    };
    private final Runnable mCancelRunnable = new Runnable(){

        @Override
        public void run() {
            IToast toast = null;
            if (ToastStrategy.this.mToastReference != null) {
                toast = (IToast)ToastStrategy.this.mToastReference.get();
            }
            if (toast == null) {
                return;
            }
            toast.cancel();
        }
    };

    @Override
    public void registerStrategy(Application application) {
        this.mApplication = application;
        this.mActivityStack = ActivityStack.register(application);
    }

    @Override
    public void bindStyle(IToastStyle<?> style2) {
        this.mToastStyle = style2;
    }

    @Override
    public IToast createToast(Application application) {
        Activity foregroundActivity = this.mActivityStack.getForegroundActivity();
        IToast toast = Build.VERSION.SDK_INT >= 23 && Settings.canDrawOverlays((Context)application) ? new WindowToast(application) : (foregroundActivity != null ? new ActivityToast(foregroundActivity) : (Build.VERSION.SDK_INT == 25 ? new SafeToast(application) : (Build.VERSION.SDK_INT < 29 && !this.areNotificationsEnabled((Context)application) ? new NotificationToast(application) : new SystemToast(application))));
        if (toast instanceof CustomToast || Build.VERSION.SDK_INT < 30 || application.getApplicationInfo().targetSdkVersion < 30) {
            toast.setView((View)this.mToastStyle.createView((Context)application));
            toast.setGravity(this.mToastStyle.getGravity(), this.mToastStyle.getXOffset(), this.mToastStyle.getYOffset());
            toast.setMargin(this.mToastStyle.getHorizontalMargin(), this.mToastStyle.getVerticalMargin());
        }
        return toast;
    }

    @Override
    public void showToast(CharSequence text, long delayMillis) {
        this.mLatestText = text;
        HANDLER.removeCallbacks(this.mShowRunnable);
        HANDLER.postDelayed(this.mShowRunnable, delayMillis + 200L);
    }

    @Override
    public void cancelToast() {
        HANDLER.removeCallbacks(this.mCancelRunnable);
        HANDLER.post(this.mCancelRunnable);
    }

    protected int getToastDuration(CharSequence text) {
        return text.length() > 20 ? 1 : 0;
    }

    @SuppressLint(value={"PrivateApi"})
    protected boolean areNotificationsEnabled(Context context) {
        if (Build.VERSION.SDK_INT >= 24) {
            return ((NotificationManager)context.getSystemService(NotificationManager.class)).areNotificationsEnabled();
        }
        if (Build.VERSION.SDK_INT >= 19) {
            AppOpsManager appOps = (AppOpsManager)context.getSystemService("appops");
            try {
                Method method = appOps.getClass().getMethod("checkOpNoThrow", Integer.TYPE, Integer.TYPE, String.class);
                Field field = appOps.getClass().getDeclaredField("OP_POST_NOTIFICATION");
                int value = (Integer)field.get(Integer.class);
                return (Integer)method.invoke((Object)appOps, value, context.getApplicationInfo().uid, context.getPackageName()) == 0;
            }
            catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | RuntimeException | InvocationTargetException e) {
                e.printStackTrace();
                return true;
            }
        }
        return true;
    }
}

