/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.toast;

import android.app.Activity;
import android.view.View;
import android.widget.TextView;
import com.hjq.toast.ToastImpl;
import com.hjq.toast.config.IToast;

public class ActivityToast
implements IToast {
    private final ToastImpl mToastImpl;
    private View mView;
    private TextView mMessageView;
    private int mGravity;
    private int mDuration;
    private int mXOffset;
    private int mYOffset;
    private float mHorizontalMargin;
    private float mVerticalMargin;
    private int mAnimations = 16973828;
    private int mShortDuration = 2000;
    private int mLongDuration = 3500;

    public ActivityToast(Activity activity) {
        this.mToastImpl = new ToastImpl(activity, this);
    }

    @Override
    public void show() {
        this.mToastImpl.show();
    }

    @Override
    public void cancel() {
        this.mToastImpl.cancel();
    }

    @Override
    public void setText(int id2) {
        if (this.mView == null) {
            return;
        }
        this.setText(this.mView.getResources().getString(id2));
    }

    @Override
    public void setText(CharSequence text) {
        if (this.mMessageView == null) {
            return;
        }
        this.mMessageView.setText(text);
    }

    @Override
    public void setView(View view) {
        this.mView = view;
        if (this.mView == null) {
            this.mMessageView = null;
            return;
        }
        this.mMessageView = this.findMessageView(view);
    }

    @Override
    public View getView() {
        return this.mView;
    }

    @Override
    public void setDuration(int duration) {
        this.mDuration = duration;
    }

    @Override
    public int getDuration() {
        return this.mDuration;
    }

    @Override
    public void setGravity(int gravity, int xOffset, int yOffset) {
        this.mGravity = gravity;
        this.mXOffset = xOffset;
        this.mYOffset = yOffset;
    }

    @Override
    public int getGravity() {
        return this.mGravity;
    }

    @Override
    public int getXOffset() {
        return this.mXOffset;
    }

    @Override
    public int getYOffset() {
        return this.mYOffset;
    }

    @Override
    public void setMargin(float horizontalMargin, float verticalMargin) {
        this.mHorizontalMargin = horizontalMargin;
        this.mVerticalMargin = verticalMargin;
    }

    @Override
    public float getHorizontalMargin() {
        return this.mHorizontalMargin;
    }

    @Override
    public float getVerticalMargin() {
        return this.mVerticalMargin;
    }

    public void setAnimationsId(int animationsId) {
        this.mAnimations = animationsId;
    }

    public int getAnimationsId() {
        return this.mAnimations;
    }

    public void setShortDuration(int duration) {
        this.mShortDuration = duration;
    }

    public int getShortDuration() {
        return this.mShortDuration;
    }

    public void setLongDuration(int duration) {
        this.mLongDuration = duration;
    }

    public int getLongDuration() {
        return this.mLongDuration;
    }
}

