/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.bar;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.hjq.bar.ITitleBarStyle;
import com.hjq.bar.OnTitleBarListener;
import com.hjq.bar.R;
import com.hjq.bar.TitleBarSupport;
import com.hjq.bar.style.LightBarStyle;
import com.hjq.bar.style.NightBarStyle;
import com.hjq.bar.style.RippleBarStyle;
import com.hjq.bar.style.TransparentBarStyle;

public class TitleBar
extends FrameLayout
implements View.OnClickListener,
View.OnLayoutChangeListener {
    private static ITitleBarStyle sGlobalStyle;
    private final ITitleBarStyle mCurrentStyle;
    private OnTitleBarListener mListener;
    private final TextView mLeftView;
    private final TextView mTitleView;
    private final TextView mRightView;
    private final View mLineView;
    private int mHorizontalPadding;
    private int mVerticalPadding;
    private int mLeftIconWidth;
    private int mLeftIconHeight;
    private int mTitleIconWidth;
    private int mTitleIconHeight;
    private int mRightIconWidth;
    private int mRightIconHeight;
    private int mLeftIconGravity;
    private int mTitleIconGravity;
    private int mRightIconGravity;

    public TitleBar(Context context) {
        this(context, null);
    }

    public TitleBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TitleBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        CharSequence label;
        if (sGlobalStyle == null) {
            sGlobalStyle = new LightBarStyle();
        }
        TypedArray array = this.getContext().obtainStyledAttributes(attrs, R.styleable.TitleBar, 0, R.style.TitleBarStyle);
        switch (array.getInt(R.styleable.TitleBar_barStyle, 0)) {
            case 16: {
                this.mCurrentStyle = new LightBarStyle();
                break;
            }
            case 32: {
                this.mCurrentStyle = new NightBarStyle();
                break;
            }
            case 48: {
                this.mCurrentStyle = new TransparentBarStyle();
                break;
            }
            case 64: {
                this.mCurrentStyle = new RippleBarStyle();
                break;
            }
            default: {
                this.mCurrentStyle = sGlobalStyle;
            }
        }
        this.mTitleView = this.mCurrentStyle.createTitleView(context);
        this.mLeftView = this.mCurrentStyle.createLeftView(context);
        this.mRightView = this.mCurrentStyle.createRightView(context);
        this.mLineView = this.mCurrentStyle.createLineView(context);
        this.mTitleView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -1, 1));
        this.mLeftView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -1, 0x800003));
        this.mRightView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -1, 0x800005));
        this.mLineView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, this.mCurrentStyle.getLineSize(this.getContext()), 80));
        this.setLeftIconGravity(array.getInt(R.styleable.TitleBar_leftIconGravity, this.mCurrentStyle.getLeftIconGravity(this.getContext())));
        this.setTitleIconGravity(array.getInt(R.styleable.TitleBar_titleIconGravity, this.mCurrentStyle.getTitleIconGravity(this.getContext())));
        this.setRightIconGravity(array.getInt(R.styleable.TitleBar_rightIconGravity, this.mCurrentStyle.getRightIconGravity(this.getContext())));
        this.setLeftIconSize(array.getDimensionPixelSize(R.styleable.TitleBar_leftIconWidth, this.mCurrentStyle.getLeftIconWidth(this.getContext())), array.getDimensionPixelSize(R.styleable.TitleBar_leftIconHeight, this.mCurrentStyle.getLeftIconHeight(this.getContext())));
        this.setTitleIconSize(array.getDimensionPixelSize(R.styleable.TitleBar_titleIconWidth, this.mCurrentStyle.getTitleIconWidth(this.getContext())), array.getDimensionPixelSize(R.styleable.TitleBar_titleIconHeight, this.mCurrentStyle.getTitleIconHeight(this.getContext())));
        this.setRightIconSize(array.getDimensionPixelSize(R.styleable.TitleBar_rightIconWidth, this.mCurrentStyle.getRightIconWidth(this.getContext())), array.getDimensionPixelSize(R.styleable.TitleBar_rightIconHeight, this.mCurrentStyle.getRightIconHeight(this.getContext())));
        this.setLeftIconPadding(array.getDimensionPixelSize(R.styleable.TitleBar_leftIconPadding, this.mCurrentStyle.getLeftIconPadding(this.getContext())));
        this.setTitleIconPadding(array.getDimensionPixelSize(R.styleable.TitleBar_titleIconPadding, this.mCurrentStyle.getTitleIconPadding(this.getContext())));
        this.setRightIconPadding(array.getDimensionPixelSize(R.styleable.TitleBar_rightIconPadding, this.mCurrentStyle.getRightIconPadding(this.getContext())));
        if (array.hasValue(R.styleable.TitleBar_leftTitle)) {
            this.setLeftTitle(array.getString(R.styleable.TitleBar_leftTitle));
        }
        if (array.hasValue(R.styleable.TitleBar_title)) {
            this.setTitle(array.getString(R.styleable.TitleBar_title));
        } else if (context instanceof Activity && !TextUtils.isEmpty((CharSequence)(label = ((Activity)context).getTitle()))) {
            try {
                PackageManager packageManager = context.getPackageManager();
                PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
                if (!label.toString().equals(packageInfo.applicationInfo.loadLabel(packageManager).toString())) {
                    this.setTitle(label);
                }
            }
            catch (PackageManager.NameNotFoundException packageManager) {
                // empty catch block
            }
        }
        if (array.hasValue(R.styleable.TitleBar_rightTitle)) {
            this.setRightTitle(array.getString(R.styleable.TitleBar_rightTitle));
        }
        if (array.hasValue(R.styleable.TitleBar_leftIcon)) {
            if (array.getResourceId(R.styleable.TitleBar_leftIcon, 0) == R.drawable.bar_drawable_placeholder) {
                this.setLeftIcon(this.mCurrentStyle.getBackButtonDrawable(this.getContext()));
            } else {
                this.setLeftIcon(TitleBarSupport.getDrawable(this.getContext(), array.getResourceId(R.styleable.TitleBar_leftIcon, 0)));
            }
        }
        if (array.hasValue(R.styleable.TitleBar_titleIcon)) {
            this.setTitleIcon(TitleBarSupport.getDrawable(this.getContext(), array.getResourceId(R.styleable.TitleBar_titleIcon, 0)));
        }
        if (array.hasValue(R.styleable.TitleBar_rightIcon)) {
            this.setRightIcon(TitleBarSupport.getDrawable(this.getContext(), array.getResourceId(R.styleable.TitleBar_rightIcon, 0)));
        }
        if (array.hasValue(R.styleable.TitleBar_leftIconTint)) {
            this.setLeftIconTint(array.getColor(R.styleable.TitleBar_leftIconTint, 0));
        }
        if (array.hasValue(R.styleable.TitleBar_titleIconTint)) {
            this.setTitleIconTint(array.getColor(R.styleable.TitleBar_titleIconTint, 0));
        }
        if (array.hasValue(R.styleable.TitleBar_rightIconTint)) {
            this.setRightIconTint(array.getColor(R.styleable.TitleBar_rightIconTint, 0));
        }
        this.setLeftTitleColor(array.getColor(R.styleable.TitleBar_leftTitleColor, this.mCurrentStyle.getLeftTitleColor(this.getContext())));
        this.setTitleColor(array.getColor(R.styleable.TitleBar_titleColor, this.mCurrentStyle.getTitleTitleColor(this.getContext())));
        this.setRightTitleColor(array.getColor(R.styleable.TitleBar_rightTitleColor, this.mCurrentStyle.getRightTitleColor(this.getContext())));
        this.setLeftTitleSize(0, array.getDimensionPixelSize(R.styleable.TitleBar_leftTitleSize, this.mCurrentStyle.getLeftTitleSize(this.getContext())));
        this.setTitleSize(0, array.getDimensionPixelSize(R.styleable.TitleBar_titleSize, this.mCurrentStyle.getTitleTitleSize(this.getContext())));
        this.setRightTitleSize(0, array.getDimensionPixelSize(R.styleable.TitleBar_rightTitleSize, this.mCurrentStyle.getRightTitleSize(this.getContext())));
        if (array.hasValue(R.styleable.TitleBar_android_background) && array.getResourceId(R.styleable.TitleBar_android_background, 0) == R.drawable.bar_drawable_placeholder) {
            TitleBarSupport.setBackground((View)this, this.mCurrentStyle.getTitleBarBackground(context));
        }
        if (array.hasValue(R.styleable.TitleBar_leftBackground)) {
            if (array.getResourceId(R.styleable.TitleBar_leftBackground, 0) == R.drawable.bar_drawable_placeholder) {
                this.setLeftBackground(this.mCurrentStyle.getLeftTitleBackground(this.getContext()));
            } else {
                this.setLeftBackground(array.getDrawable(R.styleable.TitleBar_leftBackground));
            }
        }
        if (array.hasValue(R.styleable.TitleBar_rightBackground)) {
            if (array.getResourceId(R.styleable.TitleBar_rightBackground, 0) == R.drawable.bar_drawable_placeholder) {
                this.setRightBackground(this.mCurrentStyle.getRightTitleBackground(this.getContext()));
            } else {
                this.setRightBackground(array.getDrawable(R.styleable.TitleBar_rightBackground));
            }
        }
        if (array.hasValue(R.styleable.TitleBar_lineDrawable)) {
            this.setLineDrawable(array.getDrawable(R.styleable.TitleBar_lineDrawable));
        } else {
            this.setLineDrawable(this.mCurrentStyle.getLineDrawable(this.getContext()));
        }
        if (array.hasValue(R.styleable.TitleBar_titleGravity)) {
            this.setTitleGravity(array.getInt(R.styleable.TitleBar_titleGravity, 0));
        }
        if (array.hasValue(R.styleable.TitleBar_leftTitleStyle)) {
            this.setLeftTitleStyle(Typeface.defaultFromStyle((int)array.getInt(R.styleable.TitleBar_leftTitleStyle, 0)));
        }
        if (array.hasValue(R.styleable.TitleBar_titleStyle)) {
            this.setTitleStyle(Typeface.defaultFromStyle((int)array.getInt(R.styleable.TitleBar_titleStyle, 0)));
        }
        if (array.hasValue(R.styleable.TitleBar_rightTitleStyle)) {
            this.setRightTitleStyle(Typeface.defaultFromStyle((int)array.getInt(R.styleable.TitleBar_rightTitleStyle, 0)));
        }
        if (array.hasValue(R.styleable.TitleBar_lineVisible)) {
            this.setLineVisible(array.getBoolean(R.styleable.TitleBar_lineVisible, false));
        }
        if (array.hasValue(R.styleable.TitleBar_lineSize)) {
            this.setLineSize(array.getDimensionPixelSize(R.styleable.TitleBar_lineSize, 0));
        }
        if (array.hasValue(R.styleable.TitleBar_childPaddingHorizontal) || array.hasValue(R.styleable.TitleBar_childPaddingVertical)) {
            this.setPadding(0, 0, 0, 0);
        }
        this.mHorizontalPadding = array.getDimensionPixelSize(R.styleable.TitleBar_childPaddingHorizontal, this.mCurrentStyle.getChildHorizontalPadding(this.getContext()));
        this.mVerticalPadding = array.getDimensionPixelSize(R.styleable.TitleBar_childPaddingVertical, this.mCurrentStyle.getChildVerticalPadding(this.getContext()));
        array.recycle();
        this.addView((View)this.mTitleView, 0);
        this.addView((View)this.mLeftView, 1);
        this.addView((View)this.mRightView, 2);
        this.addView(this.mLineView, 3);
        this.addOnLayoutChangeListener(this);
        if (this.isInEditMode()) {
            this.measure(0, 0);
            this.mTitleView.measure(0, 0);
            this.mLeftView.measure(0, 0);
            this.mRightView.measure(0, 0);
            int horizontalMargin = Math.max(this.mLeftView.getMeasuredWidth(), this.mRightView.getMeasuredWidth()) + this.mHorizontalPadding;
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.mTitleView.getLayoutParams();
            layoutParams.setMargins(horizontalMargin, 0, horizontalMargin, 0);
        }
    }

    public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        this.removeOnLayoutChangeListener(this);
        if (this.mLeftView.getMaxWidth() != Integer.MAX_VALUE && this.mTitleView.getMaxWidth() != Integer.MAX_VALUE && this.mRightView.getMaxWidth() != Integer.MAX_VALUE) {
            this.mLeftView.setMaxWidth(Integer.MAX_VALUE);
            this.mTitleView.setMaxWidth(Integer.MAX_VALUE);
            this.mRightView.setMaxWidth(Integer.MAX_VALUE);
            this.mLeftView.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
            this.mTitleView.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
            this.mRightView.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        }
        int barWidth = right - left;
        int sideWidth = Math.max(this.mLeftView.getMeasuredWidth(), this.mRightView.getMeasuredWidth());
        int maxWidth = sideWidth * 2 + this.mTitleView.getMeasuredWidth();
        if (maxWidth >= barWidth) {
            if (sideWidth > barWidth / 3) {
                this.mLeftView.setMaxWidth(barWidth / 4);
                this.mTitleView.setMaxWidth(barWidth / 2);
                this.mRightView.setMaxWidth(barWidth / 4);
            } else {
                this.mLeftView.setMaxWidth(sideWidth);
                this.mTitleView.setMaxWidth(barWidth - sideWidth * 2);
                this.mRightView.setMaxWidth(sideWidth);
            }
        } else if (this.mLeftView.getMaxWidth() != Integer.MAX_VALUE && this.mTitleView.getMaxWidth() != Integer.MAX_VALUE && this.mRightView.getMaxWidth() != Integer.MAX_VALUE) {
            this.mLeftView.setMaxWidth(Integer.MAX_VALUE);
            this.mTitleView.setMaxWidth(Integer.MAX_VALUE);
            this.mRightView.setMaxWidth(Integer.MAX_VALUE);
        }
        this.mLeftView.setEnabled(TitleBarSupport.isContainContent(this.mLeftView));
        this.mTitleView.setEnabled(TitleBarSupport.isContainContent(this.mTitleView));
        this.mRightView.setEnabled(TitleBarSupport.isContainContent(this.mRightView));
        this.post(new Runnable(){

            @Override
            public void run() {
                TitleBar.this.addOnLayoutChangeListener(TitleBar.this);
            }
        });
    }

    public void onClick(View view) {
        if (this.mListener == null) {
            return;
        }
        if (view == this.mLeftView) {
            this.mListener.onLeftClick(view);
        } else if (view == this.mRightView) {
            this.mListener.onRightClick(view);
        } else if (view == this.mTitleView) {
            this.mListener.onTitleClick(view);
        }
    }

    public void setLayoutParams(ViewGroup.LayoutParams params) {
        if (params.width == -2) {
            params.width = -1;
        }
        int horizontalPadding = this.mHorizontalPadding;
        int verticalPadding = 0;
        if (params.height == -2) {
            verticalPadding = this.mVerticalPadding;
        }
        this.setChildPadding(horizontalPadding, verticalPadding);
        super.setLayoutParams(params);
    }

    protected FrameLayout.LayoutParams generateDefaultLayoutParams() {
        return new FrameLayout.LayoutParams(-1, -2);
    }

    public TitleBar setOnTitleBarListener(OnTitleBarListener listener) {
        this.mListener = listener;
        this.mTitleView.setOnClickListener((View.OnClickListener)this);
        this.mLeftView.setOnClickListener((View.OnClickListener)this);
        this.mRightView.setOnClickListener((View.OnClickListener)this);
        return this;
    }

    public TitleBar setTitle(int id) {
        return this.setTitle(this.getResources().getString(id));
    }

    public TitleBar setTitle(CharSequence text) {
        this.mTitleView.setText(text);
        return this;
    }

    public CharSequence getTitle() {
        return this.mTitleView.getText();
    }

    public TitleBar setLeftTitle(int id) {
        return this.setLeftTitle(this.getResources().getString(id));
    }

    public TitleBar setLeftTitle(CharSequence text) {
        this.mLeftView.setText(text);
        return this;
    }

    public CharSequence getLeftTitle() {
        return this.mLeftView.getText();
    }

    public TitleBar setRightTitle(int id) {
        return this.setRightTitle(this.getResources().getString(id));
    }

    public TitleBar setRightTitle(CharSequence text) {
        this.mRightView.setText(text);
        return this;
    }

    public CharSequence getRightTitle() {
        return this.mRightView.getText();
    }

    public TitleBar setLeftIconTint(int color) {
        TitleBarSupport.setDrawableTint(this.getLeftIcon(), color);
        return this;
    }

    public TitleBar setLeftIcon(int id) {
        return this.setLeftIcon(TitleBarSupport.getDrawable(this.getContext(), id));
    }

    public TitleBar setLeftIcon(Drawable drawable2) {
        TitleBarSupport.setDrawableSize(drawable2, this.mLeftIconWidth, this.mLeftIconHeight);
        TitleBarSupport.setTextCompoundDrawable(this.mLeftView, drawable2, this.mLeftIconGravity);
        return this;
    }

    public Drawable getLeftIcon() {
        return TitleBarSupport.getTextCompoundDrawable(this.mLeftView, this.mLeftIconGravity);
    }

    public TitleBar setLeftIconPadding(int padding) {
        this.mLeftView.setCompoundDrawablePadding(padding);
        return this;
    }

    public TitleBar setTitleIconTint(int color) {
        TitleBarSupport.setDrawableTint(this.getTitleIcon(), color);
        return this;
    }

    public TitleBar setTitleIcon(int id) {
        return this.setTitleIcon(TitleBarSupport.getDrawable(this.getContext(), id));
    }

    public TitleBar setTitleIcon(Drawable drawable2) {
        TitleBarSupport.setDrawableSize(drawable2, this.mTitleIconWidth, this.mTitleIconHeight);
        TitleBarSupport.setTextCompoundDrawable(this.mTitleView, drawable2, this.mTitleIconGravity);
        return this;
    }

    public Drawable getTitleIcon() {
        return TitleBarSupport.getTextCompoundDrawable(this.mTitleView, this.mTitleIconGravity);
    }

    public TitleBar setTitleIconPadding(int padding) {
        this.mTitleView.setCompoundDrawablePadding(padding);
        return this;
    }

    public TitleBar setRightIconTint(int color) {
        TitleBarSupport.setDrawableTint(this.getRightIcon(), color);
        return this;
    }

    public TitleBar setRightIcon(int id) {
        return this.setRightIcon(TitleBarSupport.getDrawable(this.getContext(), id));
    }

    public TitleBar setRightIcon(Drawable drawable2) {
        TitleBarSupport.setDrawableSize(drawable2, this.mRightIconWidth, this.mRightIconHeight);
        TitleBarSupport.setTextCompoundDrawable(this.mRightView, drawable2, this.mRightIconGravity);
        return this;
    }

    public Drawable getRightIcon() {
        return TitleBarSupport.getTextCompoundDrawable(this.mRightView, this.mRightIconGravity);
    }

    public TitleBar setRightIconPadding(int padding) {
        this.mRightView.setCompoundDrawablePadding(padding);
        return this;
    }

    public TitleBar setLeftIconSize(int width, int height) {
        this.mLeftIconWidth = width;
        this.mLeftIconHeight = height;
        TitleBarSupport.setDrawableSize(this.getLeftIcon(), width, height);
        return this;
    }

    public TitleBar setTitleIconSize(int width, int height) {
        this.mTitleIconWidth = width;
        this.mTitleIconHeight = height;
        TitleBarSupport.setDrawableSize(this.getTitleIcon(), width, height);
        return this;
    }

    public TitleBar setRightIconSize(int width, int height) {
        this.mRightIconWidth = width;
        this.mRightIconHeight = height;
        TitleBarSupport.setDrawableSize(this.getRightIcon(), width, height);
        return this;
    }

    public TitleBar setLeftIconGravity(int gravity) {
        Drawable drawable2 = this.getLeftIcon();
        this.mLeftIconGravity = gravity;
        if (drawable2 != null) {
            TitleBarSupport.setTextCompoundDrawable(this.mLeftView, drawable2, gravity);
        }
        return this;
    }

    public TitleBar setTitleIconGravity(int gravity) {
        Drawable drawable2 = this.getTitleIcon();
        this.mTitleIconGravity = gravity;
        if (drawable2 != null) {
            TitleBarSupport.setTextCompoundDrawable(this.mTitleView, drawable2, gravity);
        }
        return this;
    }

    public TitleBar setRightIconGravity(int gravity) {
        Drawable drawable2 = this.getRightIcon();
        this.mRightIconGravity = gravity;
        if (drawable2 != null) {
            TitleBarSupport.setTextCompoundDrawable(this.mRightView, drawable2, gravity);
        }
        return this;
    }

    public TitleBar setTitleColor(int color) {
        this.mTitleView.setTextColor(color);
        return this;
    }

    public TitleBar setLeftTitleColor(int color) {
        this.mLeftView.setTextColor(color);
        return this;
    }

    public TitleBar setRightTitleColor(int color) {
        this.mRightView.setTextColor(color);
        return this;
    }

    public TitleBar setLeftBackground(int id) {
        return this.setLeftBackground(TitleBarSupport.getDrawable(this.getContext(), id));
    }

    public TitleBar setLeftBackground(Drawable drawable2) {
        TitleBarSupport.setBackground((View)this.mLeftView, drawable2);
        return this;
    }

    public TitleBar setRightBackground(int id) {
        return this.setRightBackground(TitleBarSupport.getDrawable(this.getContext(), id));
    }

    public TitleBar setRightBackground(Drawable drawable2) {
        TitleBarSupport.setBackground((View)this.mRightView, drawable2);
        return this;
    }

    public TitleBar setTitleSize(int unit, float size) {
        this.mTitleView.setTextSize(unit, size);
        return this;
    }

    public TitleBar setLeftTitleSize(int unit, float size) {
        this.mLeftView.setTextSize(unit, size);
        return this;
    }

    public TitleBar setRightTitleSize(int unit, float size) {
        this.mRightView.setTextSize(unit, size);
        return this;
    }

    public TitleBar setLeftTitleStyle(Typeface typeface) {
        this.mLeftView.setTypeface(typeface);
        return this;
    }

    public TitleBar setTitleStyle(Typeface typeface) {
        this.mTitleView.setTypeface(typeface);
        return this;
    }

    public TitleBar setRightTitleStyle(Typeface typeface) {
        this.mRightView.setTypeface(typeface);
        return this;
    }

    public TitleBar setLineVisible(boolean visible) {
        this.mLineView.setVisibility(visible ? 0 : 4);
        return this;
    }

    public TitleBar setLineColor(int color) {
        return this.setLineDrawable((Drawable)new ColorDrawable(color));
    }

    public TitleBar setLineDrawable(Drawable drawable2) {
        TitleBarSupport.setBackground(this.mLineView, drawable2);
        return this;
    }

    public TitleBar setLineSize(int px) {
        ViewGroup.LayoutParams layoutParams = this.mLineView.getLayoutParams();
        layoutParams.height = px;
        this.mLineView.setLayoutParams(layoutParams);
        return this;
    }

    @SuppressLint(value={"RtlHardcoded"})
    public TitleBar setTitleGravity(int gravity) {
        if ((gravity = TitleBarSupport.getAbsoluteGravity((View)this, gravity)) == 3 && TitleBarSupport.isContainContent(TitleBarSupport.isLayoutRtl(this.getContext()) ? this.mRightView : this.mLeftView)) {
            throw new IllegalStateException("Title center of gravity for the left, the left title can not have content");
        }
        if (gravity == 5 && TitleBarSupport.isContainContent(TitleBarSupport.isLayoutRtl(this.getContext()) ? this.mLeftView : this.mRightView)) {
            throw new IllegalStateException("Title center of gravity for the right, the right title can not have content");
        }
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.mTitleView.getLayoutParams();
        params.gravity = gravity;
        this.mTitleView.setLayoutParams((ViewGroup.LayoutParams)params);
        return this;
    }

    public TitleBar setChildPadding(int horizontalPadding, int verticalPadding) {
        this.mHorizontalPadding = horizontalPadding;
        this.mVerticalPadding = verticalPadding;
        this.mLeftView.setPadding(horizontalPadding, verticalPadding, horizontalPadding, verticalPadding);
        this.mTitleView.setPadding(horizontalPadding, verticalPadding, horizontalPadding, verticalPadding);
        this.mRightView.setPadding(horizontalPadding, verticalPadding, horizontalPadding, verticalPadding);
        return this;
    }

    public TextView getLeftView() {
        return this.mLeftView;
    }

    public TextView getTitleView() {
        return this.mTitleView;
    }

    public TextView getRightView() {
        return this.mRightView;
    }

    public View getLineView() {
        return this.mLineView;
    }

    public ITitleBarStyle getCurrentStyle() {
        return this.mCurrentStyle;
    }

    public static void setDefaultStyle(ITitleBarStyle style2) {
        sGlobalStyle = style2;
    }
}

