/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.bar;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.TypedArray;
import android.graphics.PorterDuff;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.hjq.bar.ITitleBarStyle;
import com.hjq.bar.OnTitleBarListener;
import com.hjq.bar.R;
import com.hjq.bar.style.CommonBarStyle;
import com.hjq.bar.style.LightBarStyle;
import com.hjq.bar.style.NightBarStyle;
import com.hjq.bar.style.RippleBarStyle;
import com.hjq.bar.style.TransparentBarStyle;

public class TitleBar
extends FrameLayout
implements View.OnClickListener,
View.OnLayoutChangeListener {
    private static ITitleBarStyle sGlobalStyle;
    private final ITitleBarStyle mCurrentStyle;
    private OnTitleBarListener mListener;
    private final TextView mLeftView;
    private final TextView mTitleView;
    private final TextView mRightView;
    private final View mLineView;
    private int mHorizontalPadding;
    private int mVerticalPadding;
    private int mDrawableSize = -1;

    public TitleBar(Context context) {
        this(context, null, 0);
    }

    public TitleBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TitleBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        CharSequence label;
        if (sGlobalStyle == null) {
            sGlobalStyle = new LightBarStyle();
        }
        TypedArray array = this.getContext().obtainStyledAttributes(attrs, R.styleable.TitleBar);
        switch (array.getInt(R.styleable.TitleBar_barStyle, 0)) {
            case 16: {
                this.mCurrentStyle = new LightBarStyle();
                break;
            }
            case 32: {
                this.mCurrentStyle = new NightBarStyle();
                break;
            }
            case 48: {
                this.mCurrentStyle = new TransparentBarStyle();
                break;
            }
            case 64: {
                this.mCurrentStyle = new RippleBarStyle();
                break;
            }
            default: {
                this.mCurrentStyle = sGlobalStyle;
            }
        }
        this.mLeftView = this.mCurrentStyle.createLeftView(context);
        this.mTitleView = this.mCurrentStyle.createTitleView(context);
        this.mRightView = this.mCurrentStyle.createRightView(context);
        this.mLineView = this.mCurrentStyle.createLineView(context);
        if (array.hasValue(R.styleable.TitleBar_drawableSize)) {
            this.setDrawableSize(array.getDimensionPixelSize(R.styleable.TitleBar_drawableSize, 0));
        }
        if (array.hasValue(R.styleable.TitleBar_android_drawablePadding)) {
            this.setDrawablePadding(array.getDimensionPixelSize(R.styleable.TitleBar_android_drawablePadding, 0));
        }
        if (array.hasValue(R.styleable.TitleBar_leftTitle)) {
            this.setLeftTitle(array.getString(R.styleable.TitleBar_leftTitle));
        }
        if (array.hasValue(R.styleable.TitleBar_title)) {
            this.setTitle(array.getString(R.styleable.TitleBar_title));
        } else if (context instanceof Activity && !TextUtils.isEmpty((CharSequence)(label = ((Activity)context).getTitle()))) {
            try {
                PackageManager packageManager = context.getPackageManager();
                PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
                if (!label.toString().equals(packageInfo.applicationInfo.loadLabel(packageManager).toString())) {
                    this.setTitle(label);
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        if (array.hasValue(R.styleable.TitleBar_rightTitle)) {
            this.setRightTitle(array.getString(R.styleable.TitleBar_rightTitle));
        }
        if (array.hasValue(R.styleable.TitleBar_leftIcon)) {
            this.setLeftIcon(CommonBarStyle.getDrawableResources(this.getContext(), array.getResourceId(R.styleable.TitleBar_leftIcon, 0)));
        } else if (!array.getBoolean(R.styleable.TitleBar_backButton, true)) {
            this.setLeftIcon(null);
        }
        if (array.hasValue(R.styleable.TitleBar_rightIcon)) {
            this.setRightIcon(CommonBarStyle.getDrawableResources(this.getContext(), array.getResourceId(R.styleable.TitleBar_rightIcon, 0)));
        }
        if (array.hasValue(R.styleable.TitleBar_leftTint)) {
            this.setLeftTint(array.getColor(R.styleable.TitleBar_leftTint, 0));
        }
        if (array.hasValue(R.styleable.TitleBar_rightTint)) {
            this.setRightTint(array.getColor(R.styleable.TitleBar_rightTint, 0));
        }
        if (array.hasValue(R.styleable.TitleBar_leftColor)) {
            this.setLeftColor(array.getColor(R.styleable.TitleBar_leftColor, 0));
        }
        if (array.hasValue(R.styleable.TitleBar_titleColor)) {
            this.setTitleColor(array.getColor(R.styleable.TitleBar_titleColor, 0));
        }
        if (array.hasValue(R.styleable.TitleBar_rightColor)) {
            this.setRightColor(array.getColor(R.styleable.TitleBar_rightColor, 0));
        }
        if (array.hasValue(R.styleable.TitleBar_leftSize)) {
            this.setLeftSize(0, array.getDimensionPixelSize(R.styleable.TitleBar_leftSize, 0));
        }
        if (array.hasValue(R.styleable.TitleBar_titleSize)) {
            this.setTitleSize(0, array.getDimensionPixelSize(R.styleable.TitleBar_titleSize, 0));
        }
        if (array.hasValue(R.styleable.TitleBar_rightSize)) {
            this.setRightSize(0, array.getDimensionPixelSize(R.styleable.TitleBar_rightSize, 0));
        }
        if (array.hasValue(R.styleable.TitleBar_leftBackground)) {
            this.setLeftBackground(array.getDrawable(R.styleable.TitleBar_leftBackground));
        }
        if (array.hasValue(R.styleable.TitleBar_rightBackground)) {
            this.setRightBackground(array.getDrawable(R.styleable.TitleBar_rightBackground));
        }
        if (array.hasValue(R.styleable.TitleBar_lineColor)) {
            this.setLineDrawable(array.getDrawable(R.styleable.TitleBar_lineColor));
        }
        if (array.hasValue(R.styleable.TitleBar_titleGravity)) {
            this.setTitleGravity(array.getInt(R.styleable.TitleBar_titleGravity, 0));
        }
        if (array.hasValue(R.styleable.TitleBar_titleStyle)) {
            this.setTitleStyle(Typeface.defaultFromStyle((int)array.getInt(R.styleable.TitleBar_titleStyle, 0)));
        }
        if (array.hasValue(R.styleable.TitleBar_lineVisible)) {
            this.setLineVisible(array.getBoolean(R.styleable.TitleBar_lineVisible, false));
        }
        if (array.hasValue(R.styleable.TitleBar_lineSize)) {
            this.setLineSize(array.getDimensionPixelSize(R.styleable.TitleBar_lineSize, 0));
        }
        if (array.hasValue(R.styleable.TitleBar_android_paddingHorizontal) || array.hasValue(R.styleable.TitleBar_android_paddingVertical)) {
            this.setPadding(0, 0, 0, 0);
        }
        this.mHorizontalPadding = (int)TypedValue.applyDimension((int)0, (float)array.getDimensionPixelSize(R.styleable.TitleBar_android_paddingHorizontal, this.mCurrentStyle.createHorizontalPadding(this.getContext())), (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.mVerticalPadding = (int)TypedValue.applyDimension((int)0, (float)array.getDimensionPixelSize(R.styleable.TitleBar_android_paddingVertical, this.mCurrentStyle.createVerticalPadding(this.getContext())), (DisplayMetrics)this.getResources().getDisplayMetrics());
        array.recycle();
        if (this.getBackground() == null) {
            CommonBarStyle.setViewBackground((View)this, this.mCurrentStyle.createBackgroundDrawable(context));
        }
        this.addView((View)this.mTitleView, 0);
        this.addView((View)this.mLeftView, 1);
        this.addView((View)this.mRightView, 2);
        this.addView(this.mLineView, 3);
        this.addOnLayoutChangeListener(this);
    }

    public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        this.removeOnLayoutChangeListener(this);
        if (this.mLeftView.getMaxWidth() != Integer.MAX_VALUE && this.mTitleView.getMaxWidth() != Integer.MAX_VALUE && this.mRightView.getMaxWidth() != Integer.MAX_VALUE) {
            this.mLeftView.setMaxWidth(Integer.MAX_VALUE);
            this.mTitleView.setMaxWidth(Integer.MAX_VALUE);
            this.mRightView.setMaxWidth(Integer.MAX_VALUE);
            this.mLeftView.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
            this.mTitleView.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
            this.mRightView.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        }
        int barWidth = right - left;
        int sideWidth = Math.max(this.mLeftView.getMeasuredWidth(), this.mRightView.getMeasuredWidth());
        int maxWidth = sideWidth * 2 + this.mTitleView.getMeasuredWidth();
        if (maxWidth >= barWidth) {
            if (sideWidth > barWidth / 3) {
                this.mLeftView.setMaxWidth(barWidth / 4);
                this.mTitleView.setMaxWidth(barWidth / 2);
                this.mRightView.setMaxWidth(barWidth / 4);
            } else {
                this.mLeftView.setMaxWidth(sideWidth);
                this.mTitleView.setMaxWidth(barWidth - sideWidth * 2);
                this.mRightView.setMaxWidth(sideWidth);
            }
        } else if (this.mLeftView.getMaxWidth() != Integer.MAX_VALUE && this.mTitleView.getMaxWidth() != Integer.MAX_VALUE && this.mRightView.getMaxWidth() != Integer.MAX_VALUE) {
            this.mLeftView.setMaxWidth(Integer.MAX_VALUE);
            this.mTitleView.setMaxWidth(Integer.MAX_VALUE);
            this.mRightView.setMaxWidth(Integer.MAX_VALUE);
        }
        this.mLeftView.setEnabled(CommonBarStyle.checkContainContent(this.mLeftView));
        this.mTitleView.setEnabled(CommonBarStyle.checkContainContent(this.mTitleView));
        this.mRightView.setEnabled(CommonBarStyle.checkContainContent(this.mRightView));
        this.post(new Runnable(){

            @Override
            public void run() {
                TitleBar.this.addOnLayoutChangeListener(TitleBar.this);
            }
        });
    }

    public void onClick(View view) {
        if (this.mListener == null) {
            return;
        }
        if (view == this.mLeftView) {
            this.mListener.onLeftClick(view);
        } else if (view == this.mRightView) {
            this.mListener.onRightClick(view);
        } else if (view == this.mTitleView) {
            this.mListener.onTitleClick(view);
        }
    }

    public void setLayoutParams(ViewGroup.LayoutParams params) {
        if (params.width == -2) {
            params.width = -1;
        }
        int horizontalPadding = this.mHorizontalPadding;
        int verticalPadding = 0;
        if (params.height == -2) {
            verticalPadding = this.mVerticalPadding;
        }
        this.setChildPadding(horizontalPadding, verticalPadding);
        super.setLayoutParams(params);
    }

    protected FrameLayout.LayoutParams generateDefaultLayoutParams() {
        return new FrameLayout.LayoutParams(-1, -2);
    }

    public TitleBar setOnTitleBarListener(OnTitleBarListener listener) {
        this.mListener = listener;
        this.mTitleView.setOnClickListener((View.OnClickListener)this);
        this.mLeftView.setOnClickListener((View.OnClickListener)this);
        this.mRightView.setOnClickListener((View.OnClickListener)this);
        return this;
    }

    public TitleBar setTitle(int id) {
        return this.setTitle(this.getResources().getString(id));
    }

    public TitleBar setTitle(CharSequence text) {
        this.mTitleView.setText(text);
        return this;
    }

    public CharSequence getTitle() {
        return this.mTitleView.getText();
    }

    public TitleBar setLeftTitle(int id) {
        return this.setLeftTitle(this.getResources().getString(id));
    }

    public TitleBar setLeftTitle(CharSequence text) {
        this.mLeftView.setText(text);
        return this;
    }

    public CharSequence getLeftTitle() {
        return this.mLeftView.getText();
    }

    public TitleBar setRightTitle(int id) {
        return this.setRightTitle(this.getResources().getString(id));
    }

    public TitleBar setRightTitle(CharSequence text) {
        this.mRightView.setText(text);
        return this;
    }

    public CharSequence getRightTitle() {
        return this.mRightView.getText();
    }

    public TitleBar setLeftIcon(int id) {
        return this.setLeftIcon(CommonBarStyle.getDrawableResources(this.getContext(), id));
    }

    public TitleBar setLeftIcon(Drawable drawable2) {
        if (drawable2 != null) {
            if (this.mDrawableSize != -1) {
                drawable2.setBounds(0, 0, this.mDrawableSize, this.mDrawableSize);
            } else {
                drawable2.setBounds(0, 0, drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight());
            }
        }
        this.mLeftView.setCompoundDrawables(drawable2, null, null, null);
        return this;
    }

    public TitleBar setLeftTint(int color) {
        Drawable drawable2 = this.getLeftIcon();
        if (drawable2 != null) {
            drawable2.mutate();
            drawable2.setColorFilter(color, PorterDuff.Mode.SRC_IN);
        }
        return this;
    }

    public Drawable getLeftIcon() {
        return this.mLeftView.getCompoundDrawables()[0];
    }

    public TitleBar setRightIcon(int id) {
        return this.setRightIcon(CommonBarStyle.getDrawableResources(this.getContext(), id));
    }

    public TitleBar setRightIcon(Drawable drawable2) {
        if (drawable2 != null) {
            if (this.mDrawableSize != -1) {
                drawable2.setBounds(0, 0, this.mDrawableSize, this.mDrawableSize);
            } else {
                drawable2.setBounds(0, 0, drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight());
            }
        }
        this.mRightView.setCompoundDrawables(null, null, drawable2, null);
        return this;
    }

    public TitleBar setRightTint(int color) {
        Drawable drawable2 = this.getRightIcon();
        if (drawable2 != null) {
            drawable2.mutate();
            drawable2.setColorFilter(color, PorterDuff.Mode.SRC_IN);
        }
        return this;
    }

    public Drawable getRightIcon() {
        return this.mRightView.getCompoundDrawables()[2];
    }

    public TitleBar setTitleColor(int color) {
        this.mTitleView.setTextColor(color);
        return this;
    }

    public TitleBar setLeftColor(int color) {
        this.mLeftView.setTextColor(color);
        return this;
    }

    public TitleBar setRightColor(int color) {
        this.mRightView.setTextColor(color);
        return this;
    }

    public TitleBar setLeftBackground(int id) {
        return this.setLeftBackground(CommonBarStyle.getDrawableResources(this.getContext(), id));
    }

    public TitleBar setLeftBackground(Drawable drawable2) {
        CommonBarStyle.setViewBackground((View)this.mLeftView, drawable2);
        return this;
    }

    public TitleBar setRightBackground(int id) {
        return this.setRightBackground(CommonBarStyle.getDrawableResources(this.getContext(), id));
    }

    public TitleBar setRightBackground(Drawable drawable2) {
        CommonBarStyle.setViewBackground((View)this.mRightView, drawable2);
        return this;
    }

    public TitleBar setTitleSize(int unit, float size) {
        this.mTitleView.setTextSize(unit, size);
        return this;
    }

    public TitleBar setLeftSize(int unit, float size) {
        this.mLeftView.setTextSize(unit, size);
        return this;
    }

    public TitleBar setRightSize(int unit, float size) {
        this.mRightView.setTextSize(unit, size);
        return this;
    }

    public TitleBar setLineVisible(boolean visible) {
        this.mLineView.setVisibility(visible ? 0 : 4);
        return this;
    }

    public TitleBar setLineColor(int color) {
        return this.setLineDrawable((Drawable)new ColorDrawable(color));
    }

    public TitleBar setLineDrawable(Drawable drawable2) {
        CommonBarStyle.setViewBackground(this.mLineView, drawable2);
        return this;
    }

    public TitleBar setLineSize(int px) {
        ViewGroup.LayoutParams layoutParams = this.mLineView.getLayoutParams();
        layoutParams.height = px;
        this.mLineView.setLayoutParams(layoutParams);
        return this;
    }

    @SuppressLint(value={"RtlHardcoded"})
    public TitleBar setTitleGravity(int gravity) {
        if (Build.VERSION.SDK_INT >= 17) {
            gravity = Gravity.getAbsoluteGravity((int)gravity, (int)this.getResources().getConfiguration().getLayoutDirection());
        }
        if ((gravity & 3) != 0 && CommonBarStyle.checkContainContent(this.mLeftView) || (gravity & 5) != 0 && CommonBarStyle.checkContainContent(this.mRightView)) {
            throw new IllegalArgumentException("are you ok?");
        }
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.mTitleView.getLayoutParams();
        params.gravity = gravity;
        this.mTitleView.setLayoutParams((ViewGroup.LayoutParams)params);
        return this;
    }

    public TitleBar setTitleStyle(Typeface typeface) {
        this.mTitleView.setTypeface(typeface);
        return this;
    }

    public TitleBar setDrawableSize(int px) {
        this.mDrawableSize = px;
        this.setLeftIcon(this.getLeftIcon());
        this.setRightIcon(this.getRightIcon());
        return this;
    }

    public TitleBar setDrawablePadding(int padding) {
        this.mHorizontalPadding = padding;
        this.mVerticalPadding = padding;
        this.mLeftView.setCompoundDrawablePadding(padding);
        this.mTitleView.setCompoundDrawablePadding(padding);
        this.mRightView.setCompoundDrawablePadding(padding);
        return this;
    }

    public TitleBar setChildPadding(int horizontalPadding, int verticalPadding) {
        this.mHorizontalPadding = horizontalPadding;
        this.mVerticalPadding = verticalPadding;
        this.mLeftView.setPadding(horizontalPadding, verticalPadding, horizontalPadding, verticalPadding);
        this.mTitleView.setPadding(horizontalPadding, verticalPadding, horizontalPadding, verticalPadding);
        this.mRightView.setPadding(horizontalPadding, verticalPadding, horizontalPadding, verticalPadding);
        return this;
    }

    public TextView getLeftView() {
        return this.mLeftView;
    }

    public TextView getTitleView() {
        return this.mTitleView;
    }

    public TextView getRightView() {
        return this.mRightView;
    }

    public View getLineView() {
        return this.mLineView;
    }

    public ITitleBarStyle getCurrentStyle() {
        return this.mCurrentStyle;
    }

    public static void setDefaultStyle(ITitleBarStyle style) {
        sGlobalStyle = style;
    }
}

