/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.bar.initializer;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.hjq.bar.ITitleBarInitializer;

public abstract class BaseBarInitializer
implements ITitleBarInitializer {
    @Override
    public TextView getLeftView(Context context) {
        TextView leftView = this.createTextView(context);
        leftView.setCompoundDrawablesWithIntrinsicBounds(this.getBackIcon(context), null, null, null);
        leftView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -1, 0x800003));
        leftView.setGravity(16);
        leftView.setFocusable(true);
        leftView.setSingleLine();
        leftView.setEllipsize(TextUtils.TruncateAt.END);
        leftView.setCompoundDrawablePadding((int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)leftView.getResources().getDisplayMetrics()));
        leftView.setTextSize(2, 14.0f);
        return leftView;
    }

    @Override
    public TextView getTitleView(Context context) {
        TextView titleView = this.createTextView(context);
        titleView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -1, 1));
        titleView.setGravity(17);
        titleView.setFocusable(true);
        titleView.setSingleLine();
        titleView.setEllipsize(TextUtils.TruncateAt.MARQUEE);
        titleView.setMarqueeRepeatLimit(-1);
        titleView.setSelected(true);
        titleView.setCompoundDrawablePadding((int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)titleView.getResources().getDisplayMetrics()));
        titleView.setTextSize(2, 16.0f);
        return titleView;
    }

    @Override
    public TextView getRightView(Context context) {
        TextView rightView = this.createTextView(context);
        rightView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -1, 0x800005));
        rightView.setGravity(16);
        rightView.setFocusable(true);
        rightView.setSingleLine();
        rightView.setEllipsize(TextUtils.TruncateAt.END);
        rightView.setCompoundDrawablePadding((int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)rightView.getResources().getDisplayMetrics()));
        rightView.setTextSize(2, 14.0f);
        return rightView;
    }

    @Override
    public View getLineView(Context context) {
        View lineView = new View(context);
        lineView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, 1, 80));
        return lineView;
    }

    @Override
    public int getHorizontalPadding(Context context) {
        return (int)TypedValue.applyDimension((int)1, (float)12.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    @Override
    public int getVerticalPadding(Context context) {
        return (int)TypedValue.applyDimension((int)1, (float)15.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public abstract Drawable getBackIcon(Context var1);

    protected TextView createTextView(Context context) {
        return new TextView(context);
    }

    public static Drawable getDrawableResources(Context context, int id) {
        if (Build.VERSION.SDK_INT >= 21) {
            return context.getResources().getDrawable(id, context.getTheme());
        }
        return context.getResources().getDrawable(id);
    }

    public static void setViewBackground(View view, Drawable drawable2) {
        if (Build.VERSION.SDK_INT >= 16) {
            view.setBackground(drawable2);
        } else {
            view.setBackgroundDrawable(drawable2);
        }
    }

    public static boolean checkContainContent(TextView textView) {
        Drawable[] drawables;
        CharSequence text = textView.getText();
        if (!TextUtils.isEmpty((CharSequence)text)) {
            return true;
        }
        for (Drawable drawable2 : drawables = textView.getCompoundDrawables()) {
            if (drawable2 == null) continue;
            return true;
        }
        return false;
    }
}

