/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.bar;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.TypedArray;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.hjq.bar.ITitleBarStyle;
import com.hjq.bar.OnTitleBarListener;
import com.hjq.bar.R;
import com.hjq.bar.ViewCore;
import com.hjq.bar.style.BaseTitleBarStyle;
import com.hjq.bar.style.TitleBarLightStyle;
import com.hjq.bar.style.TitleBarNightStyle;
import com.hjq.bar.style.TitleBarRippleStyle;
import com.hjq.bar.style.TitleBarTransparentStyle;

public class TitleBar
extends FrameLayout
implements View.OnClickListener,
Runnable {
    private static ITitleBarStyle sDefaultStyle;
    private ITitleBarStyle mCurrentStyle;
    private OnTitleBarListener mListener;
    private LinearLayout mMainLayout;
    private TextView mLeftView;
    private TextView mTitleView;
    private TextView mRightView;
    private View mLineView;
    private boolean mInitialize;

    public TitleBar(Context context) {
        this(context, null, 0);
    }

    public TitleBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TitleBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        CharSequence label;
        this.mMainLayout = ViewCore.newMainLayout(context);
        this.mLineView = ViewCore.newLineView(context);
        this.mLeftView = ViewCore.newLeftView(context);
        this.mTitleView = ViewCore.newTitleView(context);
        this.mRightView = ViewCore.newRightView(context);
        this.mLeftView.setEnabled(false);
        this.mTitleView.setEnabled(false);
        this.mRightView.setEnabled(false);
        if (sDefaultStyle == null) {
            sDefaultStyle = new TitleBarLightStyle(this.getContext().getApplicationContext());
        }
        TypedArray array = this.getContext().obtainStyledAttributes(attrs, R.styleable.TitleBar);
        switch (array.getInt(R.styleable.TitleBar_barStyle, 0)) {
            case 16: {
                this.mCurrentStyle = new TitleBarLightStyle(this.getContext());
                break;
            }
            case 32: {
                this.mCurrentStyle = new TitleBarNightStyle(this.getContext());
                break;
            }
            case 48: {
                this.mCurrentStyle = new TitleBarTransparentStyle(this.getContext());
                break;
            }
            case 64: {
                this.mCurrentStyle = new TitleBarRippleStyle(this.getContext());
                break;
            }
            default: {
                this.mCurrentStyle = sDefaultStyle;
            }
        }
        this.setChildPadding(sDefaultStyle.getChildPadding());
        if (array.hasValue(R.styleable.TitleBar_leftTitle)) {
            this.setLeftTitle(array.getString(R.styleable.TitleBar_leftTitle));
        }
        if (array.hasValue(R.styleable.TitleBar_title)) {
            this.setTitle(array.getString(R.styleable.TitleBar_title));
        } else if (this.getContext() instanceof Activity && (label = ((Activity)this.getContext()).getTitle()) != null && !"".equals(label.toString())) {
            try {
                PackageManager packageManager = this.getContext().getPackageManager();
                PackageInfo packageInfo = packageManager.getPackageInfo(this.getContext().getPackageName(), 0);
                if (!label.toString().equals(packageInfo.applicationInfo.loadLabel(packageManager).toString())) {
                    this.setTitle(label);
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        if (array.hasValue(R.styleable.TitleBar_rightTitle)) {
            this.setRightTitle(array.getString(R.styleable.TitleBar_rightTitle));
        }
        if (array.hasValue(R.styleable.TitleBar_leftIcon)) {
            this.setLeftIcon(ViewCore.getDrawable(this.getContext(), array.getResourceId(R.styleable.TitleBar_leftIcon, 0)));
        } else if (array.getBoolean(R.styleable.TitleBar_backButton, this.mCurrentStyle.getBackIcon() != null)) {
            this.setLeftIcon(this.mCurrentStyle.getBackIcon());
        }
        if (array.hasValue(R.styleable.TitleBar_rightIcon)) {
            this.setRightIcon(ViewCore.getDrawable(this.getContext(), array.getResourceId(R.styleable.TitleBar_rightIcon, 0)));
        }
        this.setLeftColor(array.getColor(R.styleable.TitleBar_leftColor, this.mCurrentStyle.getLeftColor()));
        this.setTitleColor(array.getColor(R.styleable.TitleBar_titleColor, this.mCurrentStyle.getTitleColor()));
        this.setRightColor(array.getColor(R.styleable.TitleBar_rightColor, this.mCurrentStyle.getRightColor()));
        this.setLeftSize(0, array.getDimensionPixelSize(R.styleable.TitleBar_leftSize, (int)this.mCurrentStyle.getLeftSize()));
        this.setTitleSize(0, array.getDimensionPixelSize(R.styleable.TitleBar_titleSize, (int)this.mCurrentStyle.getTitleSize()));
        this.setRightSize(0, array.getDimensionPixelSize(R.styleable.TitleBar_rightSize, (int)this.mCurrentStyle.getRightSize()));
        if (array.hasValue(R.styleable.TitleBar_leftBackground)) {
            this.setLeftBackground(array.getDrawable(R.styleable.TitleBar_leftBackground));
        } else {
            this.setLeftBackground(this.mCurrentStyle.getLeftBackground());
        }
        if (array.hasValue(R.styleable.TitleBar_rightBackground)) {
            this.setRightBackground(array.getDrawable(R.styleable.TitleBar_rightBackground));
        } else {
            this.setRightBackground(this.mCurrentStyle.getRightBackground());
        }
        if (array.hasValue(R.styleable.TitleBar_lineColor)) {
            this.setLineDrawable(array.getDrawable(R.styleable.TitleBar_lineColor));
        } else {
            this.setLineDrawable(this.mCurrentStyle.getLineDrawable());
        }
        this.setTitleGravity(array.getInt(R.styleable.TitleBar_titleGravity, this.mCurrentStyle.getTitleGravity()));
        this.setLineVisible(array.getBoolean(R.styleable.TitleBar_lineVisible, this.mCurrentStyle.isLineVisible()));
        this.setLineSize(array.getDimensionPixelSize(R.styleable.TitleBar_lineSize, this.mCurrentStyle.getLineSize()));
        this.setDrawablePadding(array.getDimensionPixelSize(R.styleable.TitleBar_android_drawablePadding, this.mCurrentStyle.getDrawablePadding()));
        array.recycle();
        if (this.getBackground() == null) {
            ViewCore.setBackground((View)this, this.mCurrentStyle.getBackground());
        }
        this.mMainLayout.addView((View)this.mLeftView);
        this.mMainLayout.addView((View)this.mTitleView);
        this.mMainLayout.addView((View)this.mRightView);
        this.addView((View)this.mMainLayout, 0);
        this.addView(this.mLineView, 1);
        this.mInitialize = true;
        this.post(this);
    }

    public void setLayoutParams(ViewGroup.LayoutParams params) {
        if (params.width == -2) {
            params.width = -1;
        }
        if (params.height == -2) {
            this.mMainLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, this.mCurrentStyle.getTitleBarHeight()));
        }
        super.setLayoutParams(params);
    }

    public FrameLayout.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new FrameLayout.LayoutParams(this.getContext(), attrs);
    }

    protected FrameLayout.LayoutParams generateDefaultLayoutParams() {
        return new FrameLayout.LayoutParams(-1, -2);
    }

    protected FrameLayout.LayoutParams generateLayoutParams(ViewGroup.LayoutParams params) {
        return new FrameLayout.LayoutParams(params);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams params) {
        return params instanceof FrameLayout.LayoutParams;
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    @Override
    public void run() {
        int rightSize;
        int leftSize;
        if (!this.mInitialize) {
            return;
        }
        if ((this.mTitleView.getGravity() & 1) != 0 && (leftSize = this.mLeftView.getWidth()) != (rightSize = this.mRightView.getWidth())) {
            if (leftSize > rightSize) {
                this.mTitleView.setPadding(0, 0, leftSize - rightSize, 0);
            } else {
                this.mTitleView.setPadding(rightSize - leftSize, 0, 0, 0);
            }
        }
        this.mLeftView.setEnabled(ViewCore.hasTextViewContent(this.mLeftView));
        this.mTitleView.setEnabled(ViewCore.hasTextViewContent(this.mTitleView));
        this.mRightView.setEnabled(ViewCore.hasTextViewContent(this.mRightView));
    }

    public void onClick(View v) {
        if (this.mListener == null) {
            return;
        }
        if (v == this.mLeftView) {
            this.mListener.onLeftClick(v);
        } else if (v == this.mRightView) {
            this.mListener.onRightClick(v);
        } else if (v == this.mTitleView) {
            this.mListener.onTitleClick(v);
        }
    }

    public TitleBar setOnTitleBarListener(OnTitleBarListener l) {
        this.mListener = l;
        this.mTitleView.setOnClickListener((View.OnClickListener)this);
        this.mLeftView.setOnClickListener((View.OnClickListener)this);
        this.mRightView.setOnClickListener((View.OnClickListener)this);
        return this;
    }

    public TitleBar setTitle(int id) {
        return this.setTitle(this.getResources().getString(id));
    }

    public TitleBar setTitle(CharSequence text) {
        this.mTitleView.setText(text);
        this.post(this);
        return this;
    }

    public CharSequence getTitle() {
        return this.mTitleView.getText();
    }

    public TitleBar setLeftTitle(int id) {
        return this.setLeftTitle(this.getResources().getString(id));
    }

    public TitleBar setLeftTitle(CharSequence text) {
        this.mLeftView.setText(text);
        this.post(this);
        return this;
    }

    public CharSequence getLeftTitle() {
        return this.mLeftView.getText();
    }

    public TitleBar setRightTitle(int id) {
        return this.setRightTitle(this.getResources().getString(id));
    }

    public TitleBar setRightTitle(CharSequence text) {
        this.mRightView.setText(text);
        this.post(this);
        return this;
    }

    public CharSequence getRightTitle() {
        return this.mRightView.getText();
    }

    public TitleBar setLeftIcon(int id) {
        return this.setLeftIcon(ViewCore.getDrawable(this.getContext(), id));
    }

    public TitleBar setLeftIcon(Drawable drawable2) {
        this.mLeftView.setCompoundDrawablesWithIntrinsicBounds(drawable2, null, null, null);
        this.post(this);
        return this;
    }

    public Drawable getLeftIcon() {
        return this.mLeftView.getCompoundDrawables()[0];
    }

    public TitleBar setRightIcon(int id) {
        return this.setRightIcon(ViewCore.getDrawable(this.getContext(), id));
    }

    public TitleBar setRightIcon(Drawable drawable2) {
        this.mRightView.setCompoundDrawablesWithIntrinsicBounds(null, null, drawable2, null);
        this.post(this);
        return this;
    }

    public Drawable getRightIcon() {
        return this.mRightView.getCompoundDrawables()[2];
    }

    public TitleBar setLeftColor(int color) {
        this.mLeftView.setTextColor(color);
        return this;
    }

    public TitleBar setTitleColor(int color) {
        this.mTitleView.setTextColor(color);
        return this;
    }

    public TitleBar setRightColor(int color) {
        this.mRightView.setTextColor(color);
        return this;
    }

    public TitleBar setLeftBackground(int id) {
        return this.setLeftBackground(ViewCore.getDrawable(this.getContext(), id));
    }

    public TitleBar setLeftBackground(Drawable drawable2) {
        ViewCore.setBackground((View)this.mLeftView, drawable2);
        this.post(this);
        return this;
    }

    public TitleBar setRightBackground(int id) {
        return this.setRightBackground(ViewCore.getDrawable(this.getContext(), id));
    }

    public TitleBar setRightBackground(Drawable drawable2) {
        ViewCore.setBackground((View)this.mRightView, drawable2);
        this.post(this);
        return this;
    }

    public TitleBar setLeftSize(int unit, float size) {
        this.mLeftView.setTextSize(unit, size);
        this.post(this);
        return this;
    }

    public TitleBar setTitleSize(int unit, float size) {
        this.mTitleView.setTextSize(unit, size);
        this.post(this);
        return this;
    }

    public TitleBar setRightSize(int unit, float size) {
        this.mRightView.setTextSize(unit, size);
        this.post(this);
        return this;
    }

    public TitleBar setLineVisible(boolean visible) {
        this.mLineView.setVisibility(visible ? 0 : 8);
        return this;
    }

    public TitleBar setLineColor(int color) {
        return this.setLineDrawable((Drawable)new ColorDrawable(color));
    }

    public TitleBar setLineDrawable(Drawable drawable2) {
        ViewCore.setBackground(this.mLineView, drawable2);
        return this;
    }

    public TitleBar setLineSize(int px) {
        ViewGroup.LayoutParams layoutParams = this.mLineView.getLayoutParams();
        layoutParams.height = px;
        this.mLineView.setLayoutParams(layoutParams);
        return this;
    }

    public TitleBar setTitleGravity(int gravity) {
        if (Build.VERSION.SDK_INT >= 17) {
            gravity = Gravity.getAbsoluteGravity((int)gravity, (int)this.getResources().getConfiguration().getLayoutDirection());
        }
        this.mTitleView.setGravity(gravity);
        return this;
    }

    public TitleBar setDrawablePadding(int px) {
        this.mLeftView.setCompoundDrawablePadding(px);
        this.mTitleView.setCompoundDrawablePadding(px);
        this.mRightView.setCompoundDrawablePadding(px);
        this.post(this);
        return this;
    }

    public TitleBar setChildPadding(int px) {
        this.mLeftView.setPadding(px, 0, px, 0);
        this.mTitleView.setPadding(px, 0, px, 0);
        this.mRightView.setPadding(px, 0, px, 0);
        this.post(this);
        return this;
    }

    public LinearLayout getMainLayout() {
        return this.mMainLayout;
    }

    public TextView getLeftView() {
        return this.mLeftView;
    }

    public TextView getTitleView() {
        return this.mTitleView;
    }

    public TextView getRightView() {
        return this.mRightView;
    }

    public View getLineView() {
        return this.mLineView;
    }

    public static void initStyle(ITitleBarStyle style) {
        Context context;
        sDefaultStyle = style;
        if (style instanceof BaseTitleBarStyle && !((context = ((BaseTitleBarStyle)style).getContext()) instanceof Application)) {
            throw new IllegalArgumentException("The view must be initialized using the context of the application");
        }
    }

    public ITitleBarStyle getCurrentStyle() {
        return this.mCurrentStyle;
    }
}

