/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.bar.style;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import com.hjq.bar.ITitleBarStyle;

public abstract class BaseTitleBarStyle
implements ITitleBarStyle {
    private Context mContext;

    public BaseTitleBarStyle(Context context) {
        this.mContext = context;
    }

    protected Context getContext() {
        return this.mContext;
    }

    protected Drawable getDrawable(int id2) {
        if (Build.VERSION.SDK_INT >= 21) {
            return this.getContext().getResources().getDrawable(id2, null);
        }
        return this.getContext().getResources().getDrawable(id2);
    }

    public int getColor(int id2) {
        if (Build.VERSION.SDK_INT >= 23) {
            return this.getContext().getResources().getColor(id2, null);
        }
        return this.getContext().getResources().getColor(id2);
    }

    protected int dp2px(float dpValue) {
        float scale = this.getContext().getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    protected int sp2px(float spValue) {
        float fontScale = this.getContext().getResources().getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }

    @Override
    public int getTitleBarHeight() {
        return this.dp2px(0.0f);
    }

    @Override
    public float getLeftSize() {
        return this.sp2px(14.0f);
    }

    @Override
    public float getTitleSize() {
        return this.sp2px(16.0f);
    }

    @Override
    public float getRightSize() {
        return this.sp2px(14.0f);
    }
}

