/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.bar;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.hjq.bar.ITitleBarStyle;
import com.hjq.bar.OnTitleBarListener;
import com.hjq.bar.R;
import com.hjq.bar.ViewBuilder;
import com.hjq.bar.style.TitleBarLightStyle;
import com.hjq.bar.style.TitleBarNightStyle;
import com.hjq.bar.style.TitleBarTransparentStyle;

public class TitleBar
extends FrameLayout
implements View.OnClickListener,
Runnable {
    private static ITitleBarStyle sDefaultStyle = new TitleBarLightStyle();
    private OnTitleBarListener mListener;
    private LinearLayout mMainLayout;
    private TextView mLeftView;
    private TextView mTitleView;
    private TextView mRightView;
    private View mLineView;

    public TitleBar(Context context) {
        this(context, null, 0);
    }

    public TitleBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TitleBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
        this.initStyle(attrs);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (View.MeasureSpec.getMode((int)heightMeasureSpec) == Integer.MIN_VALUE || View.MeasureSpec.getMode((int)heightMeasureSpec) == 0) {
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)widthMeasureSpec, (int)0x40000000);
        }
        if (View.MeasureSpec.getMode((int)heightMeasureSpec) == Integer.MIN_VALUE || View.MeasureSpec.getMode((int)heightMeasureSpec) == 0) {
            Drawable background;
            int titleBarHeight = sDefaultStyle.getTitleBarHeight();
            if (titleBarHeight <= 0) {
                titleBarHeight = ViewBuilder.getActionBarHeight(this.getContext());
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)titleBarHeight, (int)0x40000000);
            }
            if ((background = this.getBackground()) instanceof BitmapDrawable) {
                this.mMainLayout.getLayoutParams().height = View.MeasureSpec.getSize((int)heightMeasureSpec);
                double ratio = (double)View.MeasureSpec.getSize((int)widthMeasureSpec) / (double)background.getIntrinsicWidth();
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)((int)(ratio * (double)background.getIntrinsicHeight())), (int)0x40000000);
            }
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    private void initView(Context context) {
        ViewBuilder builder = new ViewBuilder(context);
        this.mMainLayout = builder.getMainLayout();
        this.mLineView = builder.getLineView();
        this.mTitleView = builder.getTitleView();
        this.mLeftView = builder.getLeftView();
        this.mRightView = builder.getRightView();
        this.mLeftView.setEnabled(false);
        this.mTitleView.setEnabled(false);
        this.mRightView.setEnabled(false);
        this.mMainLayout.addView((View)this.mLeftView);
        this.mMainLayout.addView((View)this.mTitleView);
        this.mMainLayout.addView((View)this.mRightView);
        this.addView((View)this.mMainLayout, 0);
        this.addView(this.mLineView, 1);
    }

    private void initStyle(AttributeSet attrs) {
        CharSequence label;
        ITitleBarStyle style;
        TypedArray ta = this.getContext().obtainStyledAttributes(attrs, R.styleable.TitleBar);
        switch (ta.getInt(R.styleable.TitleBar_bar_style, 0)) {
            case 16: {
                style = new TitleBarLightStyle();
                break;
            }
            case 32: {
                style = new TitleBarNightStyle();
                break;
            }
            case 48: {
                style = new TitleBarTransparentStyle();
                break;
            }
            default: {
                style = sDefaultStyle;
            }
        }
        if (ta.hasValue(R.styleable.TitleBar_title_left)) {
            this.setLeftTitle(ta.getString(R.styleable.TitleBar_title_left));
        }
        if (ta.hasValue(R.styleable.TitleBar_title)) {
            this.setTitle(ta.getString(R.styleable.TitleBar_title));
        } else if (this.getContext() instanceof Activity && (label = ViewBuilder.getActivityLabel((Activity)this.getContext())) != null && !"".equals(label.toString())) {
            this.setTitle(label);
        }
        if (ta.hasValue(R.styleable.TitleBar_title_right)) {
            this.setRightTitle(ta.getString(R.styleable.TitleBar_title_right));
        }
        if (ta.hasValue(R.styleable.TitleBar_icon_left)) {
            this.setLeftIcon(this.getContext().getResources().getDrawable(ta.getResourceId(R.styleable.TitleBar_icon_left, 0)));
        } else if (ta.getBoolean(R.styleable.TitleBar_icon_back, style.getBackIconResource() > 0)) {
            this.setLeftIcon(this.getContext().getResources().getDrawable(style.getBackIconResource()));
        }
        if (ta.hasValue(R.styleable.TitleBar_icon_right)) {
            this.setRightIcon(this.getContext().getResources().getDrawable(ta.getResourceId(R.styleable.TitleBar_icon_right, 0)));
        }
        this.setLeftColor(ta.getColor(R.styleable.TitleBar_color_left, style.getLeftViewColor()));
        this.setTitleColor(ta.getColor(R.styleable.TitleBar_color_title, style.getTitleViewColor()));
        this.setRightColor(ta.getColor(R.styleable.TitleBar_color_right, style.getRightViewColor()));
        this.setLeftSize(0, ta.getDimensionPixelSize(R.styleable.TitleBar_size_left, ViewBuilder.sp2px(this.getContext(), style.getLeftViewSize())));
        this.setTitleSize(0, ta.getDimensionPixelSize(R.styleable.TitleBar_size_title, ViewBuilder.sp2px(this.getContext(), style.getTitleViewSize())));
        this.setRightSize(0, ta.getDimensionPixelSize(R.styleable.TitleBar_size_right, ViewBuilder.sp2px(this.getContext(), style.getRightViewSize())));
        this.setLeftBackground(ta.getResourceId(R.styleable.TitleBar_background_left, style.getLeftViewBackground()));
        this.setRightBackground(ta.getResourceId(R.styleable.TitleBar_background_right, style.getRightViewBackground()));
        this.setLineVisible(ta.getBoolean(R.styleable.TitleBar_line_visible, style.isLineVisible()));
        this.setLineColor(ta.getColor(R.styleable.TitleBar_line_color, style.getLineColor()));
        this.setLineSize(ta.getDimensionPixelSize(R.styleable.TitleBar_line_size, style.getLineSize()));
        ta.recycle();
        if (this.getBackground() == null) {
            this.setBackgroundColor(style.getBackgroundColor());
        }
    }

    @Override
    public void run() {
        int rightSize;
        int leftSize = this.mLeftView.getWidth();
        if (leftSize != (rightSize = this.mRightView.getWidth())) {
            if (leftSize > rightSize) {
                this.mTitleView.setPadding(0, 0, leftSize - rightSize, 0);
            } else {
                this.mTitleView.setPadding(rightSize - leftSize, 0, 0, 0);
            }
        }
        if (!"".equals(this.mLeftView.getText().toString()) || ViewBuilder.hasCompoundDrawables(this.mLeftView)) {
            this.mLeftView.setEnabled(true);
        }
        if (!"".equals(this.mTitleView.getText().toString()) || ViewBuilder.hasCompoundDrawables(this.mTitleView)) {
            this.mTitleView.setEnabled(true);
        }
        if (!"".equals(this.mRightView.getText().toString()) || ViewBuilder.hasCompoundDrawables(this.mRightView)) {
            this.mRightView.setEnabled(true);
        }
    }

    public void onClick(View v) {
        if (this.getOnTitleBarListener() == null) {
            return;
        }
        int id2 = v.getId();
        if (id2 == R.id.bar_id_left_view) {
            this.getOnTitleBarListener().onLeftClick(v);
        } else if (id2 == R.id.bar_id_title_view) {
            this.getOnTitleBarListener().onTitleClick(v);
        } else if (id2 == R.id.bar_id_right_view) {
            this.getOnTitleBarListener().onRightClick(v);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mTitleView.setOnClickListener((View.OnClickListener)this);
        this.mLeftView.setOnClickListener((View.OnClickListener)this);
        this.mRightView.setOnClickListener((View.OnClickListener)this);
    }

    protected void onDetachedFromWindow() {
        this.mTitleView.setOnClickListener(null);
        this.mLeftView.setOnClickListener(null);
        this.mRightView.setOnClickListener(null);
        super.onDetachedFromWindow();
    }

    public OnTitleBarListener getOnTitleBarListener() {
        return this.mListener;
    }

    public void setOnTitleBarListener(OnTitleBarListener l) {
        this.mListener = l;
    }

    public CharSequence getTitle() {
        return this.mTitleView.getText();
    }

    public void setTitle(int stringId) {
        this.setTitle(this.getResources().getString(stringId));
    }

    public void setTitle(CharSequence text) {
        this.mTitleView.setText(text);
        this.post(this);
    }

    public void setLeftTitle(int stringId) {
        this.setLeftTitle(this.getResources().getString(stringId));
    }

    public void setLeftTitle(CharSequence text) {
        this.mLeftView.setText(text);
        this.post(this);
    }

    public void setRightTitle(int stringId) {
        this.setRightTitle(this.getResources().getString(stringId));
    }

    public void setRightTitle(CharSequence text) {
        this.mRightView.setText(text);
        this.post(this);
    }

    public void setLeftIcon(int iconId) {
        if (iconId > 0) {
            this.setLeftIcon(this.getContext().getResources().getDrawable(iconId));
        }
    }

    public void setLeftIcon(Drawable drawable2) {
        this.mLeftView.setCompoundDrawablesWithIntrinsicBounds(drawable2, null, null, null);
        this.post(this);
    }

    public void setRightIcon(int iconId) {
        if (iconId > 0) {
            this.setRightIcon(this.getContext().getResources().getDrawable(iconId));
        }
    }

    public void setRightIcon(Drawable drawable2) {
        this.mRightView.setCompoundDrawablesWithIntrinsicBounds(null, null, drawable2, null);
        this.post(this);
    }

    public void setTitleColor(int color) {
        this.mTitleView.setTextColor(color);
    }

    public void setLeftColor(int color) {
        this.mLeftView.setTextColor(color);
    }

    public void setRightColor(int color) {
        this.mRightView.setTextColor(color);
    }

    public void setLeftBackground(int bgId) {
        if (bgId > 0) {
            this.mLeftView.setBackgroundResource(bgId);
        }
    }

    public void setLeftBackground(Drawable drawable2) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.mLeftView.setBackground(drawable2);
        } else {
            this.mLeftView.setBackgroundDrawable(drawable2);
        }
    }

    public void setRightBackground(int bgId) {
        if (bgId > 0) {
            this.mRightView.setBackgroundResource(bgId);
        }
    }

    public void setRightBackground(Drawable drawable2) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.mRightView.setBackground(drawable2);
        } else {
            this.mRightView.setBackgroundDrawable(drawable2);
        }
    }

    public void setLeftSize(int unit, float size) {
        this.mLeftView.setTextSize(unit, size);
    }

    public void setTitleSize(int unit, float size) {
        this.mTitleView.setTextSize(unit, size);
    }

    public void setRightSize(int unit, float size) {
        this.mRightView.setTextSize(unit, size);
    }

    public void setLineVisible(boolean visible) {
        this.mLineView.setVisibility(visible ? 0 : 8);
    }

    public void setLineColor(int color) {
        this.mLineView.setBackgroundColor(color);
    }

    public void setLineSize(int size) {
        ViewGroup.LayoutParams layoutParams = this.mLineView.getLayoutParams();
        layoutParams.height = size;
        this.mLineView.setLayoutParams(layoutParams);
    }

    public LinearLayout getMainLayout() {
        return this.mMainLayout;
    }

    public TextView getLeftView() {
        return this.mLeftView;
    }

    public TextView getTitleView() {
        return this.mTitleView;
    }

    public TextView getRightView() {
        return this.mRightView;
    }

    public View getLineView() {
        return this.mLineView;
    }

    public static void initStyle(ITitleBarStyle style) {
        sDefaultStyle = style;
    }
}

