/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.bar;

import android.content.Context;
import android.graphics.BlendMode;
import android.graphics.BlendModeColorFilter;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.view.Gravity;
import android.view.View;
import android.widget.TextView;

public final class TitleBarSupport {
    static final int NO_COLOR = 0;
    public static final int ELLIPSIZE_NONE = 0;
    public static final int ELLIPSIZE_START = 1;
    public static final int ELLIPSIZE_MIDDLE = 2;
    public static final int ELLIPSIZE_END = 3;
    public static final int ELLIPSIZE_MARQUEE = 4;

    public static Drawable getDrawable(Context context, int id) {
        if (Build.VERSION.SDK_INT >= 21) {
            return context.getResources().getDrawable(id, context.getTheme());
        }
        return context.getResources().getDrawable(id);
    }

    public static void setBackground(View view, Drawable drawable2) {
        view.setBackground(drawable2);
    }

    public static void setForeground(View view, Drawable drawable2) {
        if (Build.VERSION.SDK_INT >= 23) {
            view.setForeground(drawable2);
        }
    }

    public static int getAbsoluteGravity(View view, int gravity) {
        if (Build.VERSION.SDK_INT < 17) {
            return gravity;
        }
        return Gravity.getAbsoluteGravity((int)gravity, (int)view.getResources().getConfiguration().getLayoutDirection());
    }

    public static boolean isLayoutRtl(Context context) {
        if (Build.VERSION.SDK_INT < 17) {
            return false;
        }
        return context.getResources().getConfiguration().getLayoutDirection() == 1;
    }

    public static boolean containContent(TextView textView) {
        Drawable[] drawables;
        CharSequence text = textView.getText();
        if (!TextUtils.isEmpty((CharSequence)text)) {
            return true;
        }
        for (Drawable drawable2 : drawables = textView.getCompoundDrawables()) {
            if (drawable2 == null) continue;
            return true;
        }
        return false;
    }

    public static void setDrawableTint(Drawable drawable2, int color) {
        if (drawable2 == null) {
            return;
        }
        if (color == 0) {
            return;
        }
        drawable2.mutate();
        if (Build.VERSION.SDK_INT >= 29) {
            drawable2.setColorFilter((ColorFilter)new BlendModeColorFilter(color, BlendMode.SRC_IN));
        } else {
            drawable2.setColorFilter(color, PorterDuff.Mode.SRC_IN);
        }
    }

    public static void clearDrawableTint(Drawable drawable2) {
        if (drawable2 == null) {
            return;
        }
        drawable2.mutate();
        drawable2.clearColorFilter();
    }

    public static void setDrawableSize(Drawable drawable2, int width, int height) {
        if (drawable2 == null) {
            return;
        }
        if (width <= 0 && height <= 0) {
            drawable2.setBounds(0, 0, drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight());
            return;
        }
        if (width > 0 && height > 0) {
            drawable2.setBounds(0, 0, width, height);
            return;
        }
        int drawableWidth = drawable2.getIntrinsicWidth();
        int drawableHeight = drawable2.getIntrinsicHeight();
        if (drawableWidth <= 0) {
            drawableWidth = width;
        }
        if (drawableHeight <= 0) {
            drawableHeight = height;
        }
        if (width > 0) {
            drawable2.setBounds(0, 0, width, width * drawableHeight / drawableWidth);
        } else {
            drawable2.setBounds(0, 0, drawableWidth * height / drawableHeight, height);
        }
    }

    public static Drawable getTextCompoundDrawable(TextView textView, int gravity) {
        Drawable[] drawables = textView.getCompoundDrawables();
        switch (TitleBarSupport.getAbsoluteGravity((View)textView, gravity)) {
            case 3: {
                return drawables[0];
            }
            case 48: {
                return drawables[1];
            }
            case 5: {
                return drawables[2];
            }
            case 80: {
                return drawables[3];
            }
        }
        return null;
    }

    public static void setTextCompoundDrawable(TextView textView, Drawable drawable2, int gravity) {
        switch (TitleBarSupport.getAbsoluteGravity((View)textView, gravity)) {
            case 3: {
                textView.setCompoundDrawables(drawable2, null, null, null);
                break;
            }
            case 48: {
                textView.setCompoundDrawables(null, drawable2, null, null);
                break;
            }
            case 5: {
                textView.setCompoundDrawables(null, null, drawable2, null);
                break;
            }
            case 80: {
                textView.setCompoundDrawables(null, null, null, drawable2);
                break;
            }
            default: {
                textView.setCompoundDrawables(null, null, null, null);
            }
        }
    }

    public static Typeface getTextTypeface(int style2) {
        switch (style2) {
            case 1: {
                return Typeface.DEFAULT_BOLD;
            }
            case 2: 
            case 3: {
                return Typeface.MONOSPACE;
            }
        }
        return Typeface.DEFAULT;
    }

    public static TextUtils.TruncateAt convertIntToTruncateAtEnum(int ellipsize) {
        switch (ellipsize) {
            case 1: {
                return TextUtils.TruncateAt.START;
            }
            case 2: {
                return TextUtils.TruncateAt.MIDDLE;
            }
            case 3: {
                return TextUtils.TruncateAt.END;
            }
            case 4: {
                return TextUtils.TruncateAt.MARQUEE;
            }
        }
        return null;
    }

    public static void setTextViewEllipsize(TextView textView, TextUtils.TruncateAt where) {
        if (textView.getEllipsize() == where) {
            return;
        }
        textView.setEllipsize(where);
        if (where != TextUtils.TruncateAt.MARQUEE) {
            return;
        }
        if (!textView.isSelected()) {
            textView.setSelected(true);
        }
        if (!textView.isFocusable()) {
            textView.setFocusable(true);
        }
        textView.setMarqueeRepeatLimit(-1);
    }
}

