/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.shape.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.v7.widget.AppCompatEditText;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import com.hjq.shape.R;
import com.hjq.shape.builder.ShapeDrawableBuilder;
import com.hjq.shape.builder.TextColorBuilder;
import com.hjq.shape.config.IGetShapeDrawableBuilder;
import com.hjq.shape.config.IGetTextColorBuilder;
import com.hjq.shape.styleable.ShapeEditTextStyleable;

public class ShapeEditText
extends AppCompatEditText
implements IGetShapeDrawableBuilder,
IGetTextColorBuilder {
    private static final ShapeEditTextStyleable STYLEABLE = new ShapeEditTextStyleable();
    private final ShapeDrawableBuilder mShapeDrawableBuilder;
    private final TextColorBuilder mTextColorBuilder;

    public ShapeEditText(Context context) {
        this(context, null);
    }

    public ShapeEditText(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.editTextStyle);
    }

    public ShapeEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ShapeEditText);
        this.mShapeDrawableBuilder = new ShapeDrawableBuilder((View)this, typedArray, STYLEABLE);
        this.mTextColorBuilder = new TextColorBuilder((TextView)this, typedArray, STYLEABLE);
        typedArray.recycle();
        this.mShapeDrawableBuilder.intoBackground();
        this.mTextColorBuilder.intoTextColor();
    }

    public void setTextColor(int color) {
        super.setTextColor(color);
        if (this.mTextColorBuilder == null) {
            return;
        }
        this.mTextColorBuilder.setTextColor(color);
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        if (type != TextView.BufferType.SPANNABLE && this.mTextColorBuilder != null && this.mTextColorBuilder.isTextStrokeColorEnable()) {
            super.setText((CharSequence)this.mTextColorBuilder.buildStrokeFontSpannable(text), TextView.BufferType.SPANNABLE);
        } else {
            super.setText(text, type);
        }
    }

    protected void onDraw(Canvas canvas) {
        this.mTextColorBuilder.onDraw(canvas, (Paint)this.getPaint());
        super.onDraw(canvas);
    }

    @Override
    public ShapeDrawableBuilder getShapeDrawableBuilder() {
        return this.mShapeDrawableBuilder;
    }

    @Override
    public TextColorBuilder getTextColorBuilder() {
        return this.mTextColorBuilder;
    }
}

