/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.shape.span;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.NonNull;
import android.text.TextPaint;
import android.text.style.ReplacementSpan;
import com.hjq.shape.config.ITextViewAttribute;
import com.hjq.shape.span.AlignmentReplacementSpan;
import java.util.Arrays;
import java.util.List;

public class MultiFontSpan
extends AlignmentReplacementSpan {
    private float mMeasureTextWidth;
    private final List<ReplacementSpan> mReplacementSpans;

    public MultiFontSpan(ITextViewAttribute textViewAttribute, ReplacementSpan ... replacementSpans) {
        super(textViewAttribute);
        this.mReplacementSpans = Arrays.asList(replacementSpans);
    }

    public int getSize(@NonNull Paint paint, CharSequence text, int start, int end, Paint.FontMetricsInt fm) {
        for (ReplacementSpan replacementSpan : this.mReplacementSpans) {
            int size = replacementSpan.getSize(paint, text, start, end, fm);
            this.mMeasureTextWidth = Math.max(this.mMeasureTextWidth, (float)size);
        }
        return (int)this.mMeasureTextWidth;
    }

    public void draw(@NonNull Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, @NonNull Paint paint) {
        for (ReplacementSpan replacementSpan : this.mReplacementSpans) {
            replacementSpan.draw(canvas, text, start, end, x, top, y, bottom, paint);
        }
    }

    public void updateMeasureState(TextPaint p) {
        super.updateMeasureState(p);
        for (ReplacementSpan replacementSpan : this.mReplacementSpans) {
            replacementSpan.updateMeasureState(p);
        }
    }

    public void updateDrawState(TextPaint ds) {
        super.updateDrawState(ds);
        for (ReplacementSpan replacementSpan : this.mReplacementSpans) {
            replacementSpan.updateDrawState(ds);
        }
    }
}

