/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.shape.span;

import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Shader;
import android.support.annotation.NonNull;
import android.text.SpannableStringBuilder;
import com.hjq.shape.span.CommonFontSpan;

public class LinearGradientFontSpan
extends CommonFontSpan {
    public static final int GRADIENT_ORIENTATION_HORIZONTAL = 0;
    public static final int GRADIENT_ORIENTATION_VERTICAL = 1;
    private int mTextGradientOrientation;
    private int[] mTextGradientColor;
    private float[] mTextGradientPositions;

    public static SpannableStringBuilder buildLinearGradientSpannable(CharSequence text, int[] colors, float[] positions, int orientation) {
        SpannableStringBuilder builder = new SpannableStringBuilder(text);
        LinearGradientFontSpan span = new LinearGradientFontSpan().setTextGradientColor(colors).setTextGradientOrientation(orientation).setTextGradientPositions(positions);
        builder.setSpan((Object)span, 0, builder.length(), 33);
        return builder;
    }

    @Override
    public void onDraw(@NonNull Canvas canvas, @NonNull Paint paint, CharSequence text, int start, int end, float x, int top, int y, int bottom) {
        LinearGradient linearGradient = this.mTextGradientOrientation == 1 ? new LinearGradient(0.0f, 0.0f, 0.0f, paint.descent() - paint.ascent(), this.mTextGradientColor, this.mTextGradientPositions, Shader.TileMode.REPEAT) : new LinearGradient(x, 0.0f, x + this.getMeasureTextWidth(), 0.0f, this.mTextGradientColor, this.mTextGradientPositions, Shader.TileMode.REPEAT);
        paint.setShader((Shader)linearGradient);
        canvas.drawText(text, start, end, x, (float)y, paint);
    }

    public LinearGradientFontSpan setTextGradientOrientation(int orientation) {
        this.mTextGradientOrientation = orientation;
        return this;
    }

    public LinearGradientFontSpan setTextGradientColor(int[] colors) {
        this.mTextGradientColor = colors;
        return this;
    }

    public LinearGradientFontSpan setTextGradientPositions(float[] positions) {
        this.mTextGradientPositions = positions;
        return this;
    }
}

