/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.shape.builder;

import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.support.v4.widget.CompoundButtonCompat;
import android.widget.CompoundButton;
import com.hjq.shape.styleable.ICompoundButtonStyleable;

public final class ButtonDrawableBuilder {
    private final CompoundButton mCompoundButton;
    private Drawable mButtonDrawable;
    private Drawable mDrawablePressedDrawable;
    private Drawable mDrawableCheckedDrawable;
    private Drawable mDrawableDisabledDrawable;
    private Drawable mDrawableFocusedDrawable;
    private Drawable mDrawableSelectedDrawable;

    public ButtonDrawableBuilder(CompoundButton compoundButton, TypedArray typedArray, ICompoundButtonStyleable styleable2) {
        this.mCompoundButton = compoundButton;
        this.mButtonDrawable = typedArray.hasValue(styleable2.getButtonDrawableStyleable()) ? typedArray.getDrawable(styleable2.getButtonDrawableStyleable()) : CompoundButtonCompat.getButtonDrawable((CompoundButton)this.mCompoundButton);
        if (typedArray.hasValue(styleable2.getButtonPressedDrawableStyleable())) {
            this.mDrawablePressedDrawable = typedArray.getDrawable(styleable2.getButtonPressedDrawableStyleable());
        }
        if (typedArray.hasValue(styleable2.getButtonCheckedDrawableStyleable())) {
            this.mDrawableCheckedDrawable = typedArray.getDrawable(styleable2.getButtonCheckedDrawableStyleable());
        }
        if (typedArray.hasValue(styleable2.getButtonDisabledDrawableStyleable())) {
            this.mDrawableDisabledDrawable = typedArray.getDrawable(styleable2.getButtonDisabledDrawableStyleable());
        }
        if (typedArray.hasValue(styleable2.getButtonFocusedDrawableStyleable())) {
            this.mDrawableFocusedDrawable = typedArray.getDrawable(styleable2.getButtonFocusedDrawableStyleable());
        }
        if (typedArray.hasValue(styleable2.getButtonSelectedDrawableStyleable())) {
            this.mDrawableSelectedDrawable = typedArray.getDrawable(styleable2.getButtonSelectedDrawableStyleable());
        }
    }

    public ButtonDrawableBuilder setButtonDrawable(Drawable drawable) {
        if (this.mDrawablePressedDrawable == this.mButtonDrawable) {
            this.mDrawablePressedDrawable = drawable;
        }
        if (this.mDrawableCheckedDrawable == this.mButtonDrawable) {
            this.mDrawableCheckedDrawable = drawable;
        }
        if (this.mDrawableDisabledDrawable == this.mButtonDrawable) {
            this.mDrawableDisabledDrawable = drawable;
        }
        if (this.mDrawableFocusedDrawable == this.mButtonDrawable) {
            this.mDrawableFocusedDrawable = drawable;
        }
        if (this.mDrawableSelectedDrawable == this.mButtonDrawable) {
            this.mDrawableSelectedDrawable = drawable;
        }
        this.mButtonDrawable = drawable;
        return this;
    }

    public Drawable getButtonDrawable() {
        return this.mButtonDrawable;
    }

    public ButtonDrawableBuilder setDrawablePressedDrawable(Drawable drawable) {
        this.mDrawablePressedDrawable = drawable;
        return this;
    }

    public Drawable getDrawablePressedDrawable() {
        return this.mDrawablePressedDrawable;
    }

    public ButtonDrawableBuilder setDrawableCheckedDrawable(Drawable drawable) {
        this.mDrawableCheckedDrawable = drawable;
        return this;
    }

    public Drawable getDrawableCheckedDrawable() {
        return this.mDrawableCheckedDrawable;
    }

    public ButtonDrawableBuilder setDrawableDisabledDrawable(Drawable drawable) {
        this.mDrawableDisabledDrawable = drawable;
        return this;
    }

    public Drawable getDrawableDisabledDrawable() {
        return this.mDrawableDisabledDrawable;
    }

    public ButtonDrawableBuilder setDrawableFocusedDrawable(Drawable drawable) {
        this.mDrawableFocusedDrawable = drawable;
        return this;
    }

    public Drawable getDrawableFocusedDrawable() {
        return this.mDrawableFocusedDrawable;
    }

    public ButtonDrawableBuilder setDrawableSelectedDrawable(Drawable drawable) {
        this.mDrawableSelectedDrawable = drawable;
        return this;
    }

    public Drawable getDrawableSelectedDrawable() {
        return this.mDrawableSelectedDrawable;
    }

    public void intoButtonDrawable() {
        if (this.mButtonDrawable == null) {
            return;
        }
        if (this.mDrawablePressedDrawable == null && this.mDrawableCheckedDrawable == null && this.mDrawableDisabledDrawable == null && this.mDrawableFocusedDrawable == null && this.mDrawableSelectedDrawable == null) {
            this.mCompoundButton.setButtonDrawable(this.mButtonDrawable);
            return;
        }
        StateListDrawable drawable = new StateListDrawable();
        if (this.mDrawablePressedDrawable != null) {
            drawable.addState(new int[]{16842919}, this.mDrawablePressedDrawable);
        }
        if (this.mDrawableCheckedDrawable != null) {
            drawable.addState(new int[]{0x10100A0}, this.mDrawableCheckedDrawable);
        }
        if (this.mDrawableDisabledDrawable != null) {
            drawable.addState(new int[]{-16842910}, this.mDrawableDisabledDrawable);
        }
        if (this.mDrawableFocusedDrawable != null) {
            drawable.addState(new int[]{16842908}, this.mDrawableFocusedDrawable);
        }
        if (this.mDrawableSelectedDrawable != null) {
            drawable.addState(new int[]{0x10100A1}, this.mDrawableSelectedDrawable);
        }
        drawable.addState(new int[0], this.mButtonDrawable);
        this.mCompoundButton.setButtonDrawable((Drawable)drawable);
    }
}

