/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.shape.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v7.widget.AppCompatButton;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import com.hjq.shape.R;
import com.hjq.shape.builder.ShapeDrawableBuilder;
import com.hjq.shape.builder.TextColorBuilder;
import com.hjq.shape.styleable.ShapeButtonStyleable;

public class ShapeButton
extends AppCompatButton {
    private static final ShapeButtonStyleable STYLEABLE = new ShapeButtonStyleable();
    private final ShapeDrawableBuilder mShapeDrawableBuilder;
    private final TextColorBuilder mTextColorBuilder;

    public ShapeButton(Context context) {
        this(context, null);
    }

    public ShapeButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ShapeButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ShapeButton);
        this.mShapeDrawableBuilder = new ShapeDrawableBuilder((View)this, typedArray, STYLEABLE);
        this.mTextColorBuilder = new TextColorBuilder((TextView)this, typedArray, STYLEABLE);
        typedArray.recycle();
        this.mShapeDrawableBuilder.intoBackground();
        if (this.mTextColorBuilder.isTextGradientColors()) {
            this.setText(this.getText());
        } else {
            this.mTextColorBuilder.intoTextColor();
        }
    }

    public void setTextColor(int color) {
        super.setTextColor(color);
        if (this.mTextColorBuilder == null) {
            return;
        }
        this.mTextColorBuilder.setTextColor(color);
        this.mTextColorBuilder.clearTextGradientColors();
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        if (this.mTextColorBuilder != null && this.mTextColorBuilder.isTextGradientColors()) {
            super.setText((CharSequence)this.mTextColorBuilder.buildLinearGradientSpannable(text), type);
        } else {
            super.setText(text, type);
        }
    }

    public ShapeDrawableBuilder getShapeDrawableBuilder() {
        return this.mShapeDrawableBuilder;
    }

    public TextColorBuilder getTextColorBuilder() {
        return this.mTextColorBuilder;
    }
}

