/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.shape.core;

import android.content.res.ColorStateList;
import android.text.SpannableStringBuilder;
import android.view.View;
import com.hjq.shape.core.LinearGradientFontSpan;

public interface IShapeTextColor<V extends View> {
    public static final int SHAPE_TEXT_GRADIENT_TYPE_HORIZONTAL = 0;
    public static final int SHAPE_TEXT_GRADIENT_TYPE_VERTICAL = 1;

    public V setNormalTextColor(int var1);

    public int getNormalTextColor();

    public V setTextPressedColor(int var1);

    public int getTextPressedColor();

    default public V setTextCheckedColor(int color) {
        return this.setNormalTextColor(color);
    }

    default public int getTextCheckedColor() {
        return this.getNormalTextColor();
    }

    public V setTextDisabledColor(int var1);

    public int getTextDisabledColor();

    public V setTextFocusedColor(int var1);

    public int getTextFocusedColor();

    public V setTextSelectedColor(int var1);

    public int getTextSelectedColor();

    public V setTextStartColor(int var1);

    public int getTextStartColor();

    public V setTextCenterColor(int var1);

    public int getTextCenterColor();

    public V setTextEndColor(int var1);

    public int getTextEndColor();

    public V setTextGradientOrientation(int var1);

    public int getTextGradientOrientation();

    default public boolean isTextGradientColor() {
        return this.getNormalTextColor() != this.getTextStartColor() && this.getNormalTextColor() != this.getTextEndColor();
    }

    default public void clearTextGradientColor() {
        this.setTextStartColor(this.getNormalTextColor());
        this.setTextCenterColor(this.getNormalTextColor());
        this.setTextEndColor(this.getNormalTextColor());
    }

    default public SpannableStringBuilder buildLinearGradientSpannable(CharSequence text) {
        float[] positions;
        int[] colors;
        if (this.getNormalTextColor() != this.getTextCenterColor()) {
            colors = new int[]{this.getTextStartColor(), this.getTextCenterColor(), this.getTextEndColor()};
            positions = new float[]{0.0f, 0.5f, 1.0f};
        } else {
            colors = new int[]{this.getTextStartColor(), this.getTextEndColor()};
            positions = new float[]{0.0f, 1.0f};
        }
        return this.buildLinearGradientSpannable(text, colors, positions);
    }

    default public SpannableStringBuilder buildLinearGradientSpannable(CharSequence text, int[] colors, float[] positions) {
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder(text);
        LinearGradientFontSpan linearGradientFontSpan = new LinearGradientFontSpan();
        linearGradientFontSpan.setTextGradientColor(colors);
        linearGradientFontSpan.setTextGradientOrientation(this.getTextGradientOrientation());
        linearGradientFontSpan.setTextGradientPositions(positions);
        spannableStringBuilder.setSpan((Object)linearGradientFontSpan, 0, spannableStringBuilder.length(), 33);
        return spannableStringBuilder;
    }

    default public ColorStateList buildColorState() {
        return new ColorStateList((int[][])new int[][]{{16842919}, {0x10100A0}, {-16842910}, {16842908}, {0x10100A1}, new int[0]}, new int[]{this.getTextPressedColor(), this.getTextCheckedColor(), this.getTextDisabledColor(), this.getTextFocusedColor(), this.getTextSelectedColor(), this.getNormalTextColor()});
    }

    public void intoTextColor();
}

