/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.shape.core;

import android.annotation.SuppressLint;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.DashPathEffect;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.graphics.drawable.Drawable;
import android.os.Build;
import com.hjq.shape.core.ShapeGradientOrientation;
import com.hjq.shape.core.ShapeState;

public class ShapeDrawable
extends Drawable {
    private ShapeState mShapeState;
    private final Paint mFillPaint = new Paint(1);
    private Rect mPadding;
    private Paint mStrokePaint;
    private ColorFilter mColorFilter;
    private int mAlpha = 255;
    private boolean mDither;
    private final Path mPath = new Path();
    private final RectF mRect = new RectF();
    private Paint mLayerPaint;
    private boolean mRectIsDirty;
    private boolean mMutated;
    private Path mRingPath;
    private boolean mPathIsDirty = true;

    public ShapeDrawable() {
        this(new ShapeState(ShapeGradientOrientation.TOP_BOTTOM, null));
    }

    public ShapeDrawable(ShapeGradientOrientation orientation, int[] colors) {
        this(new ShapeState(orientation, colors));
    }

    public ShapeDrawable(ShapeState state) {
        this.mShapeState = state;
        this.initializeWithState(state);
        this.mRectIsDirty = true;
        this.mMutated = false;
    }

    public boolean getPadding(Rect padding) {
        if (this.mPadding != null) {
            padding.set(this.mPadding);
            return true;
        }
        return super.getPadding(padding);
    }

    public void setPadding(Rect padding) {
        this.mPadding = padding;
    }

    public void setCornerRadii(float[] radii) {
        this.mShapeState.setCornerRadii(radii);
        this.mPathIsDirty = true;
        this.invalidateSelf();
    }

    public void setCornerRadius(float radius) {
        this.mShapeState.setCornerRadius(radius);
        this.mPathIsDirty = true;
        this.invalidateSelf();
    }

    public void setStroke(int width, int color) {
        this.setStroke(width, color, 0.0f, 0.0f);
    }

    public void setStroke(int width, int color, float dashWidth, float dashGap) {
        this.mShapeState.setStroke(width, color, dashWidth, dashGap);
        if (this.mStrokePaint == null) {
            this.mStrokePaint = new Paint(1);
            this.mStrokePaint.setStyle(Paint.Style.STROKE);
        }
        this.mStrokePaint.setStrokeWidth((float)width);
        this.mStrokePaint.setColor(color);
        DashPathEffect e = null;
        if (dashWidth > 0.0f) {
            e = new DashPathEffect(new float[]{dashWidth, dashGap}, 0.0f);
        }
        this.mStrokePaint.setPathEffect(e);
        this.invalidateSelf();
    }

    public void setSize(int width, int height) {
        this.mShapeState.setSize(width, height);
        this.mPathIsDirty = true;
        this.invalidateSelf();
    }

    public void setShape(int shape) {
        this.mRingPath = null;
        this.mPathIsDirty = true;
        this.mShapeState.setShapeType(shape);
        this.invalidateSelf();
    }

    public void setGradientType(int type) {
        this.mShapeState.setGradientType(type);
        this.mRectIsDirty = true;
        this.invalidateSelf();
    }

    public void setGradientCenter(float x, float y) {
        this.mShapeState.setGradientCenter(x, y);
        this.mRectIsDirty = true;
        this.invalidateSelf();
    }

    public void setGradientRadius(float radius) {
        this.mShapeState.setGradientRadius(radius);
        this.mRectIsDirty = true;
        this.invalidateSelf();
    }

    public void setUseLevel(boolean useLevel) {
        this.mShapeState.mUseLevel = useLevel;
        this.mRectIsDirty = true;
        this.invalidateSelf();
    }

    private int modulateAlpha(int alpha) {
        int scale = this.mAlpha + (this.mAlpha >> 7);
        return alpha * scale >> 8;
    }

    public void setGradientAngle(int angle) {
        if ((angle %= 360) % 45 == 0) {
            switch (angle) {
                case 0: {
                    this.setGradientOrientation(ShapeGradientOrientation.LEFT_RIGHT);
                    break;
                }
                case 45: {
                    this.setGradientOrientation(ShapeGradientOrientation.BL_TR);
                    break;
                }
                case 90: {
                    this.setGradientOrientation(ShapeGradientOrientation.BOTTOM_TOP);
                    break;
                }
                case 135: {
                    this.setGradientOrientation(ShapeGradientOrientation.BR_TL);
                    break;
                }
                case 180: {
                    this.setGradientOrientation(ShapeGradientOrientation.RIGHT_LEFT);
                    break;
                }
                case 225: {
                    this.setGradientOrientation(ShapeGradientOrientation.TR_BL);
                    break;
                }
                case 270: {
                    this.setGradientOrientation(ShapeGradientOrientation.TOP_BOTTOM);
                    break;
                }
                case 315: {
                    this.setGradientOrientation(ShapeGradientOrientation.TL_BR);
                    break;
                }
            }
        }
    }

    public ShapeGradientOrientation getGradientOrientation() {
        return this.mShapeState.mOrientation;
    }

    public void setGradientOrientation(ShapeGradientOrientation orientation) {
        this.mShapeState.mOrientation = orientation;
        this.mRectIsDirty = true;
        this.invalidateSelf();
    }

    public void setColor(int argb) {
        this.mShapeState.setSolidColor(argb);
        this.mFillPaint.setColor(argb);
        this.invalidateSelf();
    }

    public void setColors(int[] colors) {
        this.mShapeState.setColors(colors);
        this.mRectIsDirty = true;
        this.invalidateSelf();
    }

    public void setInnerRadius(int radius) {
        this.mShapeState.mInnerRadius = radius;
        this.mRectIsDirty = true;
        this.invalidateSelf();
    }

    public void setInnerRadiusRatio(float radiusRatio) {
        this.mShapeState.mInnerRadiusRatio = radiusRatio;
        this.mRectIsDirty = true;
        this.invalidateSelf();
    }

    public void setThickness(int size) {
        this.mShapeState.mThickness = size;
        this.mRectIsDirty = true;
        this.invalidateSelf();
    }

    public void setThicknessRatio(float radiusRatio) {
        this.mShapeState.mThicknessRatio = radiusRatio;
        this.mRectIsDirty = true;
        this.invalidateSelf();
    }

    public void setShadowColor(int color) {
        this.mShapeState.setShadowColor(color);
        this.mPathIsDirty = true;
        this.invalidateSelf();
    }

    public void setShadowSize(int size) {
        this.mShapeState.setShadowSize(size);
        this.mPathIsDirty = true;
        this.invalidateSelf();
    }

    public void setShadowOffsetX(int offsetX) {
        this.mShapeState.setShadowOffsetX(offsetX);
        this.mPathIsDirty = true;
        this.invalidateSelf();
    }

    public void setShadowOffsetY(int offsetY) {
        this.mShapeState.setShadowOffsetY(offsetY);
        this.mPathIsDirty = true;
        this.invalidateSelf();
    }

    @SuppressLint(value={"WrongConstant"})
    public void draw(Canvas canvas) {
        float rad;
        boolean useLayer;
        if (!this.ensureValidRect()) {
            return;
        }
        int prevFillAlpha = this.mFillPaint.getAlpha();
        int prevStrokeAlpha = this.mStrokePaint != null ? this.mStrokePaint.getAlpha() : 0;
        int currFillAlpha = this.modulateAlpha(prevFillAlpha);
        int currStrokeAlpha = this.modulateAlpha(prevStrokeAlpha);
        boolean haveStroke = currStrokeAlpha > 0 && this.mStrokePaint != null && this.mStrokePaint.getStrokeWidth() > 0.0f;
        boolean haveFill = currFillAlpha > 0;
        ShapeState st = this.mShapeState;
        boolean bl = useLayer = haveStroke && haveFill && st.mShapeType != 2 && currStrokeAlpha < 255 && (this.mAlpha < 255 || this.mColorFilter != null);
        if (this.mShapeState.mShadowSize > 0) {
            if (haveStroke) {
                this.mStrokePaint.setShadowLayer((float)this.mShapeState.mShadowSize, (float)this.mShapeState.mShadowOffsetX, (float)this.mShapeState.mShadowOffsetY, this.mShapeState.mShadowColor);
            } else {
                this.mFillPaint.setShadowLayer((float)this.mShapeState.mShadowSize, (float)this.mShapeState.mShadowOffsetX, (float)this.mShapeState.mShadowOffsetY, this.mShapeState.mShadowColor);
            }
        } else if (haveStroke) {
            this.mStrokePaint.clearShadowLayer();
        } else {
            this.mFillPaint.clearShadowLayer();
        }
        if (useLayer) {
            if (this.mLayerPaint == null) {
                this.mLayerPaint = new Paint();
            }
            this.mLayerPaint.setDither(this.mDither);
            this.mLayerPaint.setAlpha(this.mAlpha);
            this.mLayerPaint.setColorFilter(this.mColorFilter);
            rad = this.mStrokePaint.getStrokeWidth();
            if (Build.VERSION.SDK_INT >= 21) {
                canvas.saveLayer(this.mRect.left - rad, this.mRect.top - rad, this.mRect.right + rad, this.mRect.bottom + rad, this.mLayerPaint);
            } else {
                canvas.saveLayer(this.mRect.left - rad, this.mRect.top - rad, this.mRect.right + rad, this.mRect.bottom + rad, this.mLayerPaint, 4);
            }
            this.mFillPaint.setColorFilter(null);
            this.mStrokePaint.setColorFilter(null);
        } else {
            this.mFillPaint.setAlpha(currFillAlpha);
            this.mFillPaint.setDither(this.mDither);
            this.mFillPaint.setColorFilter(this.mColorFilter);
            if (this.mColorFilter != null && !this.mShapeState.mHasSolidColor) {
                this.mFillPaint.setColor(this.mAlpha << 24);
            }
            if (haveStroke) {
                this.mStrokePaint.setAlpha(currStrokeAlpha);
                this.mStrokePaint.setDither(this.mDither);
                this.mStrokePaint.setColorFilter(this.mColorFilter);
            }
        }
        switch (st.mShapeType) {
            case 0: {
                if (st.mRadiusArray != null) {
                    if (this.mPathIsDirty || this.mRectIsDirty) {
                        this.mPath.reset();
                        this.mPath.addRoundRect(this.mRect, st.mRadiusArray, Path.Direction.CW);
                        this.mRectIsDirty = false;
                        this.mPathIsDirty = false;
                    }
                    canvas.drawPath(this.mPath, this.mFillPaint);
                    if (!haveStroke) break;
                    canvas.drawPath(this.mPath, this.mStrokePaint);
                    break;
                }
                if (st.mRadius > 0.0f) {
                    rad = st.mRadius;
                    float r = Math.min(this.mRect.width(), this.mRect.height()) * 0.5f;
                    if (rad > r) {
                        rad = r;
                    }
                    canvas.drawRoundRect(this.mRect, rad, rad, this.mFillPaint);
                    if (!haveStroke) break;
                    canvas.drawRoundRect(this.mRect, rad, rad, this.mStrokePaint);
                    break;
                }
                if (this.mFillPaint.getColor() != 0 || this.mColorFilter != null || this.mFillPaint.getShader() != null) {
                    canvas.drawRect(this.mRect, this.mFillPaint);
                }
                if (!haveStroke) break;
                canvas.drawRect(this.mRect, this.mStrokePaint);
                break;
            }
            case 1: {
                canvas.drawOval(this.mRect, this.mFillPaint);
                if (!haveStroke) break;
                canvas.drawOval(this.mRect, this.mStrokePaint);
                break;
            }
            case 2: {
                RectF r = this.mRect;
                float y = r.centerY();
                canvas.drawLine(r.left, y, r.right, y, this.mStrokePaint);
                break;
            }
            case 3: {
                Path path = this.buildRing(st);
                canvas.drawPath(path, this.mFillPaint);
                if (!haveStroke) break;
                canvas.drawPath(path, this.mStrokePaint);
            }
        }
        if (useLayer) {
            canvas.restore();
        } else {
            this.mFillPaint.setAlpha(prevFillAlpha);
            if (haveStroke) {
                this.mStrokePaint.setAlpha(prevStrokeAlpha);
            }
        }
    }

    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mShapeState.mChangingConfigurations;
    }

    public void setAlpha(int alpha) {
        if (alpha != this.mAlpha) {
            this.mAlpha = alpha;
            this.invalidateSelf();
        }
    }

    public int getAlpha() {
        return this.mAlpha;
    }

    public void setDither(boolean dither) {
        if (dither != this.mDither) {
            this.mDither = dither;
            this.invalidateSelf();
        }
    }

    public void setColorFilter(ColorFilter cf) {
        if (cf != this.mColorFilter) {
            this.mColorFilter = cf;
            this.invalidateSelf();
        }
    }

    public int getOpacity() {
        return this.mShapeState.mOpaque ? -1 : -3;
    }

    protected void onBoundsChange(Rect r) {
        super.onBoundsChange(r);
        this.mRingPath = null;
        this.mPathIsDirty = true;
        this.mRectIsDirty = true;
    }

    protected boolean onLevelChange(int level) {
        super.onLevelChange(level);
        this.mRectIsDirty = true;
        this.mPathIsDirty = true;
        this.invalidateSelf();
        return true;
    }

    private Path buildRing(ShapeState st) {
        if (!(this.mRingPath == null || st.mUseLevelForShape && this.mPathIsDirty)) {
            return this.mRingPath;
        }
        this.mPathIsDirty = false;
        float sweep = st.mUseLevelForShape ? 360.0f * (float)this.getLevel() / 10000.0f : 360.0f;
        RectF bounds = new RectF(this.mRect);
        float x = bounds.width() / 2.0f;
        float y = bounds.height() / 2.0f;
        float thickness = st.mThickness != -1 ? (float)st.mThickness : bounds.width() / st.mThicknessRatio;
        float radius = st.mInnerRadius != -1 ? (float)st.mInnerRadius : bounds.width() / st.mInnerRadiusRatio;
        RectF innerBounds = new RectF(bounds);
        innerBounds.inset(x - radius, y - radius);
        bounds = new RectF(innerBounds);
        bounds.inset(-thickness, -thickness);
        if (this.mRingPath == null) {
            this.mRingPath = new Path();
        } else {
            this.mRingPath.reset();
        }
        Path ringPath = this.mRingPath;
        if (sweep < 360.0f && sweep > -360.0f) {
            ringPath.setFillType(Path.FillType.EVEN_ODD);
            ringPath.moveTo(x + radius, y);
            ringPath.lineTo(x + radius + thickness, y);
            ringPath.arcTo(bounds, 0.0f, sweep, false);
            ringPath.arcTo(innerBounds, sweep, -sweep, false);
            ringPath.close();
        } else {
            ringPath.addOval(bounds, Path.Direction.CW);
            ringPath.addOval(innerBounds, Path.Direction.CCW);
        }
        return ringPath;
    }

    private boolean ensureValidRect() {
        if (this.mRectIsDirty) {
            this.mRectIsDirty = false;
            Rect bounds = this.getBounds();
            float inset = 0.0f;
            if (this.mStrokePaint != null) {
                inset = this.mStrokePaint.getStrokeWidth() * 0.5f;
            }
            ShapeState st = this.mShapeState;
            this.mRect.set((float)bounds.left + inset + (float)this.mShapeState.mShadowSize, (float)bounds.top + inset + (float)this.mShapeState.mShadowSize, (float)bounds.right - inset - (float)this.mShapeState.mShadowSize, (float)bounds.bottom - inset - (float)this.mShapeState.mShadowSize);
            int[] colors = st.mColors;
            if (colors != null) {
                RectF r = this.mRect;
                if (st.mGradient == 0) {
                    float y1;
                    float x1;
                    float y0;
                    float x0;
                    float level = st.mUseLevel ? (float)this.getLevel() / 10000.0f : 1.0f;
                    switch (st.mOrientation) {
                        case TOP_BOTTOM: {
                            x0 = r.left;
                            y0 = r.top;
                            x1 = x0;
                            y1 = level * r.bottom;
                            break;
                        }
                        case TR_BL: {
                            x0 = r.right;
                            y0 = r.top;
                            x1 = level * r.left;
                            y1 = level * r.bottom;
                            break;
                        }
                        case RIGHT_LEFT: {
                            x0 = r.right;
                            y0 = r.top;
                            x1 = level * r.left;
                            y1 = y0;
                            break;
                        }
                        case BR_TL: {
                            x0 = r.right;
                            y0 = r.bottom;
                            x1 = level * r.left;
                            y1 = level * r.top;
                            break;
                        }
                        case BOTTOM_TOP: {
                            x0 = r.left;
                            y0 = r.bottom;
                            x1 = x0;
                            y1 = level * r.top;
                            break;
                        }
                        case BL_TR: {
                            x0 = r.left;
                            y0 = r.bottom;
                            x1 = level * r.right;
                            y1 = level * r.top;
                            break;
                        }
                        case LEFT_RIGHT: {
                            x0 = r.left;
                            y0 = r.top;
                            x1 = level * r.right;
                            y1 = y0;
                            break;
                        }
                        default: {
                            x0 = r.left;
                            y0 = r.top;
                            x1 = level * r.right;
                            y1 = level * r.bottom;
                        }
                    }
                    this.mFillPaint.setShader((Shader)new LinearGradient(x0, y0, x1, y1, colors, st.mPositions, Shader.TileMode.CLAMP));
                } else if (st.mGradient == 1) {
                    float x0 = r.left + (r.right - r.left) * st.mCenterX;
                    float y0 = r.top + (r.bottom - r.top) * st.mCenterY;
                    float level = st.mUseLevel ? (float)this.getLevel() / 10000.0f : 1.0f;
                    this.mFillPaint.setShader((Shader)new RadialGradient(x0, y0, level * st.mGradientRadius, colors, null, Shader.TileMode.CLAMP));
                } else if (st.mGradient == 2) {
                    float x0 = r.left + (r.right - r.left) * st.mCenterX;
                    float y0 = r.top + (r.bottom - r.top) * st.mCenterY;
                    int[] tempColors = colors;
                    float[] tempPositions = null;
                    if (st.mUseLevel) {
                        tempColors = st.mTempColors;
                        int length = colors.length;
                        if (tempColors == null || tempColors.length != length + 1) {
                            st.mTempColors = new int[length + 1];
                            tempColors = st.mTempColors;
                        }
                        System.arraycopy(colors, 0, tempColors, 0, length);
                        tempColors[length] = colors[length - 1];
                        tempPositions = st.mTempPositions;
                        float fraction = 1.0f / (float)(length - 1);
                        if (tempPositions == null || tempPositions.length != length + 1) {
                            tempPositions = st.mTempPositions = new float[length + 1];
                        }
                        float level = (float)this.getLevel() / 10000.0f;
                        for (int i = 0; i < length; ++i) {
                            tempPositions[i] = (float)i * fraction * level;
                        }
                        tempPositions[length] = 1.0f;
                    }
                    this.mFillPaint.setShader((Shader)new SweepGradient(x0, y0, tempColors, tempPositions));
                }
                if (!st.mHasSolidColor) {
                    this.mFillPaint.setColor(-16777216);
                }
            }
        }
        return !this.mRect.isEmpty();
    }

    public int getIntrinsicWidth() {
        return this.mShapeState.mWidth;
    }

    public int getIntrinsicHeight() {
        return this.mShapeState.mHeight;
    }

    public Drawable.ConstantState getConstantState() {
        this.mShapeState.mChangingConfigurations = this.getChangingConfigurations();
        return this.mShapeState;
    }

    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mShapeState = new ShapeState(this.mShapeState);
            this.initializeWithState(this.mShapeState);
            this.mMutated = true;
        }
        return this;
    }

    private void initializeWithState(ShapeState state) {
        if (state.mHasSolidColor) {
            this.mFillPaint.setColor(state.mSolidColor);
        } else if (state.mColors == null) {
            this.mFillPaint.setColor(0);
        } else {
            this.mFillPaint.setColor(-16777216);
        }
        this.mPadding = state.mPadding;
        if (state.mStrokeWidth >= 0) {
            this.mStrokePaint = new Paint(1);
            this.mStrokePaint.setStyle(Paint.Style.STROKE);
            this.mStrokePaint.setStrokeWidth((float)state.mStrokeWidth);
            this.mStrokePaint.setColor(state.mStrokeColor);
            if (state.mStrokeDashWidth != 0.0f) {
                DashPathEffect e = new DashPathEffect(new float[]{state.mStrokeDashWidth, state.mStrokeDashGap}, 0.0f);
                this.mStrokePaint.setPathEffect((PathEffect)e);
            }
        }
    }
}

