/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.shape.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v7.widget.AppCompatButton;
import android.util.AttributeSet;
import com.hjq.shape.IShapeDrawable;
import com.hjq.shape.IShapeTextColor;
import com.hjq.shape.R;

public class ShapeButton
extends AppCompatButton
implements IShapeDrawable<ShapeButton>,
IShapeTextColor<ShapeButton> {
    private int mShape;
    private int mShapeWidth;
    private int mShapeHeight;
    private int mSolidColor;
    private int mSolidPressedColor;
    private int mSolidDisabledColor;
    private int mSolidFocusedColor;
    private int mSolidSelectedColor;
    private int mTopLeftRadius;
    private int mTopRightRadius;
    private int mBottomLeftRadius;
    private int mBottomRightRadius;
    private int mStartColor;
    private int mCenterColor;
    private int mEndColor;
    private boolean mUseLevel;
    private int mAngle;
    private int mGradientType;
    private float mCenterX;
    private float mCenterY;
    private int mGradientRadius;
    private int mStrokeColor;
    private int mStrokePressedColor;
    private int mStrokeDisabledColor;
    private int mStrokeFocusedColor;
    private int mStrokeSelectedColor;
    private int mStrokeWidth;
    private int mDashWidth;
    private int mDashGap;
    private int mTextColor;
    private int mTextPressedColor;
    private int mTextCheckedColor;
    private int mTextDisabledColor;
    private int mTextFocusedColor;
    private int mTextSelectedColor;

    public ShapeButton(Context context) {
        this(context, null);
    }

    public ShapeButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ShapeButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ShapeButton);
        this.mShape = typedArray.getInt(R.styleable.ShapeButton_shape, 0);
        this.mShapeWidth = typedArray.getDimensionPixelSize(R.styleable.ShapeButton_shape_width, -1);
        this.mShapeHeight = typedArray.getDimensionPixelSize(R.styleable.ShapeButton_shape_height, -1);
        this.mSolidColor = typedArray.getColor(R.styleable.ShapeButton_shape_solidColor, 0);
        this.mSolidPressedColor = typedArray.getColor(R.styleable.ShapeButton_shape_solidPressedColor, this.mSolidColor);
        this.mSolidDisabledColor = typedArray.getColor(R.styleable.ShapeButton_shape_solidDisabledColor, this.mSolidColor);
        this.mSolidFocusedColor = typedArray.getColor(R.styleable.ShapeButton_shape_solidFocusedColor, this.mSolidColor);
        this.mSolidSelectedColor = typedArray.getColor(R.styleable.ShapeButton_shape_solidSelectedColor, this.mSolidColor);
        int radius = typedArray.getDimensionPixelSize(R.styleable.ShapeButton_shape_radius, 0);
        this.mTopLeftRadius = typedArray.getDimensionPixelSize(R.styleable.ShapeButton_shape_topLeftRadius, radius);
        this.mTopRightRadius = typedArray.getDimensionPixelSize(R.styleable.ShapeButton_shape_topRightRadius, radius);
        this.mBottomLeftRadius = typedArray.getDimensionPixelSize(R.styleable.ShapeButton_shape_bottomLeftRadius, radius);
        this.mBottomRightRadius = typedArray.getDimensionPixelSize(R.styleable.ShapeButton_shape_bottomRightRadius, radius);
        this.mStartColor = typedArray.getColor(R.styleable.ShapeButton_shape_startColor, 0);
        this.mCenterColor = typedArray.getColor(R.styleable.ShapeButton_shape_centerColor, 0);
        this.mEndColor = typedArray.getColor(R.styleable.ShapeButton_shape_endColor, 0);
        this.mUseLevel = typedArray.getBoolean(R.styleable.ShapeButton_shape_useLevel, false);
        this.mAngle = (int)typedArray.getFloat(R.styleable.ShapeButton_shape_angle, 0.0f);
        this.mGradientType = typedArray.getInt(R.styleable.ShapeButton_shape_gradientType, 0);
        this.mCenterX = typedArray.getFloat(R.styleable.ShapeButton_shape_centerX, 0.5f);
        this.mCenterY = typedArray.getFloat(R.styleable.ShapeButton_shape_centerX, 0.5f);
        this.mGradientRadius = typedArray.getDimensionPixelSize(R.styleable.ShapeButton_shape_gradientRadius, radius);
        this.mStrokeColor = typedArray.getColor(R.styleable.ShapeButton_shape_strokeColor, 0);
        this.mStrokePressedColor = typedArray.getColor(R.styleable.ShapeButton_shape_strokePressedColor, this.mStrokeColor);
        this.mStrokeDisabledColor = typedArray.getColor(R.styleable.ShapeButton_shape_strokeDisabledColor, this.mStrokeColor);
        this.mStrokeFocusedColor = typedArray.getColor(R.styleable.ShapeButton_shape_strokeFocusedColor, this.mStrokeColor);
        this.mStrokeSelectedColor = typedArray.getColor(R.styleable.ShapeButton_shape_strokeSelectedColor, this.mStrokeColor);
        this.mStrokeWidth = typedArray.getDimensionPixelSize(R.styleable.ShapeButton_shape_strokeWidth, 0);
        this.mDashWidth = (int)typedArray.getDimension(R.styleable.ShapeButton_shape_dashWidth, 0.0f);
        this.mDashGap = (int)typedArray.getDimension(R.styleable.ShapeButton_shape_dashGap, 0.0f);
        this.mTextColor = typedArray.getColor(R.styleable.ShapeButton_shape_textColor, this.getTextColors().getDefaultColor());
        this.mTextPressedColor = typedArray.getColor(R.styleable.ShapeButton_shape_textPressedColor, this.getTextColors().getColorForState(new int[]{16842919}, this.mTextColor));
        this.mTextDisabledColor = typedArray.getColor(R.styleable.ShapeButton_shape_textDisabledColor, this.getTextColors().getColorForState(new int[]{-16842910}, this.mTextColor));
        this.mTextFocusedColor = typedArray.getColor(R.styleable.ShapeButton_shape_textFocusedColor, this.getTextColors().getColorForState(new int[]{16842908}, this.mTextColor));
        this.mTextSelectedColor = typedArray.getColor(R.styleable.ShapeButton_shape_textSelectedColor, this.getTextColors().getColorForState(new int[]{0x10100A1}, this.mTextColor));
        typedArray.recycle();
        this.intoBackground();
        this.intoTextColor();
    }

    @Override
    public ShapeButton setShape(int shape) {
        this.mShape = shape;
        return this;
    }

    @Override
    public int getShape() {
        return this.mShape;
    }

    @Override
    public ShapeButton setShapeWidth(int width) {
        this.mShapeWidth = width;
        return this;
    }

    @Override
    public int getShapeWidth() {
        return this.mShapeWidth;
    }

    @Override
    public ShapeButton setShapeHeight(int height) {
        this.mShapeHeight = height;
        return this;
    }

    @Override
    public int getShapeHeight() {
        return this.mShapeHeight;
    }

    @Override
    public ShapeButton setSolidColor(int color) {
        this.mSolidColor = color;
        return this;
    }

    @Override
    public int getSolidColor() {
        return this.mSolidColor;
    }

    @Override
    public ShapeButton setSolidPressedColor(int color) {
        this.mSolidPressedColor = color;
        return this;
    }

    @Override
    public int getSolidPressedColor() {
        return this.mSolidPressedColor;
    }

    @Override
    public ShapeButton setSolidDisabledColor(int color) {
        this.mSolidDisabledColor = color;
        return this;
    }

    @Override
    public int getSolidDisabledColor() {
        return this.mSolidDisabledColor;
    }

    @Override
    public ShapeButton setSolidFocusedColor(int color) {
        this.mSolidFocusedColor = color;
        return this;
    }

    @Override
    public int getSolidFocusedColor() {
        return this.mSolidFocusedColor;
    }

    @Override
    public ShapeButton setSolidSelectedColor(int color) {
        this.mSolidSelectedColor = color;
        return this;
    }

    @Override
    public int getSolidSelectedColor() {
        return this.mSolidSelectedColor;
    }

    @Override
    public ShapeButton setTopLeftRadius(int radius) {
        this.mTopLeftRadius = radius;
        return this;
    }

    @Override
    public int getTopLeftRadius() {
        return this.mTopLeftRadius;
    }

    @Override
    public ShapeButton setTopRightRadius(int radius) {
        this.mTopRightRadius = radius;
        return this;
    }

    @Override
    public int getTopRightRadius() {
        return this.mTopRightRadius;
    }

    @Override
    public ShapeButton setBottomLeftRadius(int radius) {
        this.mBottomLeftRadius = radius;
        return this;
    }

    @Override
    public int getBottomLeftRadius() {
        return this.mBottomLeftRadius;
    }

    @Override
    public ShapeButton setBottomRightRadius(int radius) {
        this.mBottomRightRadius = radius;
        return this;
    }

    @Override
    public int getBottomRightRadius() {
        return this.mBottomRightRadius;
    }

    @Override
    public ShapeButton setStartColor(int color) {
        this.mStartColor = color;
        return this;
    }

    @Override
    public int getStartColor() {
        return this.mStartColor;
    }

    @Override
    public ShapeButton setCenterColor(int color) {
        this.mCenterColor = color;
        return this;
    }

    @Override
    public int getCenterColor() {
        return this.mCenterColor;
    }

    @Override
    public ShapeButton setEndColor(int color) {
        this.mEndColor = color;
        return this;
    }

    @Override
    public int getEndColor() {
        return this.mEndColor;
    }

    @Override
    public ShapeButton setUseLevel(boolean useLevel) {
        this.mUseLevel = useLevel;
        return this;
    }

    @Override
    public boolean isUseLevel() {
        return this.mUseLevel;
    }

    @Override
    public ShapeButton setAngle(int angle) {
        this.mAngle = angle;
        return this;
    }

    @Override
    public int getAngle() {
        return this.mAngle;
    }

    @Override
    public ShapeButton setGradientType(int type) {
        this.mGradientType = type;
        return this;
    }

    @Override
    public int getGradientType() {
        return this.mGradientType;
    }

    @Override
    public ShapeButton setCenterX(float x) {
        this.mCenterX = x;
        return this;
    }

    @Override
    public float getCenterX() {
        return this.mCenterX;
    }

    @Override
    public ShapeButton setCenterY(float y) {
        this.mCenterY = y;
        return this;
    }

    @Override
    public float getCenterY() {
        return this.mCenterY;
    }

    @Override
    public ShapeButton setGradientRadius(int radius) {
        this.mGradientRadius = radius;
        return this;
    }

    @Override
    public int getGradientRadius() {
        return this.mGradientRadius;
    }

    @Override
    public ShapeButton setStrokeColor(int color) {
        this.mStrokeColor = color;
        return this;
    }

    @Override
    public int getStrokeColor() {
        return this.mStrokeColor;
    }

    @Override
    public ShapeButton setStrokePressedColor(int color) {
        this.mStrokePressedColor = color;
        return this;
    }

    @Override
    public int getStrokePressedColor() {
        return this.mStrokePressedColor;
    }

    @Override
    public ShapeButton setStrokeDisabledColor(int color) {
        this.mStrokeDisabledColor = color;
        return this;
    }

    @Override
    public int getStrokeDisabledColor() {
        return this.mStrokeDisabledColor;
    }

    @Override
    public ShapeButton setStrokeFocusedColor(int color) {
        this.mStrokeFocusedColor = color;
        return this;
    }

    @Override
    public int getStrokeFocusedColor() {
        return this.mStrokeFocusedColor;
    }

    @Override
    public ShapeButton setStrokeSelectedColor(int color) {
        this.mStrokeSelectedColor = color;
        return this;
    }

    @Override
    public int getStrokeSelectedColor() {
        return this.mStrokeSelectedColor;
    }

    @Override
    public ShapeButton setStrokeWidth(int width) {
        this.mStrokeWidth = width;
        return this;
    }

    @Override
    public int getStrokeWidth() {
        return this.mStrokeWidth;
    }

    @Override
    public ShapeButton setDashWidth(int width) {
        this.mDashWidth = width;
        return this;
    }

    @Override
    public int getDashWidth() {
        return this.mDashWidth;
    }

    @Override
    public ShapeButton setDashGap(int gap) {
        this.mDashGap = gap;
        return this;
    }

    @Override
    public int getDashGap() {
        return this.mDashGap;
    }

    @Override
    public void intoBackground() {
        this.setBackground(this.buildDrawable());
    }

    public void setTextColor(int color) {
        super.setTextColor(color);
        this.mTextColor = color;
    }

    @Override
    public ShapeButton setNormalTextColor(int color) {
        this.mTextColor = color;
        return this;
    }

    @Override
    public int getNormalTextColor() {
        return this.mTextColor;
    }

    @Override
    public ShapeButton setTextPressedColor(int color) {
        this.mTextPressedColor = color;
        return this;
    }

    @Override
    public int getTextPressedColor() {
        return this.mTextPressedColor;
    }

    @Override
    public ShapeButton setTextCheckedColor(int color) {
        this.mTextCheckedColor = color;
        return this;
    }

    @Override
    public int getTextCheckedColor() {
        return this.mTextCheckedColor;
    }

    @Override
    public ShapeButton setTextDisabledColor(int color) {
        this.mTextDisabledColor = color;
        return this;
    }

    @Override
    public int getTextDisabledColor() {
        return this.mTextDisabledColor;
    }

    @Override
    public ShapeButton setTextFocusedColor(int color) {
        this.mTextFocusedColor = color;
        return this;
    }

    @Override
    public int getTextFocusedColor() {
        return this.mTextFocusedColor;
    }

    @Override
    public ShapeButton setTextSelectedColor(int color) {
        this.mTextSelectedColor = color;
        return this;
    }

    @Override
    public int getTextSelectedColor() {
        return this.mTextSelectedColor;
    }

    @Override
    public void intoTextColor() {
        this.setTextColor(this.buildColorState());
    }
}

