/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.shape.drawable;

import android.content.res.Resources;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import com.hjq.shape.drawable.ShapeDrawable;

public class ShapeState
extends Drawable.ConstantState {
    public int changingConfigurations;
    public int shapeType = 0;
    public int solidGradientType = 0;
    public int solidGradientOrientation = 270;
    public int[] solidColors;
    public int[] strokeColors;
    public int[] tempSolidColors;
    public float[] tempSolidPositions;
    public float[] positions;
    public boolean hasSolidColor;
    public boolean hasStrokeColor;
    public int solidColor;
    public int strokeSize = -1;
    public int strokeGradientOrientation = 270;
    public int strokeColor;
    public float strokeDashSize;
    public float strokeDashGap;
    public float radius;
    public float[] radiusArray;
    public Rect padding;
    public int width = -1;
    public int height = -1;
    public float ringInnerRadiusRatio;
    public float ringThicknessRatio;
    public int ringInnerRadiusSize = -1;
    public int ringThicknessSize = -1;
    public float solidCenterX = 0.5f;
    public float solidCenterY = 0.5f;
    public float gradientRadius = 0.5f;
    public boolean useLevel;
    public boolean useLevelForShape;
    public boolean opaque;
    public int shadowSize;
    public int shadowColor;
    public int shadowOffsetX;
    public int shadowOffsetY;
    public int lineGravity = 17;

    public ShapeState() {
    }

    public ShapeState(ShapeState state) {
        this.changingConfigurations = state.changingConfigurations;
        this.shapeType = state.shapeType;
        this.solidGradientType = state.solidGradientType;
        this.solidGradientOrientation = state.solidGradientOrientation;
        if (state.solidColors != null) {
            this.solidColors = (int[])state.solidColors.clone();
        }
        if (state.strokeColors != null) {
            this.strokeColors = (int[])state.strokeColors.clone();
        }
        if (state.positions != null) {
            this.positions = (float[])state.positions.clone();
        }
        this.hasSolidColor = state.hasSolidColor;
        this.hasStrokeColor = state.hasStrokeColor;
        this.solidColor = state.solidColor;
        this.strokeSize = state.strokeSize;
        this.strokeColor = state.strokeColor;
        this.strokeDashSize = state.strokeDashSize;
        this.strokeDashGap = state.strokeDashGap;
        this.radius = state.radius;
        if (state.radiusArray != null) {
            this.radiusArray = (float[])state.radiusArray.clone();
        }
        if (state.padding != null) {
            this.padding = new Rect(state.padding);
        }
        this.width = state.width;
        this.height = state.height;
        this.ringInnerRadiusRatio = state.ringInnerRadiusRatio;
        this.ringThicknessRatio = state.ringThicknessRatio;
        this.ringInnerRadiusSize = state.ringInnerRadiusSize;
        this.ringThicknessSize = state.ringThicknessSize;
        this.solidCenterX = state.solidCenterX;
        this.solidCenterY = state.solidCenterY;
        this.gradientRadius = state.gradientRadius;
        this.useLevel = state.useLevel;
        this.useLevelForShape = state.useLevelForShape;
        this.opaque = state.opaque;
        this.shadowSize = state.shadowSize;
        this.shadowColor = state.shadowColor;
        this.shadowOffsetX = state.shadowOffsetX;
        this.shadowOffsetY = state.shadowOffsetY;
        this.lineGravity = state.lineGravity;
    }

    public Drawable newDrawable() {
        return new ShapeDrawable(this);
    }

    public Drawable newDrawable(Resources res) {
        return new ShapeDrawable(this);
    }

    public int getChangingConfigurations() {
        return this.changingConfigurations;
    }

    public void setType(int shape) {
        this.shapeType = shape;
        this.computeOpacity();
    }

    public void setSolidGradientType(int gradientType) {
        this.solidGradientType = gradientType;
    }

    public void setSolidColor(int ... colors) {
        if (colors == null) {
            this.solidColor = 0;
            this.hasSolidColor = true;
            this.computeOpacity();
            return;
        }
        if (colors.length == 1) {
            this.hasSolidColor = true;
            this.solidColor = colors[0];
            this.solidColors = null;
        } else {
            this.hasSolidColor = false;
            this.solidColor = 0;
            this.solidColors = colors;
        }
        this.computeOpacity();
    }

    public void setSolidColor(int argb) {
        this.hasSolidColor = true;
        this.solidColor = argb;
        this.solidColors = null;
        this.computeOpacity();
    }

    private void computeOpacity() {
        if (this.shapeType != 0) {
            this.opaque = false;
            return;
        }
        if (this.radius > 0.0f || this.radiusArray != null) {
            this.opaque = false;
            return;
        }
        if (this.shadowSize > 0) {
            this.opaque = false;
            return;
        }
        if (this.strokeSize > 0 && !ShapeState.isOpaque(this.strokeColor)) {
            this.opaque = false;
            return;
        }
        if (this.hasSolidColor) {
            this.opaque = ShapeState.isOpaque(this.solidColor);
            return;
        }
        if (this.solidColors != null) {
            for (int color : this.solidColors) {
                if (ShapeState.isOpaque(color)) continue;
                this.opaque = false;
                return;
            }
        }
        if (this.hasStrokeColor) {
            this.opaque = ShapeState.isOpaque(this.strokeColor);
            return;
        }
        if (this.strokeColors != null) {
            for (int color : this.strokeColors) {
                if (ShapeState.isOpaque(color)) continue;
                this.opaque = false;
                return;
            }
        }
        this.opaque = true;
    }

    private static boolean isOpaque(int color) {
        return (color >> 24 & 0xFF) == 255;
    }

    public void setStrokeSize(int size) {
        this.strokeSize = size;
        this.computeOpacity();
    }

    public void setStrokeColor(int ... colors) {
        if (colors == null) {
            this.strokeColor = 0;
            this.hasStrokeColor = true;
            this.computeOpacity();
            return;
        }
        if (colors.length == 1) {
            this.hasStrokeColor = true;
            this.strokeColor = colors[0];
            this.strokeColors = null;
        } else {
            this.hasStrokeColor = false;
            this.strokeColor = 0;
            this.strokeColors = colors;
        }
        this.computeOpacity();
    }

    public void setCornerRadius(float radius) {
        if (radius < 0.0f) {
            radius = 0.0f;
        }
        this.radius = radius;
        this.radiusArray = null;
    }

    public void setCornerRadii(float[] radii) {
        this.radiusArray = radii;
        if (radii == null) {
            this.radius = 0.0f;
        }
    }
}

