/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.shape.drawable;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.IntRange;
import android.support.annotation.Nullable;

final class ShapeDrawableUtils {
    ShapeDrawableUtils() {
    }

    static void saveCanvasLayer(Canvas canvas, float left, float top, float right, float bottom, @Nullable Paint paint) {
        if (Build.VERSION.SDK_INT >= 21) {
            canvas.saveLayer(left, top, right, bottom, paint);
        } else {
            canvas.saveLayer(left, top, right, bottom, paint, 4);
        }
    }

    static float[] computeLinearGradientCoordinate(RectF r, float level, int orientation) {
        float y1;
        float x1;
        float y0;
        float x0;
        switch (orientation) {
            case 270: {
                x0 = r.left;
                y0 = r.top;
                x1 = x0;
                y1 = level * r.bottom;
                break;
            }
            case 225: {
                x0 = r.right;
                y0 = r.top;
                x1 = level * r.left;
                y1 = level * r.bottom;
                break;
            }
            case 180: {
                x0 = r.right;
                y0 = r.top;
                x1 = level * r.left;
                y1 = y0;
                break;
            }
            case 135: {
                x0 = r.right;
                y0 = r.bottom;
                x1 = level * r.left;
                y1 = level * r.top;
                break;
            }
            case 90: {
                x0 = r.left;
                y0 = r.bottom;
                x1 = x0;
                y1 = level * r.top;
                break;
            }
            case 45: {
                x0 = r.left;
                y0 = r.bottom;
                x1 = level * r.right;
                y1 = level * r.top;
                break;
            }
            case 0: {
                x0 = r.left;
                y0 = r.top;
                x1 = level * r.right;
                y1 = y0;
                break;
            }
            default: {
                x0 = r.left;
                y0 = r.top;
                x1 = level * r.right;
                y1 = level * r.bottom;
            }
        }
        return new float[]{x0, y0, x1, y1};
    }

    @ColorInt
    public static int setColorAlphaComponent(@ColorInt int color, @IntRange(from=0L, to=255L) int alpha) {
        if (alpha < 0 || alpha > 255) {
            throw new IllegalArgumentException("alpha must be between 0 and 255.");
        }
        return color & 0xFFFFFF | alpha << 24;
    }
}

