/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.logcat;

import android.content.Context;
import android.os.Build;
import android.text.SpannableString;
import android.text.style.BackgroundColorSpan;
import android.text.style.ForegroundColorSpan;
import android.util.SparseBooleanArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.hjq.logcat.LogcatInfo;
import com.hjq.logcat.R;
import java.util.ArrayList;
import java.util.List;

final class LogcatAdapter
extends BaseAdapter {
    private static final int MAX_LINE = 4;
    private final SparseBooleanArray mExpandSet = new SparseBooleanArray();
    private final List<LogcatInfo> mDataSet = new ArrayList<LogcatInfo>();
    private String mKeyword = "";

    LogcatAdapter() {
    }

    public int getCount() {
        return this.mDataSet.size();
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        if (convertView == null) {
            convertView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.logcat_item_logcat, parent, false);
            holder = new ViewHolder(convertView);
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        holder.onBindView(this.getItem(position), position);
        return convertView;
    }

    public LogcatInfo getItem(int position) {
        return this.mDataSet.get(position);
    }

    List<LogcatInfo> getData() {
        return this.mDataSet;
    }

    void addItem(LogcatInfo item) {
        this.mDataSet.add(item);
        this.notifyDataSetChanged();
    }

    void removeItem(int position) {
        this.mDataSet.remove(position);
        this.notifyDataSetChanged();
    }

    void clearData() {
        this.mExpandSet.clear();
        this.mDataSet.clear();
        this.notifyDataSetChanged();
    }

    void onItemClick(int position) {
        boolean expand = this.mExpandSet.get(position);
        this.mExpandSet.put(position, !expand);
        this.notifyDataSetChanged();
    }

    void setKeyword(String keyword) {
        this.mKeyword = keyword;
    }

    private class ViewHolder {
        private final TextView mContentView;
        private final TextView mIndexView;
        private final ImageView mExpandView;
        private final View mLineView;

        private ViewHolder(View view) {
            this.mContentView = (TextView)view.findViewById(R.id.tv_log_content);
            this.mIndexView = (TextView)view.findViewById(R.id.tv_log_index);
            this.mExpandView = (ImageView)view.findViewById(R.id.iv_log_expand);
            this.mLineView = view.findViewById(R.id.v_log_line);
        }

        private void onBindView(LogcatInfo info, int position) {
            int resourceId;
            String content;
            String text = content = info.toString();
            if (LogcatAdapter.this.mKeyword != null && LogcatAdapter.this.mKeyword.length() > 0) {
                int index = content.indexOf(LogcatAdapter.this.mKeyword);
                if (index == -1) {
                    index = content.toLowerCase().indexOf(LogcatAdapter.this.mKeyword.toLowerCase());
                }
                String spannable = new SpannableString((CharSequence)content);
                while (index > -1) {
                    int start = index;
                    int end = index + LogcatAdapter.this.mKeyword.length();
                    spannable.setSpan((Object)new BackgroundColorSpan(-1), start, end, 33);
                    spannable.setSpan((Object)new ForegroundColorSpan(-16777216), start, end, 33);
                    index = content.indexOf(LogcatAdapter.this.mKeyword, end);
                    if (index == -1) {
                        index = content.toLowerCase().indexOf(LogcatAdapter.this.mKeyword.toLowerCase(), end);
                    }
                    text = spannable;
                }
            }
            this.mContentView.setText((CharSequence)text);
            switch (info.getLevel()) {
                case "D": {
                    resourceId = R.color.logcat_level_debug_color;
                    break;
                }
                case "I": {
                    resourceId = R.color.logcat_level_info_color;
                    break;
                }
                case "W": {
                    resourceId = R.color.logcat_level_warn_color;
                    break;
                }
                case "E": {
                    resourceId = R.color.logcat_level_error_color;
                    break;
                }
                case "V": {
                    resourceId = R.color.logcat_level_verbose_color;
                    break;
                }
                default: {
                    resourceId = R.color.logcat_level_other_color;
                }
            }
            int textColor = Build.VERSION.SDK_INT >= 23 ? this.mContentView.getResources().getColor(resourceId, this.mContentView.getContext().getTheme()) : this.mContentView.getResources().getColor(resourceId);
            this.mContentView.setTextColor(textColor);
            this.mLineView.setVisibility(position == LogcatAdapter.this.getCount() - 1 ? 8 : 0);
            if (this.mContentView.getLineCount() - 4 > 1) {
                if (LogcatAdapter.this.mExpandSet.get(position)) {
                    if (this.mContentView.getMaxLines() != Integer.MAX_VALUE) {
                        this.mContentView.setMaxLines(Integer.MAX_VALUE);
                        this.mExpandView.setImageResource(R.drawable.logcat_ic_arrows_up);
                    }
                } else if (this.mContentView.getMaxLines() != 4) {
                    this.mContentView.setMaxLines(4);
                    this.mExpandView.setImageResource(R.drawable.logcat_ic_arrows_down);
                }
                this.mExpandView.setVisibility(0);
                this.mIndexView.setVisibility(8);
            } else {
                this.mContentView.setMaxLines(Integer.MAX_VALUE);
                this.mIndexView.setText((CharSequence)String.valueOf(position + 1));
                this.mExpandView.setVisibility(8);
                this.mIndexView.setVisibility(0);
            }
        }
    }
}

