/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.logcat;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.BackgroundColorSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.URLSpan;
import android.text.style.UnderlineSpan;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.hjq.logcat.LogcatInfo;
import com.hjq.logcat.LogcatUtils;
import com.hjq.logcat.R;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@SuppressLint(value={"NotifyDataSetChanged"})
final class LogcatAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private static final int LOG_MAX_COUNT = 1000;
    private static final int LOG_REMOVE_COUNT = 333;
    private static final Pattern CODE_LINES_REGEX = Pattern.compile("\\(\\w+\\.\\w+:\\d+\\)");
    private static final Pattern LINK_REGEX = Pattern.compile("https?://[^\\x{4e00}-\\x{9fa5}\\n\\r\\s]{3,}");
    private final SparseBooleanArray mExpandSet = new SparseBooleanArray();
    private final SparseIntArray mScrollXSet = new SparseIntArray();
    private final List<LogcatInfo> mAllData = new CopyOnWriteArrayList<LogcatInfo>();
    private List<LogcatInfo> mShowData = this.mAllData;
    private final Context mContext;
    private String mKeyword = "";
    private String mLogLevel = "V";
    private RecyclerView mRecyclerView;
    @Nullable
    private OnItemClickListener mItemClickListener;
    @Nullable
    private OnItemLongClickListener mItemLongClickListener;

    public LogcatAdapter(Context context) {
        this.mContext = context;
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.logcat_item_logcat, parent, false));
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        holder.onBindView(this.getItem(position), position);
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemCount() {
        return this.mShowData.size();
    }

    public LogcatInfo getItem(int position) {
        return this.mShowData.get(position);
    }

    List<LogcatInfo> getShowData() {
        return this.mShowData;
    }

    void addItem(LogcatInfo info) {
        if (!this.mShowData.isEmpty()) {
            LogcatInfo lastInfo = this.getItem(this.mShowData.size() - 1);
            if (info.getLevel().equals(lastInfo.getLevel()) && info.getTag().equals(lastInfo.getTag())) {
                lastInfo.addLogContent(info.getContent());
                if (Looper.myLooper() == Looper.getMainLooper()) {
                    this.notifyItemChanged(this.mShowData.size() - 1);
                }
                return;
            }
        }
        if (this.isConform(info)) {
            this.mShowData.add(info);
            if (this.mShowData.size() > 1000) {
                this.mShowData.removeAll(this.mShowData.subList(0, 333));
                if (Looper.myLooper() == Looper.getMainLooper()) {
                    this.notifyDataSetChanged();
                }
                if (this.mRecyclerView != null) {
                    this.mRecyclerView.scrollToPosition(this.getItemCount() - 1);
                }
            } else if (Looper.myLooper() == Looper.getMainLooper()) {
                this.notifyItemInserted(this.mShowData.size() - 1);
            }
        }
        if (this.mShowData != this.mAllData) {
            this.mAllData.add(info);
            if (this.mAllData.size() > 1000) {
                this.mAllData.removeAll(this.mAllData.subList(0, 333));
            }
        }
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        this.mRecyclerView = recyclerView;
    }

    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        super.onDetachedFromRecyclerView(recyclerView);
        this.mRecyclerView = null;
    }

    void removeItem(int position) {
        LogcatInfo info = this.mShowData.remove(position);
        if (this.mAllData != this.mShowData && info != null) {
            this.mAllData.remove(info);
        }
        this.notifyItemRemoved(position);
    }

    void clearData() {
        this.mExpandSet.clear();
        this.mScrollXSet.clear();
        this.mAllData.clear();
        if (this.mAllData != this.mShowData) {
            this.mShowData.clear();
        }
        this.notifyDataSetChanged();
    }

    void setKeyword(String keyword) {
        this.mKeyword = keyword;
        this.filterData();
        this.notifyDataSetChanged();
    }

    void setLogLevel(String logLevel) {
        this.mLogLevel = logLevel;
        this.filterData();
        this.notifyDataSetChanged();
    }

    void onItemClick(int position) {
        LogcatInfo info = this.getItem(position);
        boolean expand = this.mExpandSet.get(info.hashCode());
        this.mExpandSet.put(info.hashCode(), !expand);
        this.notifyItemChanged(position);
    }

    private void filterData() {
        if (TextUtils.isEmpty((CharSequence)this.mKeyword) && "V".equals(this.mLogLevel)) {
            this.mShowData = this.mAllData;
            return;
        }
        if (this.mShowData == this.mAllData) {
            this.mShowData = new ArrayList<LogcatInfo>();
        }
        this.mShowData.clear();
        for (LogcatInfo info : this.mAllData) {
            if (!this.isConform(info)) continue;
            this.mShowData.add(info);
        }
    }

    private boolean isConform(LogcatInfo info) {
        return !(!TextUtils.isEmpty((CharSequence)this.mKeyword) && !info.toString(this.mContext).toLowerCase().contains(this.mKeyword.toLowerCase()) || !"V".equals(this.mLogLevel) && !info.getLevel().equals(this.mLogLevel));
    }

    void setOnItemClickListener(@Nullable OnItemClickListener listener) {
        this.mItemClickListener = listener;
    }

    void setOnItemLongClickListener(@Nullable OnItemLongClickListener listener) {
        this.mItemLongClickListener = listener;
    }

    public static interface OnItemLongClickListener {
        public boolean onItemLongClick(LogcatInfo var1, int var2);
    }

    public static interface OnItemClickListener {
        public void onItemClick(LogcatInfo var1, int var2);
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener,
    View.OnLongClickListener {
        private final TextView mContentView;
        private final TextView mIndexView;
        private final View mLineView;

        @SuppressLint(value={"ClickableViewAccessibility"})
        public ViewHolder(View itemView) {
            super(itemView);
            this.mContentView = (TextView)itemView.findViewById(R.id.tv_log_content);
            this.mIndexView = (TextView)itemView.findViewById(R.id.tv_log_index);
            this.mLineView = itemView.findViewById(R.id.v_log_line);
            itemView.setOnClickListener((View.OnClickListener)this);
            itemView.setOnLongClickListener((View.OnLongClickListener)this);
        }

        public void onClick(View v) {
            if (LogcatAdapter.this.mItemClickListener == null) {
                return;
            }
            int layoutPosition = this.getLayoutPosition();
            LogcatAdapter.this.mItemClickListener.onItemClick(LogcatAdapter.this.getItem(layoutPosition), layoutPosition);
        }

        public boolean onLongClick(View v) {
            if (LogcatAdapter.this.mItemLongClickListener == null) {
                return false;
            }
            int layoutPosition = this.getLayoutPosition();
            return LogcatAdapter.this.mItemLongClickListener.onItemLongClick(LogcatAdapter.this.getItem(layoutPosition), layoutPosition);
        }

        private void onBindView(LogcatInfo info, int position) {
            int resourceId;
            int end;
            int start;
            String content = info.toString(LogcatAdapter.this.mContext);
            SpannableString spannable = new SpannableString((CharSequence)content);
            if (LogcatAdapter.this.mKeyword != null && LogcatAdapter.this.mKeyword.length() > 0) {
                int index = content.indexOf(LogcatAdapter.this.mKeyword);
                if (index == -1) {
                    index = content.toLowerCase().indexOf(LogcatAdapter.this.mKeyword.toLowerCase());
                }
                while (index > -1) {
                    start = index;
                    end = index + LogcatAdapter.this.mKeyword.length();
                    spannable.setSpan((Object)new BackgroundColorSpan(ContextCompat.getColor((Context)LogcatAdapter.this.mContext, (int)R.color.logcat_filter_background_color)), start, end, 33);
                    spannable.setSpan((Object)new ForegroundColorSpan(ContextCompat.getColor((Context)LogcatAdapter.this.mContext, (int)R.color.logcat_filter_foreground_color)), start, end, 33);
                    index = content.indexOf(LogcatAdapter.this.mKeyword, end);
                    if (index != -1) continue;
                    index = content.toLowerCase().indexOf(LogcatAdapter.this.mKeyword.toLowerCase(), end);
                }
            } else {
                Matcher matcher = CODE_LINES_REGEX.matcher(content);
                if (spannable.length() > 0) {
                    while (matcher.find()) {
                        start = matcher.start() + "(".length();
                        end = matcher.end() - ")".length();
                        spannable.setSpan((Object)new ForegroundColorSpan(ContextCompat.getColor((Context)LogcatAdapter.this.mContext, (int)R.color.logcat_code_lines_highlight_color)), start, end, 33);
                        spannable.setSpan((Object)new UnderlineSpan(), start, end, 33);
                    }
                }
            }
            Matcher matcher = LINK_REGEX.matcher(content);
            while (matcher.find()) {
                start = matcher.start();
                end = matcher.end();
                URLSpan urlSpan = new URLSpan(String.valueOf(spannable.subSequence(start, end)));
                spannable.setSpan((Object)urlSpan, start, end, 17);
            }
            this.mContentView.setText((CharSequence)spannable);
            switch (info.getLevel()) {
                case "D": {
                    resourceId = R.color.logcat_level_debug_color;
                    break;
                }
                case "I": {
                    resourceId = R.color.logcat_level_info_color;
                    break;
                }
                case "W": {
                    resourceId = R.color.logcat_level_warn_color;
                    break;
                }
                case "E": {
                    resourceId = R.color.logcat_level_error_color;
                    break;
                }
                case "V": {
                    resourceId = R.color.logcat_level_verbose_color;
                    break;
                }
                default: {
                    resourceId = R.color.logcat_level_other_color;
                }
            }
            int textColor = Build.VERSION.SDK_INT >= 23 ? this.mContentView.getResources().getColor(resourceId, this.mContentView.getContext().getTheme()) : this.mContentView.getResources().getColor(resourceId);
            this.mContentView.setTextColor(textColor);
            this.mLineView.setVisibility(position == 0 ? 4 : 0);
            int maxLine = LogcatUtils.isPortrait(this.itemView.getContext()) ? 6 : 4;
            if (content.split("\n").length - maxLine > 1) {
                if (LogcatAdapter.this.mExpandSet.get(info.hashCode())) {
                    if (this.mContentView.getMaxLines() != Integer.MAX_VALUE) {
                        this.mContentView.setMaxLines(Integer.MAX_VALUE);
                    }
                    this.mIndexView.setText((CharSequence)String.valueOf(position + 1));
                } else {
                    if (this.mContentView.getMaxLines() != maxLine) {
                        this.mContentView.setMaxLines(maxLine);
                    }
                    this.mIndexView.setText((CharSequence)"V");
                }
            } else {
                this.mContentView.setMaxLines(Integer.MAX_VALUE);
                this.mIndexView.setText((CharSequence)String.valueOf(position + 1));
            }
        }
    }
}

