/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.logcat;

import android.content.Context;
import com.hjq.logcat.LogcatUtils;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class LogcatInfo {
    static final String SPACE = "  ";
    static final String LINE_SPACE = "\n  ";
    private static final Pattern PATTERN = Pattern.compile("([0-9^-]+-[0-9^ ]+\\s[0-9^:]+:[0-9^:]+\\.[0-9]+)\\s+([0-9]+)\\s+([0-9]+)\\s([VDIWEF])\\s([^:&&\\s]*):\\s(.*)");
    static final ArrayList<String> IGNORED_LOG = new ArrayList<String>(){
        {
            this.add("--------- beginning of crash");
            this.add("--------- beginning of main");
            this.add("--------- beginning of system");
        }
    };
    private String time;
    private String tid;
    private String pid;
    private String level;
    private String tag;
    private String content;

    static LogcatInfo create(String line) {
        Matcher matcher = PATTERN.matcher(line);
        if (!matcher.find()) {
            return null;
        }
        LogcatInfo info = new LogcatInfo();
        info.time = matcher.group(1);
        info.pid = matcher.group(2);
        info.tid = matcher.group(3);
        info.level = matcher.group(4);
        info.tag = matcher.group(5);
        info.content = matcher.group(6);
        return info;
    }

    private LogcatInfo() {
    }

    String getTime() {
        return this.time;
    }

    String getPid() {
        return this.pid;
    }

    String getTid() {
        return this.tid;
    }

    String getLevel() {
        return this.level;
    }

    String getTag() {
        return this.tag;
    }

    String getContent() {
        return this.content;
    }

    void addLogContent(String text) {
        this.content = (this.content.startsWith(LINE_SPACE) ? "" : LINE_SPACE) + this.content + LINE_SPACE + text;
    }

    public String toString() {
        return String.format("%s  %s  %s", this.time, this.tag, this.content);
    }

    public String toString(Context context) {
        if (!LogcatUtils.isPortrait(context)) {
            return this.toString();
        }
        String log = this.getContent();
        return String.format("%s  %s" + (log.startsWith("\n") ? SPACE : "\n") + "%s", this.getTime(), this.getTag(), log);
    }
}

