/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.logcat;

import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import com.hjq.logcat.ChooseWindow;
import com.hjq.logcat.LogcatAdapter;
import com.hjq.logcat.LogcatConfig;
import com.hjq.logcat.LogcatInfo;
import com.hjq.logcat.LogcatManager;
import com.hjq.logcat.LogcatUtils;
import com.hjq.logcat.R;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class LogcatActivity
extends AppCompatActivity
implements TextWatcher,
View.OnLongClickListener,
View.OnClickListener,
CompoundButton.OnCheckedChangeListener,
LogcatManager.Callback,
LogcatAdapter.OnItemLongClickListener,
LogcatAdapter.OnItemClickListener {
    private static final String[] ARRAY_LOG_LEVEL = new String[]{"Verbose", "Debug", "Info", "Warn", "Error"};
    private static final String[] ARRAY_LOG_LEVEL_PORTRAIT = new String[]{"V", "D", "I", "W", "E"};
    private View mRootView;
    private View mBarView;
    private CheckBox mCheckBox;
    private View mSaveView;
    private ViewGroup mLevelLayout;
    private TextView mLevelView;
    private EditText mInputView;
    private ImageView mIconView;
    private View mClearView;
    private View mHideView;
    private RecyclerView mRecyclerView;
    private View mDownView;
    private LinearLayoutManager mLinearLayoutManager;
    private LogcatAdapter mAdapter;
    private String mLogLevel = "V";
    private boolean mPauseLogFlag;
    private final List<String> mTagFilter = new ArrayList<String>();
    private final List<String> mSearchKeyword = new ArrayList<String>();
    private final Runnable mSearchRunnable = new Runnable(){

        @Override
        public void run() {
            String keyword = LogcatActivity.this.mInputView.getText().toString();
            LogcatConfig.setLogcatText(keyword);
            LogcatActivity.this.mAdapter.setKeyword(keyword);
            LogcatActivity.this.mLinearLayoutManager.scrollToPosition(LogcatActivity.this.mAdapter.getItemCount() - 1);
            if (!"".equals(keyword)) {
                LogcatActivity.this.mIconView.setVisibility(0);
                LogcatActivity.this.mIconView.setImageResource(R.drawable.logcat_ic_empty);
            } else if (!LogcatActivity.this.mSearchKeyword.isEmpty()) {
                LogcatActivity.this.mIconView.setVisibility(0);
                LogcatActivity.this.mIconView.setImageResource(R.drawable.logcat_ic_history);
            } else {
                LogcatActivity.this.mIconView.setVisibility(8);
            }
        }
    };
    private final Runnable mSearchKeywordRunnable = new Runnable(){

        @Override
        public void run() {
            String keyword = LogcatActivity.this.mInputView.getText().toString();
            if ("".equals(keyword)) {
                return;
            }
            if (LogcatActivity.this.mSearchKeyword.contains(keyword)) {
                return;
            }
            LogcatActivity.this.mSearchKeyword.add(0, keyword);
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.logcat_activity_logcat);
        this.mRootView = this.findViewById(R.id.ll_log_root);
        this.mBarView = this.findViewById(R.id.ll_log_bar);
        this.mCheckBox = (CheckBox)this.findViewById(R.id.cb_log_switch);
        this.mSaveView = this.findViewById(R.id.iv_log_save);
        this.mLevelLayout = (ViewGroup)this.findViewById(R.id.ll_log_level);
        this.mLevelView = (TextView)this.findViewById(R.id.tv_log_level);
        this.mInputView = (EditText)this.findViewById(R.id.et_log_search_input);
        this.mIconView = (ImageView)this.findViewById(R.id.iv_log_search_icon);
        this.mClearView = this.findViewById(R.id.iv_log_logcat_clear);
        this.mHideView = this.findViewById(R.id.iv_log_logcat_hide);
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.lv_log_logcat_list);
        this.mDownView = this.findViewById(R.id.ib_log_logcat_down);
        this.mAdapter = new LogcatAdapter((Context)this);
        this.mAdapter.setOnItemClickListener(this);
        this.mAdapter.setOnItemLongClickListener(this);
        this.mRecyclerView.setAnimation(null);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mLinearLayoutManager = new LinearLayoutManager((Context)this);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)this.mLinearLayoutManager);
        this.mCheckBox.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
        this.mInputView.addTextChangedListener((TextWatcher)this);
        this.mInputView.setText((CharSequence)LogcatConfig.getLogcatText());
        this.setLogLevel(LogcatConfig.getLogcatLevel());
        this.mSaveView.setOnClickListener((View.OnClickListener)this);
        this.mLevelLayout.setOnClickListener((View.OnClickListener)this);
        this.mIconView.setOnClickListener((View.OnClickListener)this);
        this.mClearView.setOnClickListener((View.OnClickListener)this);
        this.mHideView.setOnClickListener((View.OnClickListener)this);
        this.mDownView.setOnClickListener((View.OnClickListener)this);
        this.mSaveView.setOnLongClickListener((View.OnLongClickListener)this);
        this.mCheckBox.setOnLongClickListener((View.OnLongClickListener)this);
        this.mLevelLayout.setOnLongClickListener((View.OnLongClickListener)this);
        this.mClearView.setOnLongClickListener((View.OnLongClickListener)this);
        this.mHideView.setOnLongClickListener((View.OnLongClickListener)this);
        LogcatManager.start(this);
        this.mRecyclerView.postDelayed(new Runnable(){

            @Override
            public void run() {
                LogcatActivity.this.mLinearLayoutManager.scrollToPosition(LogcatActivity.this.mAdapter.getItemCount() - 1);
            }
        }, 500L);
        this.initFilter();
        this.refreshLayout();
    }

    @Override
    public void onReceiveLog(LogcatInfo info) {
        if (this.mTagFilter.contains(info.getTag())) {
            return;
        }
        this.mRecyclerView.post((Runnable)new LogRunnable(info));
    }

    public boolean onLongClick(View v) {
        if (v == this.mCheckBox) {
            LogcatUtils.toast((Activity)this, R.string.logcat_capture);
        } else if (v == this.mSaveView) {
            LogcatUtils.toast((Activity)this, R.string.logcat_save);
        } else if (v == this.mLevelView) {
            LogcatUtils.toast((Activity)this, R.string.logcat_level);
        } else if (v == this.mClearView) {
            LogcatUtils.toast((Activity)this, R.string.logcat_empty);
        } else if (v == this.mHideView) {
            LogcatUtils.toast((Activity)this, R.string.logcat_close);
        }
        return true;
    }

    public void onClick(View v) {
        if (v == this.mSaveView) {
            try {
                File file = LogcatUtils.saveLogToFile((Context)this, this.mAdapter.getData());
                LogcatUtils.toast((Activity)this, this.getResources().getString(R.string.logcat_save_succeed) + file.getPath());
            }
            catch (IOException e) {
                e.printStackTrace();
                LogcatUtils.toast((Activity)this, this.getResources().getString(R.string.logcat_save_fail));
            }
        } else if (v == this.mLevelLayout) {
            new ChooseWindow((Activity)this).setList(ARRAY_LOG_LEVEL).setListener(new ChooseWindow.OnListener(){

                @Override
                public void onSelected(int position) {
                    switch (position) {
                        case 0: {
                            LogcatActivity.this.setLogLevel("V");
                            break;
                        }
                        case 1: {
                            LogcatActivity.this.setLogLevel("D");
                            break;
                        }
                        case 2: {
                            LogcatActivity.this.setLogLevel("I");
                            break;
                        }
                        case 3: {
                            LogcatActivity.this.setLogLevel("W");
                            break;
                        }
                        case 4: {
                            LogcatActivity.this.setLogLevel("E");
                            break;
                        }
                    }
                }
            }).show();
        } else if (v == this.mIconView) {
            String keyword = this.mInputView.getText().toString();
            if ("".equals(keyword)) {
                this.showSearchKeyword();
            } else {
                this.mInputView.setText((CharSequence)"");
            }
        } else if (v == this.mClearView) {
            LogcatManager.clear();
            this.mAdapter.clearData();
        } else if (v == this.mHideView) {
            this.onBackPressed();
        } else if (v == this.mDownView) {
            this.mLinearLayoutManager.scrollToPosition(this.mAdapter.getItemCount() - 1);
        }
    }

    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        if (isChecked) {
            LogcatUtils.toast((Activity)this, R.string.logcat_capture_pause);
            LogcatManager.pause();
            this.mPauseLogFlag = true;
        } else {
            LogcatManager.resume();
            this.mPauseLogFlag = false;
        }
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    public void afterTextChanged(Editable s) {
        this.mInputView.removeCallbacks(this.mSearchRunnable);
        this.mInputView.postDelayed(this.mSearchRunnable, 500L);
        this.mInputView.removeCallbacks(this.mSearchKeywordRunnable);
        this.mInputView.postDelayed(this.mSearchKeywordRunnable, 3000L);
    }

    @Override
    public void onItemClick(LogcatInfo info, int position) {
        this.mAdapter.onItemClick(position);
    }

    @Override
    public void onItemLongClick(LogcatInfo info, final int position) {
        new ChooseWindow((Activity)this).setList(R.string.logcat_options_copy, R.string.logcat_options_share, R.string.logcat_options_delete, R.string.logcat_options_shield).setListener(new ChooseWindow.OnListener(){

            @Override
            public void onSelected(int location) {
                switch (location) {
                    case 0: {
                        LogcatActivity.this.copyLog(position);
                        break;
                    }
                    case 1: {
                        LogcatActivity.this.shareLog(position);
                        break;
                    }
                    case 2: {
                        LogcatActivity.this.mAdapter.removeItem(position);
                        break;
                    }
                    case 3: {
                        LogcatActivity.this.addFilter(LogcatActivity.this.mAdapter.getItem(position).getTag());
                        break;
                    }
                }
            }
        }).show();
    }

    private void copyLog(int position) {
        ClipboardManager manager = (ClipboardManager)this.getSystemService("clipboard");
        if (manager != null) {
            manager.setPrimaryClip(ClipData.newPlainText((CharSequence)"log", (CharSequence)this.mAdapter.getItem(position).getContent()));
            LogcatUtils.toast((Activity)this, R.string.logcat_copy_succeed);
        } else {
            LogcatUtils.toast((Activity)this, R.string.logcat_copy_fail);
        }
    }

    private void shareLog(int position) {
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("text/plain");
        intent.putExtra("android.intent.extra.TEXT", this.mAdapter.getItem(position).getContent());
        this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)this.getResources().getString(R.string.logcat_options_share)));
    }

    private void setLogLevel(String level) {
        if (level.equals(this.mLogLevel)) {
            this.refreshLogLevelLayout();
            return;
        }
        this.mLogLevel = level;
        this.mAdapter.setLogLevel(level);
        LogcatConfig.setLogcatLevel(level);
        this.afterTextChanged(this.mInputView.getText());
        this.refreshLogLevelLayout();
    }

    private void refreshLogLevelLayout() {
        String[] arrayLogLevel = LogcatUtils.isPortrait((Context)this) ? ARRAY_LOG_LEVEL_PORTRAIT : ARRAY_LOG_LEVEL;
        switch (this.mLogLevel) {
            case "V": {
                this.mLevelView.setText((CharSequence)arrayLogLevel[0]);
                break;
            }
            case "D": {
                this.mLevelView.setText((CharSequence)arrayLogLevel[1]);
                break;
            }
            case "I": {
                this.mLevelView.setText((CharSequence)arrayLogLevel[2]);
                break;
            }
            case "W": {
                this.mLevelView.setText((CharSequence)arrayLogLevel[3]);
                break;
            }
            case "E": {
                this.mLevelView.setText((CharSequence)arrayLogLevel[4]);
                break;
            }
        }
    }

    private void initFilter() {
        String[] list;
        try {
            this.mTagFilter.addAll(LogcatUtils.readTagFilter((Context)this));
        }
        catch (IOException e) {
            e.printStackTrace();
            LogcatUtils.toast((Activity)this, R.string.logcat_read_config_fail);
        }
        for (String tag : list = this.getResources().getStringArray(R.array.logcat_filter_list)) {
            if (tag == null || "".equals(tag) || this.mTagFilter.contains(tag)) continue;
            this.mTagFilter.add(tag);
        }
    }

    private void addFilter(String tag) {
        if ("".equals(tag)) {
            return;
        }
        if (this.mTagFilter.contains(tag)) {
            return;
        }
        this.mTagFilter.add(tag);
        try {
            ArrayList<String> newTagFilter = new ArrayList<String>(this.mTagFilter);
            newTagFilter.removeAll(Arrays.asList(this.getResources().getStringArray(R.array.logcat_filter_list)));
            File file = LogcatUtils.writeTagFilter((Context)this, newTagFilter);
            LogcatUtils.toast((Activity)this, this.getResources().getString(R.string.logcat_shield_succeed) + file.getPath());
            List<LogcatInfo> data = this.mAdapter.getData();
            for (int i = 0; i < data.size(); ++i) {
                LogcatInfo info = data.get(i);
                if (!info.getTag().equals(tag)) continue;
                this.mAdapter.removeItem(i);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            LogcatUtils.toast((Activity)this, R.string.logcat_shield_fail);
        }
    }

    public void onBackPressed() {
        this.mInputView.clearFocus();
        this.moveTaskToBack(false);
    }

    protected void onResume() {
        super.onResume();
        if (this.mPauseLogFlag) {
            return;
        }
        LogcatManager.resume();
    }

    protected void onPause() {
        super.onPause();
        if (this.mPauseLogFlag) {
            return;
        }
        LogcatManager.pause();
    }

    protected void onDestroy() {
        super.onDestroy();
        LogcatManager.destroy();
        this.mInputView.removeCallbacks(this.mSearchRunnable);
        this.mInputView.removeCallbacks(this.mSearchKeywordRunnable);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.refreshLogLevelLayout();
        if (this.mAdapter == null) {
            return;
        }
        this.mAdapter.notifyDataSetChanged();
    }

    private void showSearchKeyword() {
        if (this.mSearchKeyword.isEmpty()) {
            return;
        }
        new ChooseWindow((Activity)this).setList(this.mSearchKeyword).setListener(new ChooseWindow.OnListener(){

            @Override
            public void onSelected(int position) {
                LogcatActivity.this.mInputView.setText((CharSequence)LogcatActivity.this.mSearchKeyword.get(position));
                LogcatActivity.this.mInputView.setSelection(LogcatActivity.this.mInputView.getText().toString().length());
            }
        }).show();
    }

    private void refreshLayout() {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        Window window = this.getWindow();
        if (window != null) {
            window.addFlags(0x4000000);
        }
        this.mBarView.setPadding(0, 0, 0, 0);
        this.mRootView.setPadding(0, 0, 0, 0);
        if (LogcatUtils.isPortrait((Context)this)) {
            if (window != null) {
                window.clearFlags(1024);
                if (Build.VERSION.SDK_INT >= 23) {
                    window.getDecorView().setSystemUiVisibility(0);
                }
            }
            if (Build.VERSION.SDK_INT >= 28 && window != null) {
                WindowManager.LayoutParams params = window.getAttributes();
                params.layoutInDisplayCutoutMode = 1;
                window.setAttributes(params);
            }
            this.mBarView.setPadding(0, LogcatUtils.getStatusBarHeight((Context)this), 0, 0);
        } else {
            if (window != null) {
                window.addFlags(1024);
            }
            this.mBarView.setPadding((int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()), 0, (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()), 0);
            if (Build.VERSION.SDK_INT >= 28) {
                if (window != null) {
                    WindowManager.LayoutParams params = window.getAttributes();
                    params.layoutInDisplayCutoutMode = 2;
                    window.setAttributes(params);
                }
            } else if (LogcatUtils.isActivityReverse((Activity)this)) {
                this.mRootView.setPadding(0, 0, LogcatUtils.getStatusBarHeight((Context)this), 0);
            } else {
                this.mRootView.setPadding(LogcatUtils.getStatusBarHeight((Context)this), 0, 0, 0);
            }
        }
    }

    private class LogRunnable
    implements Runnable {
        private final LogcatInfo info;

        private LogRunnable(LogcatInfo info) {
            this.info = info;
        }

        @Override
        public void run() {
            LogcatActivity.this.mAdapter.addItem(this.info);
        }
    }
}

