/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.logcat;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.BackgroundColorSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.UnderlineSpan;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.HorizontalScrollView;
import android.widget.TextView;
import com.hjq.logcat.LogcatInfo;
import com.hjq.logcat.LogcatUtils;
import com.hjq.logcat.R;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@SuppressLint(value={"NotifyDataSetChanged"})
final class LogcatAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private static final int LOG_MAX_COUNT = 1000;
    private static final int LOG_REMOVE_COUNT = 200;
    private static final Pattern CODE_REGEX = Pattern.compile("\\(\\w+\\.\\w+:\\d+\\)");
    private final SparseBooleanArray mExpandSet = new SparseBooleanArray();
    private final SparseIntArray mScrollXSet = new SparseIntArray();
    private final List<LogcatInfo> mAllData = new ArrayList<LogcatInfo>();
    private List<LogcatInfo> mShowData = this.mAllData;
    private String mKeyword = "";
    private String mLogLevel = "V";
    @Nullable
    private OnItemClickListener mItemClickListener;
    @Nullable
    private OnItemLongClickListener mItemLongClickListener;

    LogcatAdapter() {
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.logcat_item_logcat, parent, false));
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        holder.onBindView(this.getItem(position), position);
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemCount() {
        return this.mShowData.size();
    }

    public LogcatInfo getItem(int position) {
        return this.mShowData.get(position);
    }

    List<LogcatInfo> getData() {
        return this.mShowData;
    }

    void addItem(LogcatInfo info) {
        if (!this.mShowData.isEmpty()) {
            LogcatInfo lastInfo = this.getItem(this.mShowData.size() - 1);
            if (info.getLevel().equals(lastInfo.getLevel()) && info.getTag().equals(lastInfo.getTag())) {
                lastInfo.addLog(info.getLog());
                this.notifyItemChanged(this.mShowData.size() - 1);
                return;
            }
        }
        if (this.isConform(info)) {
            this.mShowData.add(info);
            if (this.mShowData.size() > 1000) {
                this.mShowData.removeAll(this.mShowData.subList(0, 200));
                this.notifyDataSetChanged();
            } else {
                this.notifyItemInserted(this.mShowData.size() - 1);
            }
        }
        if (this.mShowData != this.mAllData) {
            this.mAllData.add(info);
            if (this.mAllData.size() > 1000) {
                this.mAllData.removeAll(this.mAllData.subList(0, 200));
            }
        }
    }

    void removeItem(int position) {
        LogcatInfo info = this.mShowData.remove(position);
        if (this.mAllData != this.mShowData && info != null) {
            this.mAllData.remove(info);
        }
        this.notifyItemRemoved(position);
    }

    void clearData() {
        this.mExpandSet.clear();
        this.mScrollXSet.clear();
        this.mAllData.clear();
        if (this.mAllData != this.mShowData) {
            this.mShowData.clear();
        }
        this.notifyDataSetChanged();
    }

    void setKeyword(String keyword) {
        this.mKeyword = keyword;
        this.filterData();
        this.notifyDataSetChanged();
    }

    void setLogLevel(String logLevel) {
        this.mLogLevel = logLevel;
        this.filterData();
        this.notifyDataSetChanged();
    }

    void onItemClick(int position) {
        LogcatInfo info = this.getItem(position);
        boolean expand = this.mExpandSet.get(info.hashCode());
        this.mExpandSet.put(info.hashCode(), !expand);
        this.notifyItemChanged(position);
    }

    private void filterData() {
        if (TextUtils.isEmpty((CharSequence)this.mKeyword) && "V".equals(this.mLogLevel)) {
            this.mShowData = this.mAllData;
            return;
        }
        if (this.mShowData == this.mAllData) {
            this.mShowData = new ArrayList<LogcatInfo>();
        }
        this.mShowData.clear();
        for (LogcatInfo info : this.mAllData) {
            if (!this.isConform(info)) continue;
            this.mShowData.add(info);
        }
    }

    private boolean isConform(LogcatInfo info) {
        return !(!TextUtils.isEmpty((CharSequence)this.mKeyword) && !info.getLog().contains(this.mKeyword) || !"V".equals(this.mLogLevel) && !info.getLevel().equals(this.mLogLevel));
    }

    void setOnItemClickListener(@Nullable OnItemClickListener listener) {
        this.mItemClickListener = listener;
    }

    void setOnItemLongClickListener(@Nullable OnItemLongClickListener listener) {
        this.mItemLongClickListener = listener;
    }

    public void onViewDetachedFromWindow(ViewHolder holder) {
        super.onViewDetachedFromWindow((RecyclerView.ViewHolder)holder);
        holder.onDetached();
    }

    public void onViewRecycled(@NonNull ViewHolder holder) {
        super.onViewRecycled((RecyclerView.ViewHolder)holder);
        holder.onRecycled();
    }

    public static interface OnItemLongClickListener {
        public void onItemLongClick(LogcatInfo var1, int var2);
    }

    public static interface OnItemClickListener {
        public void onItemClick(LogcatInfo var1, int var2);
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnTouchListener,
    View.OnClickListener,
    View.OnLongClickListener {
        private final HorizontalScrollView mHorizontalScrollView;
        private final TextView mContentView;
        private final TextView mIndexView;
        private final View mLineView;
        private final Runnable mScrollRunnable;

        @SuppressLint(value={"ClickableViewAccessibility"})
        public ViewHolder(View itemView) {
            super(itemView);
            this.mScrollRunnable = new Runnable(){

                @Override
                public void run() {
                    int layoutPosition = ViewHolder.this.getLayoutPosition();
                    if (layoutPosition < 0) {
                        return;
                    }
                    if (layoutPosition >= LogcatAdapter.this.getItemCount()) {
                        return;
                    }
                    LogcatInfo info = LogcatAdapter.this.getItem(layoutPosition);
                    int scrollX = LogcatAdapter.this.mScrollXSet.get(info.hashCode());
                    if (ViewHolder.this.mHorizontalScrollView.getScrollX() == scrollX) {
                        return;
                    }
                    ViewHolder.this.mHorizontalScrollView.scrollTo(scrollX, 0);
                }
            };
            this.mHorizontalScrollView = (HorizontalScrollView)itemView.findViewById(R.id.hcv_log_content);
            this.mContentView = (TextView)itemView.findViewById(R.id.tv_log_content);
            this.mIndexView = (TextView)itemView.findViewById(R.id.tv_log_index);
            this.mLineView = itemView.findViewById(R.id.v_log_line);
            itemView.setOnClickListener((View.OnClickListener)this);
            itemView.setOnLongClickListener((View.OnLongClickListener)this);
            this.mHorizontalScrollView.setOnTouchListener((View.OnTouchListener)this);
        }

        public void onClick(View v) {
            if (LogcatAdapter.this.mItemClickListener != null) {
                LogcatAdapter.this.mItemClickListener.onItemClick(LogcatAdapter.this.getItem(this.getLayoutPosition()), this.getLayoutPosition());
            }
        }

        public boolean onLongClick(View v) {
            if (LogcatAdapter.this.mItemLongClickListener != null) {
                LogcatAdapter.this.mItemLongClickListener.onItemLongClick(LogcatAdapter.this.getItem(this.getLayoutPosition()), this.getLayoutPosition());
            }
            return false;
        }

        @SuppressLint(value={"ClickableViewAccessibility"})
        public boolean onTouch(View v, MotionEvent event) {
            switch (event.getAction()) {
                case 2: {
                    event.setAction(3);
                    this.itemView.onTouchEvent(event);
                    event.setAction(2);
                    break;
                }
                case 1: 
                case 3: {
                    LogcatInfo info = LogcatAdapter.this.getItem(this.getLayoutPosition());
                    int scrollX = this.mHorizontalScrollView.getScrollX();
                    LogcatAdapter.this.mScrollXSet.put(info.hashCode(), scrollX);
                }
                default: {
                    this.itemView.onTouchEvent(event);
                }
            }
            return false;
        }

        private void onBindView(LogcatInfo info, int position) {
            int resourceId;
            int end;
            int start;
            String content;
            if (LogcatUtils.isPortrait(this.itemView.getContext())) {
                String log = info.getLog();
                content = String.format("%s  %s" + (log.startsWith("\n") ? "  " : "\n") + "%s", info.getTime(), info.getTag(), log);
            } else {
                content = info.toString();
            }
            SpannableString spannable = new SpannableString((CharSequence)content);
            if (LogcatAdapter.this.mKeyword != null && LogcatAdapter.this.mKeyword.length() > 0) {
                int index = content.indexOf(LogcatAdapter.this.mKeyword);
                if (index == -1) {
                    index = content.toLowerCase().indexOf(LogcatAdapter.this.mKeyword.toLowerCase());
                }
                while (index > -1) {
                    start = index;
                    end = index + LogcatAdapter.this.mKeyword.length();
                    spannable.setSpan((Object)new BackgroundColorSpan(-1), start, end, 33);
                    spannable.setSpan((Object)new ForegroundColorSpan(-16777216), start, end, 33);
                    index = content.indexOf(LogcatAdapter.this.mKeyword, end);
                    if (index != -1) continue;
                    index = content.toLowerCase().indexOf(LogcatAdapter.this.mKeyword.toLowerCase(), end);
                }
            } else {
                Matcher matcher = CODE_REGEX.matcher(content);
                if (spannable.length() > 0) {
                    while (matcher.find()) {
                        start = matcher.start() + "(".length();
                        end = matcher.end() - ")".length();
                        spannable.setSpan((Object)new ForegroundColorSpan(-6710887), start, end, 33);
                        spannable.setSpan((Object)new UnderlineSpan(), start, end, 33);
                    }
                }
            }
            this.mContentView.setText((CharSequence)spannable);
            switch (info.getLevel()) {
                case "D": {
                    resourceId = R.color.logcat_level_debug_color;
                    break;
                }
                case "I": {
                    resourceId = R.color.logcat_level_info_color;
                    break;
                }
                case "W": {
                    resourceId = R.color.logcat_level_warn_color;
                    break;
                }
                case "E": {
                    resourceId = R.color.logcat_level_error_color;
                    break;
                }
                case "V": {
                    resourceId = R.color.logcat_level_verbose_color;
                    break;
                }
                default: {
                    resourceId = R.color.logcat_level_other_color;
                }
            }
            int textColor = Build.VERSION.SDK_INT >= 23 ? this.mContentView.getResources().getColor(resourceId, this.mContentView.getContext().getTheme()) : this.mContentView.getResources().getColor(resourceId);
            this.mContentView.setTextColor(textColor);
            this.mLineView.setVisibility(position == 0 ? 4 : 0);
            int maxLine = LogcatUtils.isPortrait(this.itemView.getContext()) ? 6 : 4;
            if (content.split("\n").length - maxLine > 1) {
                if (LogcatAdapter.this.mExpandSet.get(info.hashCode())) {
                    if (this.mContentView.getMaxLines() != Integer.MAX_VALUE) {
                        this.mContentView.setMaxLines(Integer.MAX_VALUE);
                    }
                    this.mIndexView.setText((CharSequence)String.valueOf(position + 1));
                } else {
                    if (this.mContentView.getMaxLines() != maxLine) {
                        this.mContentView.setMaxLines(maxLine);
                    }
                    this.mIndexView.setText((CharSequence)"V");
                }
            } else {
                this.mContentView.setMaxLines(Integer.MAX_VALUE);
                this.mIndexView.setText((CharSequence)String.valueOf(position + 1));
            }
            this.mHorizontalScrollView.post(this.mScrollRunnable);
        }

        public void onDetached() {
            this.mHorizontalScrollView.removeCallbacks(this.mScrollRunnable);
        }

        public void onRecycled() {
            this.mHorizontalScrollView.removeCallbacks(this.mScrollRunnable);
        }
    }
}

