/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.gson.factory.data;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.math.BigDecimal;

public class LongTypeAdapter
extends TypeAdapter<Long> {
    public Long read(JsonReader in) throws IOException {
        JsonToken jsonToken = in.peek();
        switch (jsonToken) {
            case NUMBER: {
                try {
                    return in.nextLong();
                }
                catch (NumberFormatException e) {
                    return new BigDecimal(in.nextString()).longValue();
                }
            }
            case STRING: {
                String result = in.nextString();
                if (result == null || "".equals(result)) {
                    return 0L;
                }
                try {
                    return Long.parseLong(result);
                }
                catch (NumberFormatException e) {
                    return new BigDecimal(result).longValue();
                }
            }
            case NULL: {
                in.nextNull();
                return null;
            }
        }
        in.skipValue();
        throw new IllegalArgumentException("The current parser is of type Long, but the data is of type " + jsonToken);
    }

    public void write(JsonWriter out, Long value) throws IOException {
        out.value((Number)value);
    }
}

