/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.gson.factory.data;

import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.bind.TypeAdapters;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONObjectTypeAdapter
extends TypeAdapter<JSONObject> {
    private static final TypeAdapter<JsonElement> PROXY = TypeAdapters.JSON_ELEMENT;

    public JSONObject read(JsonReader in) throws IOException {
        JsonElement read = (JsonElement)PROXY.read(in);
        if (read.isJsonObject()) {
            try {
                return new JSONObject(read.toString());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void write(JsonWriter out, JSONObject value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        PROXY.write(out, PROXY.fromJson(value.toString()));
    }
}

