/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.gson.factory.data;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public class DoubleTypeAdapter
extends TypeAdapter<Double> {
    public Double read(JsonReader in) throws IOException {
        JsonToken jsonToken = in.peek();
        switch (jsonToken) {
            case NUMBER: {
                return in.nextDouble();
            }
            case STRING: {
                String result = in.nextString();
                if (result == null || "".equals(result)) {
                    return 0.0;
                }
                return Double.parseDouble(result);
            }
            case NULL: {
                in.nextNull();
                return null;
            }
        }
        in.skipValue();
        throw new IllegalArgumentException("The current parser is of type Double, but the data is of type " + jsonToken);
    }

    public void write(JsonWriter out, Double value) throws IOException {
        out.value((Number)value);
    }
}

