/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.gson.factory.element;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.internal.bind.TypeAdapters;
import com.google.gson.reflect.TypeToken;
import com.hjq.gson.factory.constructor.MainConstructor;
import com.hjq.gson.factory.element.MapTypeAdapter;
import java.lang.reflect.Type;
import java.util.Map;

public class MapTypeAdapterFactory
implements TypeAdapterFactory {
    private final MainConstructor mMainConstructor;
    final boolean mComplexMapKeySerialization;

    public MapTypeAdapterFactory(MainConstructor mainConstructor, boolean complexMapKeySerialization) {
        this.mMainConstructor = mainConstructor;
        this.mComplexMapKeySerialization = complexMapKeySerialization;
    }

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        Type type = typeToken.getType();
        Class rawType = typeToken.getRawType();
        if (!Map.class.isAssignableFrom(rawType)) {
            return null;
        }
        Class rawTypeOfSrc = .Gson.Types.getRawType((Type)type);
        Type[] keyAndValueTypes = .Gson.Types.getMapKeyAndValueTypes((Type)type, (Class)rawTypeOfSrc);
        TypeAdapter<?> keyAdapter = this.getKeyAdapter(gson, keyAndValueTypes[0]);
        TypeAdapter valueAdapter = gson.getAdapter(TypeToken.get((Type)keyAndValueTypes[1]));
        ObjectConstructor<T> constructor = this.mMainConstructor.get(typeToken);
        MapTypeAdapter result = new MapTypeAdapter(gson, keyAndValueTypes[0], keyAdapter, keyAndValueTypes[1], valueAdapter, constructor, this.mComplexMapKeySerialization);
        result.setReflectiveType(typeToken, null);
        return result;
    }

    private TypeAdapter<?> getKeyAdapter(Gson context, Type keyType) {
        return keyType == Boolean.TYPE || keyType == Boolean.class ? TypeAdapters.BOOLEAN_AS_STRING : context.getAdapter(TypeToken.get((Type)keyType));
    }
}

