/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.gson.factory.constructor;

import com.google.gson.JsonIOException;
import com.google.gson.internal.ObjectConstructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.EnumSet;

public final class EnumSetConstructor<T>
implements ObjectConstructor<T> {
    private final Type mType;

    public EnumSetConstructor(Type type) {
        this.mType = type;
    }

    public T construct() {
        if (this.mType instanceof ParameterizedType) {
            Type elementType = ((ParameterizedType)this.mType).getActualTypeArguments()[0];
            if (elementType instanceof Class) {
                EnumSet set = EnumSet.noneOf((Class)elementType);
                return (T)set;
            }
            throw new JsonIOException("Invalid EnumSet type: " + this.mType);
        }
        throw new JsonIOException("Invalid EnumSet type: " + this.mType.toString());
    }
}

