/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.gson.factory.element;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.bind.ReflectiveTypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

public class TypeAdapterRuntimeTypeWrapper<T>
extends TypeAdapter<T> {
    private final Gson mGson;
    private final TypeAdapter<T> mDelegate;
    private final Type mType;

    public TypeAdapterRuntimeTypeWrapper(Gson gson, TypeAdapter<T> delegate, Type type) {
        this.mGson = gson;
        this.mDelegate = delegate;
        this.mType = type;
    }

    public T read(JsonReader in) throws IOException {
        return (T)this.mDelegate.read(in);
    }

    public void write(JsonWriter out, T value) throws IOException {
        TypeAdapter<T> chosen = this.mDelegate;
        Type runtimeType = this.getRuntimeTypeIfMoreSpecific(this.mType, value);
        if (runtimeType != this.mType) {
            TypeAdapter<T> runtimeTypeAdapter = this.mGson.getAdapter(TypeToken.get((Type)runtimeType));
            chosen = !(runtimeTypeAdapter instanceof ReflectiveTypeAdapterFactory.Adapter) ? runtimeTypeAdapter : (!(this.mDelegate instanceof ReflectiveTypeAdapterFactory.Adapter) ? this.mDelegate : runtimeTypeAdapter);
        }
        chosen.write(out, value);
    }

    private Type getRuntimeTypeIfMoreSpecific(Type type, Object value) {
        if (value != null && (type == Object.class || type instanceof TypeVariable || type instanceof Class)) {
            type = value.getClass();
        }
        return type;
    }
}

