/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.request;

import androidx.annotation.Nullable;
import androidx.lifecycle.LifecycleOwner;
import com.hjq.http.EasyConfig;
import com.hjq.http.EasyLog;
import com.hjq.http.config.IRequestBodyStrategy;
import com.hjq.http.model.HttpHeaders;
import com.hjq.http.model.HttpParams;
import com.hjq.http.request.HttpRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.Request;

public abstract class UrlRequest<T extends UrlRequest<?>>
extends HttpRequest<T> {
    public UrlRequest(LifecycleOwner lifecycleOwner) {
        super(lifecycleOwner);
    }

    @Override
    protected void addHttpParams(HttpParams params, String key, Object value, IRequestBodyStrategy requestBodyStrategy) {
        params.put(key, value);
    }

    @Override
    protected void addRequestParams(Request.Builder requestBuilder, HttpParams params, @Nullable String contentType, IRequestBodyStrategy requestBodyStrategy) {
        HttpUrl.Builder urlBuilder = requestBuilder.build().url().newBuilder();
        if (!params.isEmpty()) {
            for (String key : params.getKeys()) {
                Object value = params.get(key);
                if (value instanceof List) {
                    List list = (List)value;
                    for (Object itemValue : list) {
                        if (itemValue == null) continue;
                        urlBuilder.addQueryParameter(key, String.valueOf(itemValue));
                    }
                    continue;
                }
                if (value instanceof HashMap) {
                    Map map = (Map)value;
                    for (Object itemKey : map.keySet()) {
                        Object itemValue;
                        if (itemKey == null || (itemValue = map.get(itemKey)) == null) continue;
                        urlBuilder.addQueryParameter(key, String.valueOf(itemValue));
                    }
                    continue;
                }
                urlBuilder.addQueryParameter(key, String.valueOf(value));
            }
        }
        HttpUrl link = urlBuilder.build();
        requestBuilder.url(link);
        requestBuilder.method(this.getRequestMethod(), null);
    }

    @Override
    protected void printRequestLog(Request request, HttpParams params, HttpHeaders headers, IRequestBodyStrategy requestBodyStrategy) {
        if (!EasyConfig.getInstance().isLogEnabled()) {
            return;
        }
        EasyLog.printKeyValue(this, "RequestUrl", String.valueOf(request.url()));
        EasyLog.printKeyValue(this, "RequestMethod", this.getRequestMethod());
        if (!headers.isEmpty() || !params.isEmpty()) {
            EasyLog.printLine(this);
        }
        for (String key : headers.getKeys()) {
            EasyLog.printKeyValue(this, key, headers.get(key));
        }
        if (!headers.isEmpty() && !params.isEmpty()) {
            EasyLog.printLine(this);
        }
        for (String key : params.getKeys()) {
            Object value = params.get(key);
            if (value instanceof List) {
                List list = (List)value;
                for (int i = 0; i < list.size(); ++i) {
                    this.printKeyValue(key + "[" + i + "]", list.get(i));
                }
                continue;
            }
            if (value instanceof HashMap) {
                Map map = (Map)value;
                for (Object itemKey : map.keySet()) {
                    if (itemKey == null) continue;
                    this.printKeyValue(String.valueOf(itemKey), map.get(itemKey));
                }
                continue;
            }
            this.printKeyValue(key, String.valueOf(params.get(key)));
        }
        if (!headers.isEmpty() || !params.isEmpty()) {
            EasyLog.printLine(this);
        }
    }
}

