/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.request;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.LifecycleOwner;
import com.hjq.http.EasyConfig;
import com.hjq.http.EasyLog;
import com.hjq.http.EasyUtils;
import com.hjq.http.annotation.HttpHeader;
import com.hjq.http.annotation.HttpIgnore;
import com.hjq.http.annotation.HttpRename;
import com.hjq.http.callback.NormalCallback;
import com.hjq.http.config.IRequestApi;
import com.hjq.http.config.IRequestBodyStrategy;
import com.hjq.http.config.IRequestCache;
import com.hjq.http.config.IRequestClient;
import com.hjq.http.config.IRequestHandler;
import com.hjq.http.config.IRequestHost;
import com.hjq.http.config.IRequestInterceptor;
import com.hjq.http.config.IRequestServer;
import com.hjq.http.config.IRequestType;
import com.hjq.http.config.impl.EasyRequestApi;
import com.hjq.http.config.impl.EasyRequestServer;
import com.hjq.http.config.impl.RequestFormBodyStrategy;
import com.hjq.http.lifecycle.HttpLifecycleManager;
import com.hjq.http.listener.OnHttpListener;
import com.hjq.http.model.CacheMode;
import com.hjq.http.model.CallProxy;
import com.hjq.http.model.HttpHeaders;
import com.hjq.http.model.HttpParams;
import com.hjq.http.model.RequestBodyType;
import com.hjq.http.model.ResponseClass;
import com.hjq.http.model.ThreadSchedulers;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.CacheControl;
import okhttp3.Call;
import okhttp3.Request;
import okhttp3.Response;

public abstract class HttpRequest<T extends HttpRequest<?>> {
    private final LifecycleOwner mLifecycleOwner;
    private IRequestApi mRequestApi;
    private IRequestHost mRequestHost = EasyConfig.getInstance().getServer();
    private IRequestType mRequestType = EasyConfig.getInstance().getServer();
    private IRequestCache mRequestCache = EasyConfig.getInstance().getServer();
    private IRequestClient mRequestClient = EasyConfig.getInstance().getServer();
    private IRequestHandler mRequestHandler = EasyConfig.getInstance().getHandler();
    private IRequestInterceptor mRequestInterceptor = EasyConfig.getInstance().getInterceptor();
    private ThreadSchedulers mThreadSchedulers = EasyConfig.getInstance().getThreadSchedulers();
    private CallProxy mCallProxy;
    private String mTag;
    private long mDelayMillis;

    public HttpRequest(LifecycleOwner lifecycleOwner) {
        this.mLifecycleOwner = lifecycleOwner;
        this.tag(lifecycleOwner);
    }

    public T api(Class<? extends IRequestApi> api) {
        try {
            return this.api(api.newInstance());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public T api(String api) {
        return this.api(new EasyRequestApi(api));
    }

    public T api(IRequestApi api) {
        this.mRequestApi = api;
        if (api instanceof IRequestHost) {
            this.mRequestHost = (IRequestHost)((Object)api);
        }
        if (api instanceof IRequestClient) {
            this.mRequestClient = (IRequestClient)((Object)api);
        }
        if (api instanceof IRequestType) {
            this.mRequestType = (IRequestType)((Object)api);
        }
        if (api instanceof IRequestCache) {
            this.mRequestCache = (IRequestCache)((Object)api);
        }
        if (api instanceof IRequestHandler) {
            this.mRequestHandler = (IRequestHandler)((Object)api);
        }
        if (api instanceof IRequestInterceptor) {
            this.mRequestInterceptor = (IRequestInterceptor)((Object)api);
        }
        return (T)this;
    }

    public T server(Class<? extends IRequestServer> server) {
        try {
            return this.server(server.newInstance());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public T server(String host) {
        return this.server(new EasyRequestServer(host));
    }

    public T server(IRequestServer server) {
        this.mRequestHost = server;
        this.mRequestClient = server;
        this.mRequestType = server;
        this.mRequestCache = server;
        return (T)this;
    }

    public T handler(IRequestHandler handler) {
        this.mRequestHandler = handler;
        return (T)this;
    }

    public T interceptor(IRequestInterceptor interceptor) {
        this.mRequestInterceptor = interceptor;
        return (T)this;
    }

    public T delay(long delay, TimeUnit unit) {
        return this.delay(unit.toMillis(delay));
    }

    public T delay(long delayMillis) {
        this.mDelayMillis = delayMillis;
        return (T)this;
    }

    public T tag(Object tag) {
        return this.tag(EasyUtils.getObjectTag(tag));
    }

    public T tag(String tag) {
        this.mTag = tag;
        return (T)this;
    }

    public T schedulers(@NonNull ThreadSchedulers schedulers) {
        this.mThreadSchedulers = schedulers;
        return (T)this;
    }

    @NonNull
    protected Call createCall() {
        IRequestBodyStrategy requestBodyStrategy = this.mRequestType.getBodyType();
        HttpParams params = new HttpParams();
        HttpHeaders headers = new HttpHeaders();
        List<Field> fields = EasyUtils.getAllFields(this.mRequestApi.getClass());
        params.setMultipart(EasyUtils.isMultipartParameter(fields));
        if (!params.isEmpty() && params.isMultipart() && !(requestBodyStrategy instanceof RequestFormBodyStrategy)) {
            requestBodyStrategy = RequestBodyType.FORM;
        }
        for (Field field : fields) {
            field.setAccessible(true);
            if (EasyUtils.isConstantField(field)) continue;
            try {
                String key;
                Object value = field.get(this.mRequestApi);
                HttpRename annotation = field.getAnnotation(HttpRename.class);
                if (annotation != null) {
                    key = annotation.value();
                } else {
                    key = field.getName();
                    if (key.matches("this\\$\\d+") || "Companion".equals(key)) continue;
                }
                if (field.isAnnotationPresent(HttpIgnore.class)) {
                    if (field.isAnnotationPresent(HttpHeader.class)) {
                        headers.remove(key);
                        continue;
                    }
                    params.remove(key);
                    continue;
                }
                if (value == null) continue;
                if (field.isAnnotationPresent(HttpHeader.class)) {
                    this.addHttpHeaders(headers, key, value);
                    continue;
                }
                this.addHttpParams(params, key, value, requestBodyStrategy);
            }
            catch (IllegalAccessException e) {
                EasyLog.printThrowable(this, e);
            }
        }
        String url = this.mRequestHost.getHost() + this.mRequestApi.getApi();
        if (this.mRequestInterceptor != null) {
            this.mRequestInterceptor.interceptArguments(this, params, headers);
        }
        Request request = this.createRequest(url, this.mTag, params, headers, requestBodyStrategy);
        if (this.mRequestInterceptor != null) {
            request = this.mRequestInterceptor.interceptRequest(this, request);
        }
        return this.mRequestClient.getOkHttpClient().newCall(request);
    }

    public void request(@Nullable OnHttpListener<?> listener) {
        if (this.mDelayMillis > 0L) {
            EasyLog.printKeyValue(this, "RequestDelay", String.valueOf(this.mDelayMillis));
        }
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        Runnable runnable = () -> EasyUtils.runOnAssignThread(ThreadSchedulers.IO, () -> {
            if (!HttpLifecycleManager.isLifecycleActive(this.mLifecycleOwner)) {
                EasyLog.printLog(this, "LifecycleOwner has been destroyed and the request cannot be made");
                return;
            }
            EasyLog.printStackTrace(this, stackTrace);
            new NormalCallback(this).setListener(listener).setCallProxyFactory(() -> {
                this.mCallProxy = new CallProxy(this.createCall());
                return this.mCallProxy;
            }).start();
        });
        this.sendRunnable(runnable, this.mDelayMillis, this.mTag);
    }

    public <Bean> Bean execute(ResponseClass<Bean> responseClass) throws Throwable {
        if (EasyUtils.isMainThread()) {
            throw new IllegalStateException("Synchronous requests are time-consuming operations, and time-consuming operations cannot be performed directly in the main thread");
        }
        if (this.mDelayMillis > 0L) {
            EasyLog.printKeyValue(this, "RequestDelay", String.valueOf(this.mDelayMillis));
            Thread.sleep(this.mDelayMillis);
        }
        if (!HttpLifecycleManager.isLifecycleActive(this.mLifecycleOwner)) {
            EasyLog.printLog(this, "LifecycleOwner has been destroyed and the request cannot be made");
            throw new IllegalStateException("The host has been destroyed and the request cannot proceed");
        }
        EasyLog.printStackTrace(this, new Throwable().getStackTrace());
        Type reflectType = this.mRequestHandler.getGenericType(responseClass);
        this.mCallProxy = new CallProxy(this.createCall());
        CacheMode cacheMode = this.getRequestCache().getCacheMode();
        if (cacheMode == CacheMode.USE_CACHE_ONLY || cacheMode == CacheMode.USE_CACHE_FIRST) {
            try {
                Object cacheResult = this.mRequestHandler.readCache(this, reflectType, this.mRequestCache.getCacheTime());
                EasyLog.printLog(this, "ReadCache result\uff1a" + cacheResult);
                if (cacheMode == CacheMode.USE_CACHE_FIRST) {
                    new NormalCallback(this).setReflectType(reflectType).setCallProxyFactory(() -> {
                        if (cacheResult != null) {
                            return this.mCallProxy;
                        }
                        return new CallProxy(this.createCall());
                    }).start();
                }
                if (cacheResult != null) {
                    return (Bean)cacheResult;
                }
            }
            catch (Throwable cacheThrowable) {
                EasyLog.printLog(this, "ReadCache error");
                EasyLog.printThrowable(this, cacheThrowable);
            }
        }
        try {
            Response response = this.mCallProxy.execute();
            IRequestInterceptor interceptor = this.mRequestInterceptor;
            if (interceptor != null) {
                response = interceptor.interceptResponse(this, response);
            }
            Object result = this.mRequestHandler.requestSuccess(this, response, reflectType);
            if (cacheMode == CacheMode.USE_CACHE_ONLY || cacheMode == CacheMode.USE_CACHE_AFTER_FAILURE) {
                try {
                    boolean writeCacheResult = this.mRequestHandler.writeCache(this, response, result);
                    EasyLog.printLog(this, "WriteCache result\uff1a" + writeCacheResult);
                }
                catch (Throwable cacheThrowable) {
                    EasyLog.printLog(this, "WriteCache error");
                    EasyLog.printThrowable(this, cacheThrowable);
                }
            }
            return (Bean)result;
        }
        catch (Throwable throwable) {
            Throwable finalThrowable;
            EasyLog.printThrowable(this, throwable);
            if (throwable instanceof IOException && cacheMode == CacheMode.USE_CACHE_AFTER_FAILURE) {
                try {
                    Object cacheResult = this.mRequestHandler.readCache(this, reflectType, this.mRequestCache.getCacheTime());
                    EasyLog.printLog(this, "ReadCache result\uff1a" + cacheResult);
                    if (cacheResult != null) {
                        return (Bean)cacheResult;
                    }
                }
                catch (Throwable cacheThrowable) {
                    EasyLog.printLog(this, "ReadCache error");
                    EasyLog.printThrowable(this, cacheThrowable);
                }
            }
            if ((finalThrowable = this.mRequestHandler.requestFail(this, throwable)) != throwable) {
                EasyLog.printThrowable(this, finalThrowable);
            }
            throw finalThrowable;
        }
    }

    public T cancel() {
        if (this.mCallProxy != null) {
            this.mCallProxy.cancel();
        }
        return (T)this;
    }

    @Nullable
    public String getTag() {
        return this.mTag;
    }

    @NonNull
    public LifecycleOwner getLifecycleOwner() {
        return this.mLifecycleOwner;
    }

    @NonNull
    public IRequestApi getRequestApi() {
        return this.mRequestApi;
    }

    @NonNull
    public IRequestHost getRequestHost() {
        return this.mRequestHost;
    }

    @NonNull
    public IRequestType getRequestType() {
        return this.mRequestType;
    }

    @NonNull
    public IRequestCache getRequestCache() {
        return this.mRequestCache;
    }

    @NonNull
    public IRequestClient getRequestClient() {
        return this.mRequestClient;
    }

    @NonNull
    public IRequestHandler getRequestHandler() {
        return this.mRequestHandler;
    }

    @NonNull
    public abstract String getRequestMethod();

    @Nullable
    public IRequestInterceptor getRequestInterceptor() {
        return this.mRequestInterceptor;
    }

    @NonNull
    public ThreadSchedulers getThreadSchedulers() {
        return this.mThreadSchedulers;
    }

    protected void sendRunnable(Runnable runnable, long delayMillis, String tag) {
        if (delayMillis > 0L) {
            int what = tag == null ? Integer.MAX_VALUE : tag.hashCode();
            EasyUtils.postDelayedRunnable(runnable, what, delayMillis);
        } else {
            runnable.run();
        }
    }

    protected long getDelayMillis() {
        return this.mDelayMillis;
    }

    protected void printKeyValue(String key, Object value) {
        if (value instanceof Enum) {
            EasyLog.printKeyValue(this, key, "\"" + value + "\"");
        } else if (value instanceof String) {
            EasyLog.printKeyValue(this, key, "\"" + value + "\"");
        } else {
            EasyLog.printKeyValue(this, key, String.valueOf(value));
        }
    }

    protected void addHttpHeaders(HttpHeaders headers, String key, Object value) {
        if (value instanceof Map) {
            Map map = (Map)value;
            for (Object o : map.keySet()) {
                if (o == null || map.get(o) == null) continue;
                headers.put(String.valueOf(o), String.valueOf(map.get(o)));
            }
        } else {
            headers.put(key, String.valueOf(value));
        }
    }

    protected abstract void addHttpParams(HttpParams var1, String var2, Object var3, IRequestBodyStrategy var4);

    @NonNull
    protected Request createRequest(String url, String tag, HttpParams params, HttpHeaders headers, IRequestBodyStrategy requestBodyStrategy) {
        Request.Builder requestBuilder = this.createRequestBuilder(url, tag);
        this.addRequestHeader(requestBuilder, headers);
        String contentType = headers.get("Content-Type");
        this.addRequestParams(requestBuilder, params, contentType, requestBodyStrategy);
        Request request = requestBuilder.build();
        this.printRequestLog(request, params, headers, requestBodyStrategy);
        return request;
    }

    @NonNull
    protected Request.Builder createRequestBuilder(String url, String tag) {
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.url(url);
        if (tag != null) {
            requestBuilder.tag((Object)tag);
        }
        if (this.mRequestCache.getCacheMode() == CacheMode.NO_CACHE) {
            requestBuilder.cacheControl(new CacheControl.Builder().noCache().build());
        }
        return requestBuilder;
    }

    protected void addRequestHeader(Request.Builder requestBuilder, HttpHeaders headers) {
        if (headers.isEmpty()) {
            return;
        }
        for (String key : headers.getKeys()) {
            String value = headers.get(key);
            try {
                requestBuilder.addHeader(key, value);
            }
            catch (IllegalArgumentException e) {
                requestBuilder.addHeader(EasyUtils.encodeString(key), EasyUtils.encodeString(value));
                e.printStackTrace();
            }
        }
    }

    protected abstract void addRequestParams(Request.Builder var1, HttpParams var2, @Nullable String var3, IRequestBodyStrategy var4);

    protected abstract void printRequestLog(Request var1, HttpParams var2, HttpHeaders var3, IRequestBodyStrategy var4);

    public String generateLogTag() {
        if (this.mRequestApi == null) {
            return "";
        }
        return this.mRequestApi.getClass().getSimpleName() + "@" + Integer.toHexString(this.mRequestApi.hashCode());
    }
}

