/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.request;

import android.content.ContentResolver;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.LifecycleOwner;
import com.hjq.http.EasyLog;
import com.hjq.http.EasyUtils;
import com.hjq.http.callback.DownloadCallback;
import com.hjq.http.config.IRequestBodyStrategy;
import com.hjq.http.config.impl.EasyDownloadApi;
import com.hjq.http.config.impl.EasyRequestServer;
import com.hjq.http.lifecycle.HttpLifecycleManager;
import com.hjq.http.listener.OnDownloadListener;
import com.hjq.http.listener.OnHttpListener;
import com.hjq.http.model.CallProxy;
import com.hjq.http.model.FileContentResolver;
import com.hjq.http.model.HttpHeaders;
import com.hjq.http.model.HttpMethod;
import com.hjq.http.model.HttpParams;
import com.hjq.http.model.ResponseClass;
import com.hjq.http.request.GetRequest;
import com.hjq.http.request.HttpRequest;
import com.hjq.http.request.PostRequest;
import java.io.File;
import okhttp3.Request;

public final class DownloadRequest
extends HttpRequest<DownloadRequest> {
    private HttpRequest<?> mRealRequest;
    private HttpMethod mMethod = HttpMethod.GET;
    private File mFile;
    private String mMd5;
    private boolean mResumableTransfer = false;
    private OnDownloadListener mListener;
    private CallProxy mCallProxy;

    public DownloadRequest(LifecycleOwner lifecycleOwner) {
        super(lifecycleOwner);
        this.mRealRequest = new GetRequest(lifecycleOwner);
    }

    public DownloadRequest method(HttpMethod method) {
        this.mMethod = method;
        switch (this.mMethod) {
            case GET: {
                this.mRealRequest = new GetRequest(this.getLifecycleOwner());
                break;
            }
            case POST: {
                this.mRealRequest = new PostRequest(this.getLifecycleOwner());
                break;
            }
            default: {
                throw new IllegalStateException("method nonsupport");
            }
        }
        return this;
    }

    public DownloadRequest url(String url) {
        this.server(new EasyRequestServer(url));
        this.api(new EasyDownloadApi(""));
        return this;
    }

    public DownloadRequest file(String filePath) {
        return this.file(new File(filePath));
    }

    public DownloadRequest file(File file) {
        this.mFile = file;
        return this;
    }

    public DownloadRequest file(ContentResolver resolver, Uri uri) {
        return this.file(new FileContentResolver(resolver, uri));
    }

    public DownloadRequest file(FileContentResolver file) {
        this.mFile = file;
        return this;
    }

    public DownloadRequest md5(String md5) {
        this.mMd5 = md5;
        return this;
    }

    public DownloadRequest resumableTransfer(boolean enable) {
        this.mResumableTransfer = enable;
        return this;
    }

    public DownloadRequest listener(OnDownloadListener listener) {
        this.mListener = listener;
        return this;
    }

    public DownloadRequest start() {
        long delayMillis = this.getDelayMillis();
        if (delayMillis > 0L) {
            EasyLog.printKeyValue(this, "RequestDelay", String.valueOf(delayMillis));
        }
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        Runnable runnable = () -> {
            if (!HttpLifecycleManager.isLifecycleActive(this.getLifecycleOwner())) {
                EasyLog.printLog(this, "LifecycleOwner has been destroyed and the request cannot be made");
                return;
            }
            EasyLog.printStackTrace(this, stackTrace);
            DownloadCallback downloadCallback = new DownloadCallback(this, this.mFile);
            downloadCallback.setMd5(this.mMd5).setResumableTransfer(this.mResumableTransfer).setListener(this.mListener).setCallProxyFactory(() -> {
                this.mCallProxy = new CallProxy(this.createCall());
                return this.mCallProxy;
            });
            if (downloadCallback.verifyFileMd5()) {
                EasyLog.printLog(this, this.mFile.getPath() + " download file already exists, skip download");
                EasyUtils.runOnAssignThread(this.getThreadSchedulers(), downloadCallback::dispatchDownloadStartCallback);
                EasyUtils.runOnAssignThread(this.getThreadSchedulers(), () -> downloadCallback.dispatchDownloadSuccessCallback(true));
                return;
            }
            downloadCallback.start();
        };
        this.sendRunnable(runnable, delayMillis, this.getTag());
        return this;
    }

    public DownloadRequest stop() {
        if (this.mCallProxy != null) {
            this.mCallProxy.cancel();
        }
        return this;
    }

    @Override
    public void request(@Nullable OnHttpListener<?> listener) {
        throw new IllegalStateException("Call the start method");
    }

    @Override
    public <Bean> Bean execute(ResponseClass<Bean> responseClass) {
        throw new IllegalStateException("Call the start method");
    }

    @Override
    public DownloadRequest cancel() {
        throw new IllegalStateException("Call the start method");
    }

    @Override
    @NonNull
    public String getRequestMethod() {
        return String.valueOf((Object)this.mMethod);
    }

    @Override
    protected Request createRequest(String url, String tag, HttpParams params, HttpHeaders headers, IRequestBodyStrategy requestBodyStrategy) {
        if (this.mResumableTransfer && this.mFile.isFile() && this.mFile.length() > 0L) {
            headers.put("Range", "bytes=" + this.mFile.length() + "-");
        }
        return ((HttpRequest)this.mRealRequest.api(this.getRequestApi())).createRequest(url, tag, params, headers, requestBodyStrategy);
    }

    @Override
    protected void addHttpParams(HttpParams params, String key, Object value, IRequestBodyStrategy requestBodyStrategy) {
        this.mRealRequest.addHttpParams(params, key, value, requestBodyStrategy);
    }

    @Override
    protected void addRequestParams(Request.Builder requestBuilder, HttpParams params, @Nullable String contentType, IRequestBodyStrategy requestBodyStrategy) {
        this.mRealRequest.addRequestParams(requestBuilder, params, contentType, requestBodyStrategy);
    }

    @Override
    protected void printRequestLog(Request request, HttpParams params, HttpHeaders headers, IRequestBodyStrategy requestBodyStrategy) {
        this.mRealRequest.printRequestLog(request, params, headers, requestBodyStrategy);
    }
}

