/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.model;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.hjq.http.EasyUtils;
import com.hjq.http.model.ContentType;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import okhttp3.MediaType;

public class FileContentResolver
extends File {
    private final ContentResolver mContentResolver;
    private final Uri mContentUri;
    private MediaType mContentType;
    private String mFileName;

    public FileContentResolver(Context context, Uri uri) {
        this(context.getContentResolver(), uri);
    }

    public FileContentResolver(ContentResolver resolver, Uri uri) {
        this(resolver, uri, null);
    }

    public FileContentResolver(Context context, Uri uri, String fileName) {
        this(context.getContentResolver(), uri, fileName);
    }

    public FileContentResolver(ContentResolver resolver, Uri uri, String fileName) {
        super(new File(uri.toString()).getPath());
        this.mContentResolver = resolver;
        this.mContentUri = uri;
        if (!TextUtils.isEmpty((CharSequence)fileName)) {
            this.mFileName = fileName;
            this.mContentType = ContentType.guessMimeType(fileName);
        } else {
            this.mFileName = this.getName();
            this.mContentType = ContentType.STREAM;
        }
    }

    public void setFileName(String fileName) {
        this.mFileName = fileName;
    }

    public String getFileName() {
        return this.mFileName;
    }

    public void setContentType(MediaType type) {
        this.mContentType = type;
    }

    public MediaType getContentType() {
        return this.mContentType;
    }

    public Uri getContentUri() {
        return this.mContentUri;
    }

    public InputStream openInputStream() throws FileNotFoundException {
        return this.mContentResolver.openInputStream(this.mContentUri);
    }

    public OutputStream openOutputStream(boolean append) throws FileNotFoundException {
        return this.mContentResolver.openOutputStream(this.mContentUri, append ? "wa" : "w");
    }

    @Override
    public boolean delete() {
        return this.mContentResolver.delete(this.mContentUri, null, null) > 0;
    }

    @Override
    public boolean renameTo(@NonNull File dest) {
        return false;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long length() {
        InputStream inputStream = null;
        try {
            inputStream = this.openInputStream();
            if (inputStream != null) {
                long l = inputStream.available();
                return l;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            EasyUtils.closeStream(inputStream);
        }
        return 0L;
    }

    @Override
    public boolean exists() {
        boolean bl;
        Cursor cursor = null;
        try {
            cursor = this.mContentResolver.query(this.mContentUri, null, null, null, null);
            bl = cursor != null && cursor.getCount() != 0;
        }
        catch (Throwable throwable) {
            EasyUtils.closeStream(cursor);
            throw throwable;
        }
        EasyUtils.closeStream((Closeable)cursor);
        return bl;
    }

    @Override
    public boolean isFile() {
        return this.exists();
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean mkdir() {
        return true;
    }

    @Override
    public boolean mkdirs() {
        return true;
    }

    @Override
    @Nullable
    public File getParentFile() {
        return null;
    }

    @Override
    public boolean setLastModified(long time) {
        return false;
    }

    @Override
    public long lastModified() {
        return 0L;
    }

    @Override
    @Nullable
    public String[] list() {
        return null;
    }

    @Override
    @Nullable
    public String[] list(@Nullable FilenameFilter filter) {
        return null;
    }

    @Override
    @Nullable
    public File[] listFiles() {
        return null;
    }

    @Override
    @Nullable
    public File[] listFiles(@Nullable FileFilter filter) {
        return null;
    }

    @Override
    @Nullable
    public File[] listFiles(@Nullable FilenameFilter filter) {
        return null;
    }
}

