/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.lifecycle;

import android.app.Activity;
import android.app.Application;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleRegistry;

public final class ActivityLifecycle
implements LifecycleOwner,
LifecycleEventObserver,
Application.ActivityLifecycleCallbacks {
    private final LifecycleRegistry mLifecycle = new LifecycleRegistry((LifecycleOwner)this);
    private Activity mActivity;

    public ActivityLifecycle(@NonNull Activity activity) {
        this.mActivity = activity;
        if (this.mActivity instanceof LifecycleOwner) {
            ((LifecycleOwner)this.mActivity).getLifecycle().addObserver((LifecycleObserver)this);
            return;
        }
        if (Build.VERSION.SDK_INT >= 29) {
            this.mActivity.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            return;
        }
        this.mActivity.getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
    }

    @NonNull
    public Lifecycle getLifecycle() {
        return this.mLifecycle;
    }

    public void onStateChanged(@NonNull LifecycleOwner source, @NonNull Lifecycle.Event event) {
        this.mLifecycle.handleLifecycleEvent(event);
        if (event != Lifecycle.Event.ON_DESTROY) {
            return;
        }
        source.getLifecycle().removeObserver((LifecycleObserver)this);
        this.mActivity = null;
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        if (this.mActivity != activity) {
            return;
        }
        this.mLifecycle.handleLifecycleEvent(Lifecycle.Event.ON_CREATE);
    }

    public void onActivityStarted(Activity activity) {
        if (this.mActivity != activity) {
            return;
        }
        this.mLifecycle.handleLifecycleEvent(Lifecycle.Event.ON_START);
    }

    public void onActivityResumed(Activity activity) {
        if (this.mActivity != activity) {
            return;
        }
        this.mLifecycle.handleLifecycleEvent(Lifecycle.Event.ON_RESUME);
    }

    public void onActivityPaused(Activity activity) {
        if (this.mActivity != activity) {
            return;
        }
        this.mLifecycle.handleLifecycleEvent(Lifecycle.Event.ON_PAUSE);
    }

    public void onActivityStopped(Activity activity) {
        if (this.mActivity != activity) {
            return;
        }
        this.mLifecycle.handleLifecycleEvent(Lifecycle.Event.ON_STOP);
    }

    public void onActivityDestroyed(Activity activity) {
        if (this.mActivity != activity) {
            return;
        }
        this.mLifecycle.handleLifecycleEvent(Lifecycle.Event.ON_DESTROY);
        if (Build.VERSION.SDK_INT >= 29) {
            this.mActivity.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        } else {
            this.mActivity.getApplication().unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        }
        this.mActivity = null;
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }
}

