/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.config.impl;

import android.text.TextUtils;
import com.hjq.http.EasyLog;
import com.hjq.http.body.UpdateStreamRequestBody;
import com.hjq.http.config.IRequestBodyStrategy;
import com.hjq.http.model.FileContentResolver;
import com.hjq.http.model.HttpParams;
import com.hjq.http.request.HttpRequest;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import okhttp3.FormBody;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okio.Okio;

public class RequestFormBodyStrategy
implements IRequestBodyStrategy {
    @Override
    public void addParams(HttpParams params, String key, Object value) {
        params.put(key, value);
    }

    @Override
    public RequestBody createRequestBody(HttpRequest<?> httpRequest, HttpParams params) {
        if (!params.isEmpty() && params.isMultipart()) {
            return this.createMultipartRequestBody(httpRequest, params);
        }
        return this.createFormRequestBody(params);
    }

    public RequestBody createFormRequestBody(HttpParams params) {
        FormBody.Builder bodyBuilder = new FormBody.Builder();
        if (params.isEmpty()) {
            return bodyBuilder.build();
        }
        for (String key : params.getKeys()) {
            Object value = params.get(key);
            if (!(value instanceof List)) {
                bodyBuilder.add(key, String.valueOf(value));
                continue;
            }
            List list = (List)value;
            for (Object itemValue : list) {
                if (itemValue == null) continue;
                bodyBuilder.add(key, String.valueOf(itemValue));
            }
        }
        return bodyBuilder.build();
    }

    public RequestBody createMultipartRequestBody(HttpRequest<?> httpRequest, HttpParams params) {
        MultipartBody.Builder bodyBuilder = new MultipartBody.Builder();
        bodyBuilder.setType(MultipartBody.FORM);
        for (String key : params.getKeys()) {
            Object value = params.get(key);
            if (value instanceof Map) {
                Map map = (Map)value;
                for (Object itemKey : map.keySet()) {
                    Object itemValue;
                    if (itemKey == null || (itemValue = map.get(itemKey)) == null) continue;
                    this.addFormData(httpRequest, bodyBuilder, String.valueOf(itemKey), itemValue);
                }
                continue;
            }
            if (value instanceof List) {
                List list = (List)value;
                for (Object itemValue : list) {
                    if (itemValue == null) continue;
                    this.addFormData(httpRequest, bodyBuilder, key, itemValue);
                }
                continue;
            }
            this.addFormData(httpRequest, bodyBuilder, key, value);
        }
        try {
            return bodyBuilder.build();
        }
        catch (IllegalStateException ignored) {
            return new FormBody.Builder().build();
        }
    }

    private void addFormData(HttpRequest<?> httpRequest, MultipartBody.Builder bodyBuilder, String key, Object object) {
        if (object instanceof File) {
            File file = (File)object;
            String fileName = null;
            if (file instanceof FileContentResolver) {
                fileName = ((FileContentResolver)file).getFileName();
            }
            if (TextUtils.isEmpty(fileName)) {
                fileName = file.getName();
            }
            try {
                MultipartBody.Part part;
                if (file instanceof FileContentResolver) {
                    FileContentResolver fileContentResolver = (FileContentResolver)file;
                    InputStream inputStream = fileContentResolver.openInputStream();
                    part = MultipartBody.Part.createFormData((String)key, (String)fileName, (RequestBody)new UpdateStreamRequestBody(Okio.source((InputStream)inputStream), fileContentResolver.getContentType(), fileName, inputStream.available()));
                } else {
                    part = MultipartBody.Part.createFormData((String)key, (String)fileName, (RequestBody)new UpdateStreamRequestBody(file));
                }
                bodyBuilder.addPart(part);
            }
            catch (FileNotFoundException e) {
                EasyLog.printLog(httpRequest, "File does not exist, will be ignored upload: " + key + " = " + file.getPath());
            }
            catch (IOException e) {
                EasyLog.printThrowable(httpRequest, e);
                EasyLog.printLog(httpRequest, "File stream reading failed and will be ignored upload: " + key + " = " + file.getPath());
            }
            return;
        }
        if (object instanceof InputStream) {
            InputStream inputStream = (InputStream)object;
            try {
                bodyBuilder.addPart(MultipartBody.Part.createFormData((String)key, null, (RequestBody)new UpdateStreamRequestBody(inputStream, key)));
            }
            catch (IOException e) {
                EasyLog.printThrowable(httpRequest, e);
            }
            return;
        }
        if (object instanceof RequestBody) {
            RequestBody requestBody = (RequestBody)object;
            if (requestBody instanceof UpdateStreamRequestBody) {
                bodyBuilder.addPart(MultipartBody.Part.createFormData((String)key, (String)((UpdateStreamRequestBody)requestBody).getKeyName(), (RequestBody)requestBody));
            } else {
                bodyBuilder.addPart(MultipartBody.Part.createFormData((String)key, null, (RequestBody)requestBody));
            }
            return;
        }
        if (object instanceof MultipartBody.Part) {
            bodyBuilder.addPart((MultipartBody.Part)object);
            return;
        }
        bodyBuilder.addFormDataPart(key, String.valueOf(object));
    }
}

