/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.callback;

import androidx.annotation.NonNull;
import com.hjq.http.EasyLog;
import com.hjq.http.EasyUtils;
import com.hjq.http.callback.BaseCallback;
import com.hjq.http.config.IRequestInterceptor;
import com.hjq.http.lifecycle.HttpLifecycleManager;
import com.hjq.http.listener.OnHttpListener;
import com.hjq.http.model.CacheMode;
import com.hjq.http.request.HttpRequest;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import okhttp3.Response;
import okhttp3.ResponseBody;

public final class NormalCallback
extends BaseCallback {
    private final HttpRequest mHttpRequest;
    private OnHttpListener mListener;
    private Type mReflectType;

    public NormalCallback(@NonNull HttpRequest request) {
        super(request);
        this.mHttpRequest = request;
    }

    public NormalCallback setListener(OnHttpListener listener) {
        this.mListener = listener;
        this.mReflectType = this.mHttpRequest.getRequestHandler().getGenericType(this.mListener);
        return this;
    }

    public NormalCallback setReflectType(Type reflectType) {
        this.mReflectType = reflectType;
        return this;
    }

    @Override
    public void start() {
        CacheMode cacheMode = this.mHttpRequest.getRequestCache().getCacheMode();
        if (cacheMode != CacheMode.USE_CACHE_ONLY && cacheMode != CacheMode.USE_CACHE_FIRST) {
            super.start();
            return;
        }
        try {
            Object result = this.mHttpRequest.getRequestHandler().readCache(this.mHttpRequest, this.mReflectType, this.mHttpRequest.getRequestCache().getCacheTime());
            EasyLog.printLog(this.mHttpRequest, "ReadCache result\uff1a" + result);
            if (result == null) {
                super.start();
                return;
            }
            EasyUtils.runOnAssignThread(this.mHttpRequest.getThreadSchedulers(), () -> {
                this.dispatchHttpStartCallback();
                this.dispatchHttpSuccessCallback(result, true);
            });
            if (cacheMode == CacheMode.USE_CACHE_FIRST) {
                EasyUtils.postDelayedRunnable(() -> {
                    if (!HttpLifecycleManager.isLifecycleActive(this.mHttpRequest.getLifecycleOwner())) {
                        return;
                    }
                    this.mListener = null;
                    super.start();
                }, 1L);
            }
        }
        catch (Throwable cacheThrowable) {
            EasyLog.printLog(this.mHttpRequest, "ReadCache error");
            EasyLog.printThrowable(this.mHttpRequest, cacheThrowable);
            super.start();
        }
    }

    @Override
    protected void onStart() {
        EasyUtils.runOnAssignThread(this.mHttpRequest.getThreadSchedulers(), this::dispatchHttpStartCallback);
    }

    @Override
    protected void onHttpResponse(Response response) throws Throwable {
        EasyLog.printLog(this.mHttpRequest, "RequestConsuming\uff1a" + (response.receivedResponseAtMillis() - response.sentRequestAtMillis()) + " ms");
        IRequestInterceptor interceptor = this.mHttpRequest.getRequestInterceptor();
        if (interceptor != null) {
            response = interceptor.interceptResponse(this.mHttpRequest, response);
        }
        Object result = this.mHttpRequest.getRequestHandler().requestSuccess(this.mHttpRequest, response, this.mReflectType);
        CacheMode cacheMode = this.mHttpRequest.getRequestCache().getCacheMode();
        if (cacheMode == CacheMode.USE_CACHE_ONLY || cacheMode == CacheMode.USE_CACHE_FIRST || cacheMode == CacheMode.USE_CACHE_AFTER_FAILURE) {
            try {
                boolean writeCacheResult = this.mHttpRequest.getRequestHandler().writeCache(this.mHttpRequest, response, result);
                EasyLog.printLog(this.mHttpRequest, "write cache result\uff1a" + writeCacheResult);
            }
            catch (Throwable cacheThrowable) {
                EasyLog.printLog(this.mHttpRequest, "write cache error");
                EasyLog.printThrowable(this.mHttpRequest, cacheThrowable);
            }
        }
        EasyUtils.runOnAssignThread(this.mHttpRequest.getThreadSchedulers(), () -> this.dispatchHttpSuccessCallback(result, false));
    }

    @Override
    protected void onHttpFailure(Throwable throwable) {
        Throwable finalThrowable;
        EasyLog.printThrowable(this.mHttpRequest, throwable);
        if (throwable instanceof IOException && this.mHttpRequest.getRequestCache().getCacheMode() == CacheMode.USE_CACHE_AFTER_FAILURE) {
            try {
                Object result = this.mHttpRequest.getRequestHandler().readCache(this.mHttpRequest, this.mReflectType, this.mHttpRequest.getRequestCache().getCacheTime());
                EasyLog.printLog(this.mHttpRequest, "ReadCache result\uff1a" + result);
                if (result != null) {
                    EasyUtils.runOnAssignThread(this.mHttpRequest.getThreadSchedulers(), () -> this.dispatchHttpSuccessCallback(result, true));
                    return;
                }
            }
            catch (Throwable cacheThrowable) {
                EasyLog.printLog(this.mHttpRequest, "ReadCache error");
                EasyLog.printThrowable(this.mHttpRequest, cacheThrowable);
            }
        }
        if ((finalThrowable = this.mHttpRequest.getRequestHandler().requestFail(this.mHttpRequest, throwable)) != throwable) {
            EasyLog.printThrowable(this.mHttpRequest, finalThrowable);
        }
        EasyUtils.runOnAssignThread(this.mHttpRequest.getThreadSchedulers(), () -> this.dispatchHttpFailCallback(finalThrowable));
    }

    private void dispatchHttpStartCallback() {
        if (this.mListener != null && HttpLifecycleManager.isLifecycleActive(this.mHttpRequest.getLifecycleOwner())) {
            this.mListener.onHttpStart(this.mHttpRequest.getRequestApi());
        }
        EasyLog.printLog(this.mHttpRequest, "Http request start");
    }

    private void dispatchHttpSuccessCallback(@NonNull Object result, boolean cache) {
        if (this.mListener != null && HttpLifecycleManager.isLifecycleActive(this.mHttpRequest.getLifecycleOwner())) {
            this.mListener.onHttpSuccess(result, cache);
            this.mListener.onHttpEnd(this.mHttpRequest.getRequestApi());
        }
        EasyLog.printLog(this.mHttpRequest, "Http request success");
    }

    private void dispatchHttpFailCallback(Throwable throwable) {
        if (this.mListener != null && HttpLifecycleManager.isLifecycleActive(this.mHttpRequest.getLifecycleOwner())) {
            this.mListener.onHttpFail(throwable);
            this.mListener.onHttpEnd(this.mHttpRequest.getRequestApi());
        }
        EasyLog.printLog(this.mHttpRequest, "Http request fail");
    }

    @Override
    protected void closeResponse(Response response) {
        if (Response.class.equals((Object)this.mReflectType) || ResponseBody.class.equals((Object)this.mReflectType) || InputStream.class.equals((Object)this.mReflectType)) {
            return;
        }
        super.closeResponse(response);
    }
}

