/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.callback;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.hjq.http.EasyLog;
import com.hjq.http.EasyUtils;
import com.hjq.http.callback.BaseCallback;
import com.hjq.http.config.IRequestInterceptor;
import com.hjq.http.exception.FileMd5Exception;
import com.hjq.http.exception.NullBodyException;
import com.hjq.http.exception.ResponseException;
import com.hjq.http.lifecycle.HttpLifecycleManager;
import com.hjq.http.listener.OnDownloadListener;
import com.hjq.http.model.CallProxy;
import com.hjq.http.request.HttpRequest;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicLong;
import okhttp3.Call;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public final class DownloadCallback
extends BaseCallback {
    @NonNull
    private final HttpRequest<?> mHttpRequest;
    private static final String FILE_MD5_REGEX = "^[\\w]{32}$";
    @NonNull
    private final File mFile;
    private String mMd5;
    private OnDownloadListener mListener;
    private final AtomicLong mTotalByte = new AtomicLong();
    private final AtomicLong mDownloadByte = new AtomicLong();
    private int mDownloadProgress;
    private boolean mResumableTransfer;

    public DownloadCallback(@NonNull HttpRequest<?> request, @NonNull File file) {
        super(request);
        this.mHttpRequest = request;
        this.mFile = file;
    }

    public DownloadCallback setMd5(String md5) {
        this.mMd5 = md5;
        return this;
    }

    public DownloadCallback setListener(OnDownloadListener listener) {
        this.mListener = listener;
        return this;
    }

    public DownloadCallback setResumableTransfer(boolean resumableTransfer) {
        this.mResumableTransfer = resumableTransfer;
        return this;
    }

    @Override
    protected void onStart() {
        EasyUtils.runOnAssignThread(this.mHttpRequest.getThreadSchedulers(), this::dispatchDownloadStartCallback);
    }

    @Override
    protected void onHttpResponse(Response response) throws Throwable {
        int readLength;
        ResponseBody body;
        File parentFile;
        String md5;
        IRequestInterceptor interceptor;
        EasyLog.printLog(this.mHttpRequest, "RequestConsuming\uff1a" + (response.receivedResponseAtMillis() - response.sentRequestAtMillis()) + " ms");
        if (response.code() == 416 && !TextUtils.isEmpty((CharSequence)response.request().header("Range"))) {
            Request request = response.request().newBuilder().removeHeader("Range").build();
            CallProxy callProxy = this.getCallProxy();
            Call newCall = this.mHttpRequest.getRequestClient().getOkHttpClient().newCall(request);
            callProxy.setRealCall(newCall);
            Response newResponse = callProxy.execute();
            EasyLog.printLog(this.mHttpRequest, "The response status code is 416, response message: " + response.message() + ", require special treatment, re-initiate a new request\uff0cnew request consuming\uff1a" + (newResponse.receivedResponseAtMillis() - newResponse.sentRequestAtMillis()) + " ms");
            response = newResponse;
        }
        if ((interceptor = this.mHttpRequest.getRequestInterceptor()) != null) {
            response = interceptor.interceptResponse(this.mHttpRequest, response);
        }
        if (!response.isSuccessful()) {
            throw new ResponseException("The request failed, response code: " + response.code() + ", response message: " + response.message(), response);
        }
        if (this.mMd5 == null && (md5 = response.header("Content-MD5")) != null && md5.matches(FILE_MD5_REGEX)) {
            this.mMd5 = md5;
        }
        if (this.verifyFileMd5()) {
            EasyLog.printLog(this.mHttpRequest, this.mFile.getPath() + " download file already exists, skip request");
            EasyUtils.runOnAssignThread(this.mHttpRequest.getThreadSchedulers(), () -> this.dispatchDownloadSuccessCallback(true));
            return;
        }
        boolean supportResumableTransfer = false;
        long fileLength = this.mFile.length();
        if (this.mResumableTransfer && response.code() == 206 && fileLength > 0L) {
            String acceptRanges = response.header("Accept-Ranges");
            String contentRange = response.header("Content-Range");
            if (acceptRanges != null && !acceptRanges.isEmpty()) {
                supportResumableTransfer = "bytes".equalsIgnoreCase(acceptRanges);
            } else if (contentRange != null && !contentRange.isEmpty()) {
                supportResumableTransfer = contentRange.matches("bytes\\s+\\d+-\\d+/\\d+");
            }
        }
        if ((parentFile = this.mFile.getParentFile()) != null) {
            EasyUtils.createFolder(parentFile);
        }
        if ((body = response.body()) == null) {
            throw new NullBodyException("The response body is empty");
        }
        this.mTotalByte.set(body.contentLength());
        if (this.mTotalByte.get() < 0L) {
            this.mTotalByte.set(0L);
        }
        this.mDownloadByte.set(0L);
        byte[] bytes = new byte[8192];
        InputStream responeInputStream = body.byteStream();
        OutputStream fileOutputStream = EasyUtils.openFileOutputStream(this.mFile, supportResumableTransfer);
        if (supportResumableTransfer) {
            this.mDownloadByte.addAndGet(fileLength);
            if (this.mTotalByte.get() > 0L) {
                this.mTotalByte.addAndGet(fileLength);
            }
            EasyUtils.runOnAssignThread(this.mHttpRequest.getThreadSchedulers(), this::dispatchDownloadByteChangeCallback);
        }
        while ((readLength = responeInputStream.read(bytes)) != -1) {
            this.mDownloadByte.addAndGet(readLength);
            fileOutputStream.write(bytes, 0, readLength);
            EasyUtils.runOnAssignThread(this.mHttpRequest.getThreadSchedulers(), this::dispatchDownloadByteChangeCallback);
        }
        fileOutputStream.flush();
        EasyUtils.closeStream(responeInputStream);
        EasyUtils.closeStream(fileOutputStream);
        EasyUtils.closeStream((Closeable)response);
        String md52 = EasyUtils.getFileMd5(EasyUtils.openFileInputStream(this.mFile));
        if (this.mMd5 != null && !this.mMd5.isEmpty() && !this.mMd5.equalsIgnoreCase(md52)) {
            throw new FileMd5Exception("File md5 hash verify failure", md52);
        }
        EasyUtils.runOnAssignThread(this.mHttpRequest.getThreadSchedulers(), () -> this.dispatchDownloadSuccessCallback(false));
    }

    @Override
    protected void onHttpFailure(Throwable throwable) {
        EasyLog.printThrowable(this.mHttpRequest, throwable);
        Throwable finalThrowable = this.mHttpRequest.getRequestHandler().downloadFail(this.mHttpRequest, throwable);
        if (finalThrowable != throwable) {
            EasyLog.printThrowable(this.mHttpRequest, finalThrowable);
        }
        EasyUtils.runOnAssignThread(this.mHttpRequest.getThreadSchedulers(), () -> this.dispatchDownloadFailCallback(finalThrowable));
    }

    public boolean verifyFileMd5() {
        try {
            return this.mFile.isFile() && this.mMd5 != null && !this.mMd5.isEmpty() && this.mMd5.equalsIgnoreCase(EasyUtils.getFileMd5(EasyUtils.openFileInputStream(this.mFile)));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void dispatchDownloadStartCallback() {
        if (this.mListener != null && HttpLifecycleManager.isLifecycleActive(this.mHttpRequest.getLifecycleOwner())) {
            this.mListener.onDownloadStart(this.mFile);
        }
        EasyLog.printLog(this.mHttpRequest, "Download file start, file path = " + this.mFile.getPath());
    }

    public void dispatchDownloadByteChangeCallback() {
        int currentProgress;
        if (this.mListener != null && HttpLifecycleManager.isLifecycleActive(this.mHttpRequest.getLifecycleOwner())) {
            this.mListener.onDownloadByteChange(this.mFile, this.mTotalByte.get(), this.mDownloadByte.get());
        }
        if ((currentProgress = EasyUtils.getProgressProgress(this.mTotalByte.get(), this.mDownloadByte.get())) == this.mDownloadProgress) {
            return;
        }
        this.mDownloadProgress = currentProgress;
        if (this.mListener != null && HttpLifecycleManager.isLifecycleActive(this.mHttpRequest.getLifecycleOwner())) {
            this.mListener.onDownloadProgressChange(this.mFile, this.mDownloadProgress);
        }
        EasyLog.printLog(this.mHttpRequest, "Download file progress change, downloaded: " + this.mDownloadByte + " / " + this.mTotalByte + ", progress: " + currentProgress + " %, file path = " + this.mFile.getPath());
    }

    public void dispatchDownloadSuccessCallback(boolean cache) {
        if (this.mListener != null && HttpLifecycleManager.isLifecycleActive(this.mHttpRequest.getLifecycleOwner())) {
            this.mListener.onDownloadSuccess(this.mFile, cache);
            this.mListener.onDownloadEnd(this.mFile);
        }
        EasyLog.printLog(this.mHttpRequest, "Download file success, file path = " + this.mFile.getPath());
    }

    public void dispatchDownloadFailCallback(Throwable throwable) {
        if (this.mListener != null && HttpLifecycleManager.isLifecycleActive(this.mHttpRequest.getLifecycleOwner())) {
            this.mListener.onDownloadFail(this.mFile, throwable);
            this.mListener.onDownloadEnd(this.mFile);
        }
        EasyLog.printLog(this.mHttpRequest, "Download file fail, file path = " + this.mFile.getPath());
    }
}

