/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.body;

import com.hjq.http.EasyUtils;
import com.hjq.http.model.ContentType;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

public class UpdateStreamRequestBody
extends RequestBody {
    private final Source mSource;
    private final MediaType mMediaType;
    private final String mKeyName;
    private final long mLength;

    public UpdateStreamRequestBody(File file) throws FileNotFoundException {
        this(Okio.source((File)file), ContentType.guessMimeType(file.getName()), file.getName(), file.length());
    }

    public UpdateStreamRequestBody(InputStream inputStream, String name) throws IOException {
        this(Okio.source((InputStream)inputStream), ContentType.STREAM, name, inputStream.available());
    }

    public UpdateStreamRequestBody(Source source, MediaType type, String name, long length) {
        this.mSource = source;
        this.mMediaType = type;
        this.mKeyName = name;
        this.mLength = length;
    }

    public MediaType contentType() {
        return this.mMediaType;
    }

    public long contentLength() {
        if (this.mLength == 0L) {
            return -1L;
        }
        return this.mLength;
    }

    public void writeTo(BufferedSink sink) throws IOException {
        try {
            sink.writeAll(this.mSource);
        }
        finally {
            EasyUtils.closeStream((Closeable)this.mSource);
        }
    }

    public String getKeyName() {
        return this.mKeyName;
    }
}

