/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.LruCache;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.hjq.http.EasyConfig;
import com.hjq.http.annotation.HttpIgnore;
import com.hjq.http.annotation.HttpRename;
import com.hjq.http.body.WrapperRequestBody;
import com.hjq.http.model.FileContentResolver;
import com.hjq.http.model.ThreadSchedulers;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.net.URLEncoder;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class EasyUtils {
    private static final Handler HANDLER = new Handler(Looper.getMainLooper());
    private static final LruCache<Class<?>, List<Field>> CLASS_LIST_LRU_CACHE = new LruCache(30);

    public static void runOnMainThread(Runnable runnable) {
        HANDLER.post(runnable);
    }

    public static void runOnIOThread(Runnable runnable) {
        EasyConfig.getInstance().getClient().dispatcher().executorService().execute(runnable);
    }

    public static void runOnAssignThread(ThreadSchedulers schedulers, Runnable runnable) {
        switch (schedulers) {
            case IO: {
                if (EasyUtils.isMainThread()) {
                    EasyUtils.runOnIOThread(runnable);
                    break;
                }
                runnable.run();
                break;
            }
            default: {
                if (EasyUtils.isMainThread()) {
                    runnable.run();
                    break;
                }
                EasyUtils.runOnMainThread(runnable);
            }
        }
    }

    public static void postDelayedRunnable(Runnable runnable, long delayMillis) {
        HANDLER.postDelayed(runnable, delayMillis);
    }

    public static void postDelayedRunnable(Runnable runnable, int what, long delayMillis) {
        Message msg = Message.obtain((Handler)HANDLER, (Runnable)runnable);
        msg.what = what;
        HANDLER.sendMessageDelayed(msg, delayMillis);
    }

    public static void removeDelayedRunnable(int what) {
        HANDLER.removeMessages(what);
    }

    public static void removeAllRunnable() {
        HANDLER.removeCallbacksAndMessages(null);
    }

    public static boolean isMainThread() {
        return Looper.getMainLooper() == Looper.myLooper();
    }

    public static void closeStream(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static boolean isArrayType(Object object) {
        return object.getClass().isArray();
    }

    public static boolean isBeanType(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Enum) {
            return false;
        }
        if (EasyUtils.isArrayType(object)) {
            return false;
        }
        return !(object instanceof Number) && !(object instanceof CharSequence) && !(object instanceof Boolean) && !(object instanceof File) && !(object instanceof InputStream) && !(object instanceof RequestBody) && !(object instanceof Character) && !(object instanceof JSONObject) && !(object instanceof JSONArray);
    }

    public static boolean isMultipartParameter(List<Field> fields) {
        for (Field field : fields) {
            field.setAccessible(true);
            if (EasyUtils.isConstantField(field)) continue;
            Class<?> clazz = field.getType();
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i <= interfaces.length; ++i) {
                Class<?> temp = i == interfaces.length ? clazz : interfaces[i];
                if (!(List.class.equals(temp) ? EasyUtils.isMultipartClass(EasyUtils.getFieldGenericType(field, 0)) : Map.class.equals(temp) && EasyUtils.isMultipartClass(EasyUtils.getFieldGenericType(field, 1)))) continue;
                return true;
            }
            do {
                if (!EasyUtils.isMultipartClass(clazz)) continue;
                return true;
            } while ((clazz = clazz.getSuperclass()) != null && !Object.class.equals(clazz));
        }
        return false;
    }

    public static Type getFieldGenericType(Field field, int position) {
        Type type = field.getGenericType();
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        Type[] actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
        if (position >= actualTypeArguments.length) {
            return null;
        }
        Type actualType = actualTypeArguments[position];
        if (actualType instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)actualType).getUpperBounds();
            if (upperBounds.length == 0) {
                return null;
            }
            return upperBounds[0];
        }
        return actualType;
    }

    public static boolean isMultipartClass(Type type) {
        if (type == null) {
            return false;
        }
        return File.class.equals((Object)type) || FileContentResolver.class.equals((Object)type) || InputStream.class.equals((Object)type) || RequestBody.class.equals((Object)type) || MultipartBody.Part.class.equals((Object)type);
    }

    public static JSONArray listToJsonArray(List<?> list) {
        JSONArray jsonArray = new JSONArray();
        if (list == null || list.isEmpty()) {
            return jsonArray;
        }
        for (Object value : list) {
            if (value == null) continue;
            jsonArray.put(EasyUtils.convertObject(value));
        }
        return jsonArray;
    }

    public static JSONObject mapToJsonObject(Map<?, ?> map) {
        JSONObject jsonObject = new JSONObject();
        if (map == null || map.isEmpty()) {
            return jsonObject;
        }
        Set<?> keySet = map.keySet();
        for (Object key : keySet) {
            Object value = map.get(key);
            if (value == null) continue;
            try {
                jsonObject.put(String.valueOf(key), EasyUtils.convertObject(value));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return jsonObject;
    }

    public static List<Object> arrayToList(Object array) {
        ArrayList<Object> list = new ArrayList<Object>();
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object element = Array.get(array, i);
            list.add(element);
        }
        return list;
    }

    public static HashMap<String, Object> beanToHashMap(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Enum) {
            return null;
        }
        Field[] fields = object.getClass().getDeclaredFields();
        HashMap<String, Object> data = new HashMap<String, Object>(fields.length);
        for (Field field : fields) {
            field.setAccessible(true);
            if (EasyUtils.isConstantField(field)) continue;
            try {
                String key;
                Object value = field.get(object);
                if (value == null || field.isAnnotationPresent(HttpIgnore.class)) continue;
                HttpRename annotation = field.getAnnotation(HttpRename.class);
                if (annotation != null) {
                    key = annotation.value();
                } else {
                    key = field.getName();
                    if (key.matches("this\\$\\d+") || "Companion".equals(key)) continue;
                }
                data.put(key, EasyUtils.convertObject(value));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return data;
    }

    public static Object convertObject(Object object) {
        if (object instanceof List) {
            return EasyUtils.listToJsonArray((List)object);
        }
        if (object instanceof Map) {
            return EasyUtils.mapToJsonObject((Map)object);
        }
        if (object instanceof Enum) {
            return String.valueOf(object);
        }
        if (EasyUtils.isArrayType(object)) {
            return EasyUtils.listToJsonArray(EasyUtils.arrayToList(object));
        }
        if (EasyUtils.isBeanType(object)) {
            return EasyUtils.mapToJsonObject(EasyUtils.beanToHashMap(object));
        }
        return object;
    }

    public static Type getGenericType(Object object) {
        Type genericSuperclass;
        if (object == null) {
            return Void.class;
        }
        Type[] genericInterfaces = object.getClass().getGenericInterfaces();
        if (genericInterfaces.length > 0) {
            for (Type genericInterface : genericInterfaces) {
                if (!(genericInterface instanceof ParameterizedType)) continue;
                ParameterizedType parameterizedType = (ParameterizedType)genericInterface;
                return parameterizedType.getActualTypeArguments()[0];
            }
        }
        if (!((genericSuperclass = object.getClass().getGenericSuperclass()) instanceof ParameterizedType)) {
            return Void.class;
        }
        Type[] actualTypeArguments = ((ParameterizedType)genericSuperclass).getActualTypeArguments();
        if (actualTypeArguments.length == 0) {
            return Void.class;
        }
        return actualTypeArguments[0];
    }

    public static int getProgressProgress(long totalByte, long currentByte) {
        if (totalByte <= 0L) {
            return -1;
        }
        return (int)((double)currentByte / (double)totalByte * 100.0);
    }

    public static String encodeString(String text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return "";
        }
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return text;
        }
    }

    @Nullable
    public static String formatJson(@Nullable String json) {
        if (json == null) {
            return null;
        }
        try {
            if (json.startsWith("{")) {
                return EasyUtils.unescapeJson(new JSONObject(json).toString(4));
            }
            if (json.startsWith("[")) {
                return EasyUtils.unescapeJson(new JSONArray(json).toString(4));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json;
    }

    @NonNull
    public static String unescapeJson(String json) {
        if (TextUtils.isEmpty((CharSequence)json)) {
            return "";
        }
        return json.replace("\\/", "/");
    }

    @Nullable
    public static String getObjectTag(Object object) {
        if (object == null) {
            return null;
        }
        return String.valueOf(object);
    }

    public static void createFolder(File targetFolder) {
        if (targetFolder.exists()) {
            if (targetFolder.isDirectory()) {
                return;
            }
            targetFolder.delete();
        }
        targetFolder.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getFileMd5(InputStream inputStream) {
        String string;
        if (inputStream == null) {
            return "";
        }
        DigestInputStream digestInputStream = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            digestInputStream = new DigestInputStream(inputStream, messageDigest);
            byte[] buffer = new byte[262144];
            while (digestInputStream.read(buffer) > 0) {
            }
            messageDigest = digestInputStream.getMessageDigest();
            byte[] md5 = messageDigest.digest();
            StringBuilder sb = new StringBuilder();
            for (byte b : md5) {
                sb.append(String.format("%02X", b));
            }
            string = sb.toString().toLowerCase();
        }
        catch (IOException | NoSuchAlgorithmException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                EasyUtils.closeStream(inputStream);
                EasyUtils.closeStream(digestInputStream);
                throw throwable;
            }
            EasyUtils.closeStream(inputStream);
            EasyUtils.closeStream(digestInputStream);
            return null;
        }
        EasyUtils.closeStream(inputStream);
        EasyUtils.closeStream(digestInputStream);
        return string;
    }

    public static InputStream openFileInputStream(File file) throws FileNotFoundException {
        if (file instanceof FileContentResolver) {
            return ((FileContentResolver)file).openInputStream();
        }
        return new FileInputStream(file);
    }

    public static OutputStream openFileOutputStream(File file) throws FileNotFoundException {
        return EasyUtils.openFileOutputStream(file, false);
    }

    public static OutputStream openFileOutputStream(File file, boolean append) throws FileNotFoundException {
        if (file instanceof FileContentResolver) {
            return ((FileContentResolver)file).openOutputStream(append);
        }
        return new FileOutputStream(file, append);
    }

    public static boolean isConstantField(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
    }

    public static List<Field> getAllFields(Class<?> originalClass) {
        ArrayList<Field> fields = (ArrayList<Field>)CLASS_LIST_LRU_CACHE.get(originalClass);
        if (fields != null) {
            return fields;
        }
        fields = new ArrayList<Field>();
        Class<?> clazz = originalClass;
        do {
            Field[] declaredFields = clazz.getDeclaredFields();
            fields.addAll(0, Arrays.asList(declaredFields));
        } while ((clazz = clazz.getSuperclass()) != null && !Object.class.equals(clazz));
        CLASS_LIST_LRU_CACHE.put(originalClass, fields);
        return fields;
    }

    public static RequestBody findRealRequestBody(RequestBody body) {
        while (body instanceof WrapperRequestBody) {
            body = ((WrapperRequestBody)body).getRequestBody();
        }
        return body;
    }
}

