/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http;

import com.hjq.http.EasyConfig;
import com.hjq.http.request.HttpRequest;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class EasyLog {
    private static final ThreadPoolExecutor EXECUTOR = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), Executors.defaultThreadFactory(), new ThreadPoolExecutor.DiscardPolicy());

    public static void printLine(HttpRequest<?> httpRequest) {
        if (!EasyConfig.getInstance().isLogEnabled()) {
            return;
        }
        EXECUTOR.execute(() -> EasyConfig.getInstance().getLogStrategy().printLine(EasyLog.getLogTag(httpRequest)));
    }

    public static void printLog(HttpRequest<?> httpRequest, String log) {
        if (!EasyConfig.getInstance().isLogEnabled()) {
            return;
        }
        EXECUTOR.execute(() -> EasyConfig.getInstance().getLogStrategy().printLog(EasyLog.getLogTag(httpRequest), log));
    }

    public static void printJson(HttpRequest<?> httpRequest, String json) {
        if (!EasyConfig.getInstance().isLogEnabled()) {
            return;
        }
        EXECUTOR.execute(() -> EasyConfig.getInstance().getLogStrategy().printJson(EasyLog.getLogTag(httpRequest), json));
    }

    public static void printKeyValue(HttpRequest<?> httpRequest, String key, String value) {
        if (!EasyConfig.getInstance().isLogEnabled()) {
            return;
        }
        EXECUTOR.execute(() -> EasyConfig.getInstance().getLogStrategy().printKeyValue(EasyLog.getLogTag(httpRequest), key, value));
    }

    public static void printThrowable(HttpRequest<?> httpRequest, Throwable throwable) {
        if (!EasyConfig.getInstance().isLogEnabled()) {
            return;
        }
        EXECUTOR.execute(() -> EasyConfig.getInstance().getLogStrategy().printThrowable(EasyLog.getLogTag(httpRequest), throwable));
    }

    public static void printStackTrace(HttpRequest<?> httpRequest, StackTraceElement[] stackTrace) {
        if (!EasyConfig.getInstance().isLogEnabled()) {
            return;
        }
        EXECUTOR.execute(() -> EasyConfig.getInstance().getLogStrategy().printStackTrace(EasyLog.getLogTag(httpRequest), stackTrace));
    }

    private static String getLogTag(HttpRequest<?> httpRequest) {
        String logTag = EasyConfig.getInstance().getLogTag();
        if (httpRequest == null) {
            return logTag;
        }
        return logTag + " " + httpRequest.generateLogTag();
    }
}

