package com.hjq.http.ssl;

import android.annotation.SuppressLint;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;

/**
 *    author : Android 轮子哥
 *    github : https://github.com/getActivity/EasyHttp
 *    time   : 2020/11/30
 *    desc   : 证书域名校验
 */
public final class UnSafeHostnameVerifier implements HostnameVerifier {

    @SuppressLint("BadHostnameVerifier")
    @Override
    public boolean verify(String hostname, SSLSession session) {
        // 此类是用于主机名验证的基接口，在握手期间，如果 URL 的主机名和服务器的标识主机名不匹配，
        // 则验证机制可以回调此接口的实现程序来确定是否应该允许此连接，策略可以是基于证书的或依赖于其他验证方案。
        // 当验证 URL 主机名使用的默认规则失败时使用这些回调，如果主机名是可接受的，则返回 true
        return true;
    }
}