/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.ssl;

import com.hjq.http.EasyLog;
import com.hjq.http.ssl.HttpSslConfig;
import com.hjq.http.ssl.UnSafeHostnameVerifier;
import com.hjq.http.ssl.UnSafeTrustManager;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public final class HttpSslFactory {
    public static HttpSslConfig generateSslConfig() {
        return HttpSslFactory.generateSslConfigBase(null, null, null, new InputStream[0]);
    }

    public static HttpSslConfig generateSslConfig(X509TrustManager trustManager) {
        return HttpSslFactory.generateSslConfigBase(trustManager, null, null, new InputStream[0]);
    }

    public static HttpSslConfig generateSslConfig(InputStream ... certificates) {
        return HttpSslFactory.generateSslConfigBase(null, null, null, certificates);
    }

    public static HttpSslConfig generateSslConfig(InputStream bksFile, String password, InputStream ... certificates) {
        return HttpSslFactory.generateSslConfigBase(null, bksFile, password, certificates);
    }

    public static HttpSslConfig generateSslConfig(InputStream bksFile, String password, X509TrustManager trustManager) {
        return HttpSslFactory.generateSslConfigBase(trustManager, bksFile, password, new InputStream[0]);
    }

    private static HttpSslConfig generateSslConfigBase(X509TrustManager trustManager, InputStream bksFile, String password, InputStream ... certificates) {
        try {
            KeyManager[] keyManagers = HttpSslFactory.prepareKeyManager(bksFile, password);
            TrustManager[] trustManagers = HttpSslFactory.prepareTrustManager(certificates);
            X509TrustManager manager = trustManager != null ? trustManager : (trustManagers != null ? HttpSslFactory.chooseTrustManager(trustManagers) : new UnSafeTrustManager());
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, new TrustManager[]{manager}, null);
            return new HttpSslConfig(sslContext.getSocketFactory(), manager);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static KeyManager[] prepareKeyManager(InputStream bksFile, String password) {
        try {
            if (bksFile == null || password == null) {
                return null;
            }
            KeyStore keyStore = KeyStore.getInstance("BKS");
            keyStore.load(bksFile, password.toCharArray());
            KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            factory.init(keyStore, password.toCharArray());
            return factory.getKeyManagers();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            EasyLog.print(e);
            return null;
        }
    }

    private static TrustManager[] prepareTrustManager(InputStream ... certificates) {
        if (certificates == null || certificates.length <= 0) {
            return null;
        }
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null);
            int index = 0;
            for (InputStream certStream : certificates) {
                String certificateAlias = Integer.toString(index++);
                Certificate cert = certificateFactory.generateCertificate(certStream);
                keyStore.setCertificateEntry(certificateAlias, cert);
                try {
                    if (certStream == null) continue;
                    certStream.close();
                }
                catch (IOException e) {
                    EasyLog.print(e);
                }
            }
            TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            factory.init(keyStore);
            return factory.getTrustManagers();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            EasyLog.print(e);
            return null;
        }
    }

    private static X509TrustManager chooseTrustManager(TrustManager[] trustManagers) {
        for (TrustManager trustManager : trustManagers) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            return (X509TrustManager)trustManager;
        }
        return null;
    }

    public static HostnameVerifier generateUnSafeHostnameVerifier() {
        return new UnSafeHostnameVerifier();
    }
}

