/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.request;

import androidx.lifecycle.LifecycleOwner;
import com.hjq.http.EasyConfig;
import com.hjq.http.EasyLog;
import com.hjq.http.model.BodyType;
import com.hjq.http.model.CacheMode;
import com.hjq.http.model.HttpHeaders;
import com.hjq.http.model.HttpParams;
import com.hjq.http.request.BaseRequest;
import okhttp3.CacheControl;
import okhttp3.HttpUrl;
import okhttp3.Request;

public abstract class UrlRequest<T extends UrlRequest<?>>
extends BaseRequest<T> {
    public UrlRequest(LifecycleOwner lifecycleOwner) {
        super(lifecycleOwner);
    }

    @Override
    protected Request createRequest(String url, String tag, HttpParams params, HttpHeaders headers, BodyType type) {
        Request.Builder requestBuilder = new Request.Builder();
        if (tag != null) {
            requestBuilder.tag((Object)tag);
        }
        if (this.getRequestCache().getMode() == CacheMode.NO_CACHE) {
            requestBuilder.cacheControl(new CacheControl.Builder().noCache().build());
        }
        if (!headers.isEmpty()) {
            for (String string : headers.getNames()) {
                requestBuilder.addHeader(string, headers.get(string));
            }
        }
        HttpUrl.Builder urlBuilder = HttpUrl.get((String)url).newBuilder();
        if (!params.isEmpty()) {
            for (String key : params.getNames()) {
                urlBuilder.addQueryParameter(key, String.valueOf(params.get(key)));
            }
        }
        HttpUrl httpUrl = urlBuilder.build();
        requestBuilder.url(httpUrl);
        requestBuilder.method(this.getRequestMethod(), null);
        EasyLog.print("RequestUrl", String.valueOf(httpUrl));
        EasyLog.print("RequestMethod", this.getRequestMethod());
        if (EasyConfig.getInstance().isLogEnabled()) {
            if (!headers.isEmpty() || !params.isEmpty()) {
                EasyLog.print();
            }
            for (String key : headers.getNames()) {
                EasyLog.print(key, headers.get(key));
            }
            if (!headers.isEmpty() && !params.isEmpty()) {
                EasyLog.print();
            }
            for (String key : params.getNames()) {
                EasyLog.print(key, String.valueOf(params.get(key)));
            }
            if (!headers.isEmpty() || !params.isEmpty()) {
                EasyLog.print();
            }
        }
        return this.getRequestHandler().requestStart(this.getLifecycleOwner(), this.getRequestApi(), requestBuilder);
    }
}

