/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.model;

import androidx.annotation.NonNull;
import com.hjq.http.EasyLog;
import com.hjq.http.EasyUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class FileWrapper
extends File {
    public FileWrapper(@NonNull File file) {
        super(file.getPath());
    }

    public InputStream openInputStream() throws FileNotFoundException {
        return new FileInputStream(this);
    }

    public OutputStream openOutputStream() throws FileNotFoundException {
        return new FileOutputStream(this);
    }

    public static boolean createFolder(File targetFolder) {
        if (targetFolder.exists()) {
            if (targetFolder.isDirectory()) {
                return true;
            }
            targetFolder.delete();
        }
        return targetFolder.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getFileMd5(InputStream inputStream) {
        String string;
        if (inputStream == null) {
            return "";
        }
        DigestInputStream digestInputStream = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            digestInputStream = new DigestInputStream(inputStream, messageDigest);
            byte[] buffer = new byte[262144];
            while (digestInputStream.read(buffer) > 0) {
            }
            messageDigest = digestInputStream.getMessageDigest();
            byte[] md5 = messageDigest.digest();
            StringBuilder sb = new StringBuilder();
            for (byte b : md5) {
                sb.append(String.format("%02X", b));
            }
            string = sb.toString().toLowerCase();
        }
        catch (IOException | NoSuchAlgorithmException e) {
            try {
                EasyLog.print(e);
            }
            catch (Throwable throwable) {
                EasyUtils.closeStream(inputStream);
                EasyUtils.closeStream(digestInputStream);
                throw throwable;
            }
            EasyUtils.closeStream(inputStream);
            EasyUtils.closeStream(digestInputStream);
            return null;
        }
        EasyUtils.closeStream(inputStream);
        EasyUtils.closeStream(digestInputStream);
        return string;
    }
}

