/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.callback;

import com.hjq.http.EasyLog;
import com.hjq.http.EasyUtils;
import com.hjq.http.callback.BaseCallback;
import com.hjq.http.lifecycle.HttpLifecycleManager;
import com.hjq.http.listener.OnHttpListener;
import com.hjq.http.model.CacheMode;
import com.hjq.http.request.BaseRequest;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Response;

public final class NormalCallback
extends BaseCallback {
    private final BaseRequest mBaseRequest;
    private OnHttpListener mListener;

    public NormalCallback(BaseRequest request) {
        super(request);
        this.mBaseRequest = request;
    }

    public NormalCallback setListener(OnHttpListener listener) {
        this.mListener = listener;
        return this;
    }

    @Override
    public void start() {
        CacheMode cacheMode = this.mBaseRequest.getRequestCache().getMode();
        if (cacheMode != CacheMode.USE_CACHE_ONLY && cacheMode != CacheMode.USE_CACHE_FIRST) {
            super.start();
            return;
        }
        try {
            Object result = this.mBaseRequest.getRequestHandler().readCache(this.mBaseRequest.getLifecycleOwner(), this.mBaseRequest.getRequestApi(), EasyUtils.getReflectType(this.mListener));
            EasyLog.print("ReadCache result\uff1a" + result);
            if (result == null) {
                super.start();
                return;
            }
            EasyUtils.post(() -> {
                if (this.mListener == null || !HttpLifecycleManager.isLifecycleActive(this.mBaseRequest.getLifecycleOwner())) {
                    return;
                }
                this.mListener.onStart(this.getCall());
                this.mListener.onSucceed(result, true);
                this.mListener.onEnd(this.getCall());
            });
            if (cacheMode == CacheMode.USE_CACHE_FIRST) {
                EasyUtils.postDelayed(() -> {
                    if (!HttpLifecycleManager.isLifecycleActive(this.mBaseRequest.getLifecycleOwner())) {
                        return;
                    }
                    this.mListener = null;
                    super.start();
                }, 1L);
            }
        }
        catch (Throwable throwable) {
            EasyLog.print("ReadCache error");
            EasyLog.print(throwable);
            super.start();
        }
    }

    @Override
    protected void onStart(Call call) {
        EasyUtils.post(() -> {
            if (this.mListener == null || !HttpLifecycleManager.isLifecycleActive(this.mBaseRequest.getLifecycleOwner())) {
                return;
            }
            this.mListener.onStart(call);
        });
    }

    @Override
    protected void onResponse(Response response) throws Exception {
        EasyLog.print("RequestConsuming\uff1a" + (response.receivedResponseAtMillis() - response.sentRequestAtMillis()) + " ms");
        Object result = this.mBaseRequest.getRequestHandler().requestSucceed(this.mBaseRequest.getLifecycleOwner(), this.mBaseRequest.getRequestApi(), response, EasyUtils.getReflectType(this.mListener));
        CacheMode cacheMode = this.mBaseRequest.getRequestCache().getMode();
        if (cacheMode == CacheMode.USE_CACHE_ONLY || cacheMode == CacheMode.USE_CACHE_FIRST) {
            try {
                boolean writeSucceed = this.mBaseRequest.getRequestHandler().writeCache(this.mBaseRequest.getLifecycleOwner(), this.mBaseRequest.getRequestApi(), response, result);
                EasyLog.print("WriteCache result\uff1a" + writeSucceed);
            }
            catch (Throwable throwable) {
                EasyLog.print("WriteCache error");
                EasyLog.print(throwable);
            }
        }
        EasyUtils.post(() -> {
            if (this.mListener == null || !HttpLifecycleManager.isLifecycleActive(this.mBaseRequest.getLifecycleOwner())) {
                return;
            }
            this.mListener.onSucceed(result, false);
            this.mListener.onEnd(this.getCall());
        });
    }

    @Override
    protected void onFailure(Exception e) {
        if (e instanceof IOException && this.mBaseRequest.getRequestCache().getMode() == CacheMode.USE_CACHE_AFTER_FAILURE) {
            try {
                Object result = this.mBaseRequest.getRequestHandler().readCache(this.mBaseRequest.getLifecycleOwner(), this.mBaseRequest.getRequestApi(), EasyUtils.getReflectType(this.mListener));
                EasyLog.print("ReadCache result\uff1a" + result);
                if (result != null) {
                    EasyUtils.post(() -> {
                        if (this.mListener == null || !HttpLifecycleManager.isLifecycleActive(this.mBaseRequest.getLifecycleOwner())) {
                            return;
                        }
                        this.mListener.onSucceed(result, true);
                        this.mListener.onEnd(this.getCall());
                    });
                    return;
                }
            }
            catch (Throwable throwable) {
                EasyLog.print("ReadCache error");
                EasyLog.print(throwable);
            }
        }
        Exception exception = this.mBaseRequest.getRequestHandler().requestFail(this.mBaseRequest.getLifecycleOwner(), this.mBaseRequest.getRequestApi(), e);
        EasyLog.print(exception);
        EasyUtils.post(() -> {
            if (this.mListener == null || !HttpLifecycleManager.isLifecycleActive(this.mBaseRequest.getLifecycleOwner())) {
                return;
            }
            this.mListener.onFail(exception);
            this.mListener.onEnd(this.getCall());
        });
    }
}

